/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.util.MissingResourceException;

final class CollatorServiceShim
extends Collator.ServiceShim {
    private static ICULocaleService service = new CService();

    CollatorServiceShim() {
    }

    Collator getInstance(ULocale locale) {
        try {
            ULocale[] actualLoc = new ULocale[1];
            Collator coll = (Collator)service.get(locale, actualLoc);
            if (coll == null) {
                throw new MissingResourceException("Could not locate Collator data", "", "");
            }
            coll = (Collator)coll.clone();
            coll.setLocale(actualLoc[0], actualLoc[0]);
            return coll;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static class CService
    extends ICULocaleService {
        CService() {
            super("Collator");
            class CollatorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                CollatorFactory() {
                    super("com/ibm/icu/impl/data/icudt51b/coll");
                }

                protected Object handleCreate(ULocale uloc, int kind, ICUService srvc) {
                    return new RuleBasedCollator(uloc);
                }
            }
            this.registerFactory(new CollatorFactory());
            this.markDefault();
        }

        protected Object handleDefault(ICUService.Key key, String[] actualIDReturn) {
            if (actualIDReturn != null) {
                actualIDReturn[0] = "root";
            }
            try {
                return new RuleBasedCollator(ULocale.ROOT);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
    }
}

