/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.UCharacterProperty;

public final class UScript {
    private static final ScriptUsage[] usageValues = ScriptUsage.values();

    public static final int getScript(int codepoint) {
        if (codepoint >= 0 & codepoint <= 0x10FFFF) {
            int scriptX = UCharacterProperty.INSTANCE.getAdditional(codepoint, 0) & 0xC000FF;
            if (scriptX < 0x400000) {
                return scriptX;
            }
            if (scriptX < 0x800000) {
                return 0;
            }
            if (scriptX < 0xC00000) {
                return 1;
            }
            return UCharacterProperty.INSTANCE.m_scriptExtensions_[scriptX & 0xFF];
        }
        throw new IllegalArgumentException(Integer.toString(codepoint));
    }

    public static final boolean hasScript(int c, int sc) {
        int scriptX = UCharacterProperty.INSTANCE.getAdditional(c, 0) & 0xC000FF;
        if (scriptX < 0x400000) {
            return sc == scriptX;
        }
        char[] scriptExtensions = UCharacterProperty.INSTANCE.m_scriptExtensions_;
        int scx = scriptX & 0xFF;
        if (scriptX >= 0xC00000) {
            scx = scriptExtensions[scx + 1];
        }
        if (sc > Short.MAX_VALUE) {
            return false;
        }
        while (sc > scriptExtensions[scx]) {
            ++scx;
        }
        return sc == (scriptExtensions[scx] & Short.MAX_VALUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScriptUsage {
        NOT_ENCODED,
        UNKNOWN,
        EXCLUDED,
        LIMITED_USE,
        ASPIRATIONAL,
        RECOMMENDED;

    }
}

