/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;

public class Step {
    private final SQLTable from;
    private final SQLTable to;
    private final Map<SQLField, Link.Direction> fields;
    private final SQLField singleField;

    public static final Step create(SQLTable start, SQLField fField, Link.Direction direction) throws IllegalArgumentException {
        Link.Direction nonNullDir;
        Link l = fField.getDBSystemRoot().getGraph().getForeignLink(fField);
        if (l == null) {
            throw new IllegalArgumentException(fField + " is not a foreign field.");
        }
        SQLTable end = l.oppositeVertex(start);
        SQLTable fieldStart = fField.getTable();
        Link.Direction computedDirection = start == end ? Link.Direction.ANY : Link.Direction.fromForeign(fieldStart == start);
        if (computedDirection == Link.Direction.ANY && direction == Link.Direction.ANY) {
            throw new IllegalArgumentException("the field references its table: " + fField + ", you must specify the direction");
        }
        if (direction != Link.Direction.ANY && computedDirection != Link.Direction.ANY && direction != computedDirection) {
            throw new IllegalArgumentException("wrong direction: " + (Object)((Object)direction) + ", real is : " + (Object)((Object)computedDirection));
        }
        Link.Direction direction2 = nonNullDir = direction == Link.Direction.ANY ? computedDirection : direction;
        assert (nonNullDir != Link.Direction.ANY);
        return new Step(start, fField, nonNullDir, end);
    }

    private Step(SQLTable start, Map<SQLField, Link.Direction> fields, SQLField singleField, SQLTable end) {
        assert (start != null && end != null);
        assert (fields.size() > 0);
        assert (CollectionUtils.getSole(fields.keySet()) == singleField);
        assert (!new HashSet<Link.Direction>(fields.values()).contains((Object)Link.Direction.ANY)) : "some directions are unknown : " + fields;
        assert (fields instanceof AbstractMap) : "Fields might not be thread-safe";
        this.from = start;
        this.to = end;
        this.fields = Collections.unmodifiableMap(fields);
        this.singleField = singleField;
    }

    private Step(SQLTable start, Map<SQLField, Link.Direction> fields, SQLTable end) {
        this(start, new HashMap<SQLField, Link.Direction>(fields), CollectionUtils.getSole(fields.keySet()), end);
    }

    private Step(SQLTable start, SQLField field, Link.Direction foreign, SQLTable end) {
        this(start, Collections.singletonMap(field, foreign), field, end);
    }

    public final Step reverse() {
        HashMap<SQLField, Link.Direction> reverseFields = new HashMap<SQLField, Link.Direction>(this.fields.size());
        for (Map.Entry<SQLField, Link.Direction> e : this.fields.entrySet()) {
            reverseFields.put(e.getKey(), e.getValue().reverse());
        }
        return new Step(this.to, reverseFields, this.from);
    }

    public final SQLTable getFrom() {
        return this.from;
    }

    public final SQLTable getTo() {
        return this.to;
    }

    public final Set<SQLField> getFields() {
        return this.fields.keySet();
    }

    public final SQLField getSingleField() {
        return this.singleField;
    }

    public final boolean isForeign(SQLField f) {
        return this.getDirection(f) == Link.Direction.FOREIGN;
    }

    public final Link.Direction getDirection(SQLField f) {
        return this.fields.get(f);
    }

    public final Boolean isForeign() {
        Link.Direction soleDir = this.getDirection();
        return soleDir == Link.Direction.ANY ? null : Boolean.valueOf(soleDir == Link.Direction.FOREIGN);
    }

    public final Link.Direction getDirection() {
        Link.Direction soleDir = CollectionUtils.getSole(new HashSet<Link.Direction>(this.fields.values()));
        return soleDir == null ? Link.Direction.ANY : soleDir;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " from: " + this.getFrom() + " to: " + this.getTo() + "\n" + this.fields;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Step) {
            Step o = (Step)obj;
            return this.from.equals(o.from) && this.fields.equals(o.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }
}

