/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableListenerData;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.LinkedIdentitySet;
import org.openconcerto.utils.cc.TransformedMap;
import org.openconcerto.utils.convertor.NumberConvertor;

public final class SQLRowValues
extends SQLRowAccessor {
    public static final Object SQL_DEFAULT = new Object(){

        public String toString() {
            return String.valueOf(SQLRowValues.class.getSimpleName()) + ".SQL_DEFAULT";
        }
    };
    public static final Object SQL_EMPTY_LINK = new Object(){

        public String toString() {
            return String.valueOf(SQLRowValues.class.getSimpleName()) + ".SQL_EMPTY_LINK";
        }
    };
    private static boolean checkValidity = true;
    private final Map<String, Object> values = new LinkedHashMap<String, Object>(8);
    private final Map<String, SQLRowValues> foreigns = new HashMap<String, SQLRowValues>(4);
    private final CollectionMap<SQLField, SQLRowValues> referents = new CollectionMap<SQLField, SQLRowValues>(4){

        @Override
        public Collection<SQLRowValues> createCollection(Collection coll) {
            return coll == null ? new LinkedIdentitySet<SQLRowValues>() : new LinkedIdentitySet(coll);
        }
    };
    private SQLRowValuesCluster graph = new SQLRowValuesCluster(this);
    private CollectionMap<SQLField, ReferentChangeListener> referentsListener = null;

    public SQLRowValues(SQLTable t) {
        super(t);
    }

    public SQLRowValues(SQLTable t, Map<String, ?> values) {
        this(t);
        this.setAll(values);
    }

    public SQLRowValues(SQLRowValues vals, ForeignCopyMode copyForeigns) {
        this(vals.getTable());
        this.setAll(vals.getAllValues(copyForeigns));
    }

    public final SQLRowValues deepCopy() {
        return this.getGraph().deepCopy(this);
    }

    private synchronized void updateLinks(String fieldName, Object old, Object value) {
        SQLRowValues vals;
        boolean oldRowVals = old instanceof SQLRowValues;
        boolean newRowVals = value instanceof SQLRowValues;
        if (!oldRowVals && !newRowVals) {
            return;
        }
        SQLField f = this.getTable().getField(fieldName);
        if (oldRowVals) {
            vals = (SQLRowValues)old;
            vals.referents.remove(f, this);
            this.foreigns.remove(fieldName);
            assert (this.graph == vals.graph);
            this.graph.remove(this, f, vals);
            vals.fireRefChange(f, false, this);
        }
        if (newRowVals) {
            vals = (SQLRowValues)value;
            vals.referents.put((Object)f, (Object)this);
            this.foreigns.put(fieldName, vals);
            this.graph.add(this, f, vals);
            assert (this.graph == vals.graph);
            vals.fireRefChange(f, true, this);
        }
    }

    public final synchronized SQLRowValuesCluster getGraph() {
        return this.graph;
    }

    public final <T> void walkGraph(T acc, ITransformer<SQLRowValuesCluster.State<T>, T> closure) {
        this.getGraph().walk(this, acc, closure);
    }

    void setGraph(SQLRowValuesCluster g) {
        assert (g != null);
        this.graph = g;
    }

    final Map<String, SQLRowValues> getForeigns() {
        return Collections.unmodifiableMap(this.foreigns);
    }

    final Map<SQLField, SQLRowValues> getForeignsBySQLField() {
        return new TransformedMap<String, SQLField, SQLRowValues>(this.getForeigns(), new ITransformer<String, SQLField>(){

            @Override
            public SQLField transformChecked(String input) {
                return SQLRowValues.this.getTable().getField(input);
            }
        }, new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return input.getName();
            }
        });
    }

    final CollectionMap<SQLField, SQLRowValues> getReferents() {
        return this.referents;
    }

    public Collection<SQLRowValues> getReferentRows() {
        return this.referents.createCollection(this.referents.values());
    }

    public Set<SQLRowValues> getReferentRows(SQLField refField) {
        return (Set)this.referents.getNonNull(refField);
    }

    public final SQLRowValues clearReferents() {
        return this.changeReferents(null, false);
    }

    private final SQLRowValues changeReferents(SQLField f, boolean retain) {
        if (f != null || !retain) {
            for (Map.Entry<SQLField, Collection<SQLRowValues>> e : CopyUtils.copy(this.getReferents()).entrySet()) {
                if (f != null && e.getKey().equals(f) == retain) continue;
                for (SQLRowValues ref : e.getValue()) {
                    ref.put(e.getKey().getName(), null);
                }
            }
        }
        return this;
    }

    public SQLRowValues retainReferent(SQLRowValues toRetain) {
        return this.retainReferents(Collections.singleton(toRetain));
    }

    public SQLRowValues retainReferents(Collection<SQLRowValues> toRetain) {
        toRetain = CollectionUtils.toIdentitySet(toRetain);
        for (Map.Entry<SQLField, Collection<SQLRowValues>> e : CopyUtils.copy(this.getReferents()).entrySet()) {
            for (SQLRowValues ref : e.getValue()) {
                if (toRetain.contains(ref)) continue;
                ref.put(e.getKey().getName(), null);
            }
        }
        return this;
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public final int getID() {
        Number res = this.getIDNumber();
        if (res != null) {
            return res.intValue();
        }
        return -1;
    }

    public final Number getIDNumber() {
        Object res = this.getObject(this.getTable().getKey().getName());
        if (res instanceof Number) {
            return (Number)res;
        }
        return null;
    }

    @Override
    public final Object getObject(String fieldName) {
        return this.values.get(fieldName);
    }

    @Override
    public Map<String, Object> getAbsolutelyAll() {
        return this.getAllValues(ForeignCopyMode.COPY_ROW);
    }

    protected final Map<String, Object> getAllValues(ForeignCopyMode copyForeigns) {
        Map<String, Object> toAdd;
        if (copyForeigns == ForeignCopyMode.COPY_ROW || this.foreigns.size() == 0) {
            toAdd = this.values;
        } else {
            Set<Map.Entry<String, Object>> entrySet = this.values.entrySet();
            toAdd = new LinkedHashMap<String, Object>(entrySet.size());
            for (Map.Entry<String, Object> e : entrySet) {
                if (!(e.getValue() instanceof SQLRowValues)) {
                    toAdd.put(e.getKey(), e.getValue());
                    continue;
                }
                if (copyForeigns == ForeignCopyMode.NO_COPY) continue;
                SQLRowValues foreign = (SQLRowValues)e.getValue();
                if (foreign.hasID()) {
                    toAdd.put(e.getKey(), foreign.getIDNumber());
                    continue;
                }
                if (copyForeigns != ForeignCopyMode.COPY_ID_OR_ROW) continue;
                toAdd.put(e.getKey(), foreign);
            }
        }
        return Collections.unmodifiableMap(toAdd);
    }

    private final SQLTable getForeignTable(String fieldName) throws IllegalArgumentException {
        DatabaseGraph graph = this.getTable().getDBSystemRoot().getGraph();
        SQLTable foreignTable = graph.getForeignTable(this.getTable().getField(fieldName));
        if (foreignTable == null) {
            throw new IllegalArgumentException(String.valueOf(fieldName) + " is not a foreign key of " + this.getTable());
        }
        return foreignTable;
    }

    public Set<String> getFields() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public final boolean hasID() {
        return this.getIDNumber() != null;
    }

    @Override
    public final SQLRow asRow() {
        if (!this.hasID()) {
            throw new IllegalStateException(this + " has no ID");
        }
        return new SQLRow(this.getTable(), this.getAllValues(ForeignCopyMode.COPY_ID_OR_RM));
    }

    private final SQLRowValues changeFields(Collection<String> fields, boolean retain) {
        if (retain && fields == null) {
            return this;
        }
        if (!retain && fields == null && this.size() == 0) {
            return this;
        }
        HashSet<String> toRm = new HashSet<String>(this.values.keySet());
        if (fields != null) {
            if (retain) {
                toRm.removeAll(fields);
            } else {
                toRm.retainAll(fields);
            }
        }
        if (toRm.isEmpty()) {
            return this;
        }
        Set<String> fks = this.getTable().getForeignKeysNames();
        for (String fieldName : toRm) {
            if (!fks.contains(fieldName)) continue;
            this._put(fieldName, null);
        }
        if (fields == null) {
            assert (!retain && toRm.equals(this.values.keySet()));
            this.values.clear();
        } else {
            this.values.keySet().removeAll(toRm);
        }
        this.getGraph().fireModification(this, toRm);
        return this;
    }

    public final SQLRowValues removeAll(Collection<String> fields) {
        return this.changeFields(fields, false);
    }

    public final void clear() {
        this.removeAll(null);
    }

    private Map<String, Object> clearPrimaryKeys(Map<String, Object> values) {
        return this.clearFields(values, this.getTable().getPrimaryKeys());
    }

    private Map<String, Object> clearFields(Map<String, Object> values, Set<SQLField> fields) {
        return this.changeFields(values, fields, false);
    }

    private Map<String, Object> changeFields(Map<String, Object> values, Set<SQLField> fields, boolean retain) {
        Iterator<String> iter = values.keySet().iterator();
        while (iter.hasNext()) {
            String fieldName = iter.next();
            if (!(fields.contains(this.getTable().getField(fieldName)) ^ retain)) continue;
            iter.remove();
        }
        return values;
    }

    public SQLRowValues put(String fieldName, Object value) {
        return this.put(fieldName, value, true);
    }

    SQLRowValues put(String fieldName, Object value, boolean checkName) {
        if (checkName && !this.getTable().contains(fieldName)) {
            throw new IllegalArgumentException(String.valueOf(fieldName) + " is not in table " + this.getTable());
        }
        this._put(fieldName, value);
        this.getGraph().fireModification(this, fieldName, value);
        return this;
    }

    private void _put(String fieldName, Object value) {
        if (value == SQL_EMPTY_LINK) {
            value = this.getForeignTable(fieldName).getUndefinedIDNumber();
        }
        assert (this.check(fieldName, value));
        this.updateLinks(fieldName, this.values.put(fieldName, value), value);
    }

    private boolean check(String fieldName, Object value) {
        if (value == null || value == SQL_DEFAULT) {
            return true;
        }
        SQLField field = this.getTable().getField(fieldName);
        Class<?> javaType = field.getType().getJavaType();
        if (value instanceof Number) {
            this.checkGroup(Number.class, value, field, javaType);
        } else if (value instanceof Date) {
            this.checkGroup(Date.class, value, field, javaType);
        } else if (value instanceof SQLRowValues) {
            if (!this.getTable().getForeignKeys().contains(field)) {
                throw new IllegalArgumentException("Since value is a SQLRowValues, expected a foreign key but got " + field);
            }
        } else if (!javaType.isInstance(value)) {
            throw new IllegalArgumentException("Wrong type for " + field + ", expected " + javaType + " but got " + value.getClass());
        }
        return true;
    }

    private void checkGroup(Class<?> superClass, Object value, SQLField field, Class<?> javaType) {
        if (superClass.isInstance(value)) {
            if (!superClass.isAssignableFrom(javaType)) {
                throw new IllegalArgumentException("Incompatible type for " + field + ", expected " + javaType + " but got " + value.getClass() + "(" + superClass + ")");
            }
        } else {
            throw new IllegalStateException("value is not an instance of the superclass for " + field);
        }
    }

    public SQLRowValues put(String fieldName, int value) {
        return this.put(fieldName, (Object)value);
    }

    public SQLRowValues putEmptyLink(String fieldName) {
        return this.put(fieldName, SQL_EMPTY_LINK);
    }

    public final SQLRowValues setID(Number id) {
        return this.setID(id, false);
    }

    public final SQLRowValues setID(Number id, boolean convert) {
        SQLField key = this.getTable().getKey();
        if (convert) {
            id = NumberConvertor.convert(id, key.getType().getJavaType().asSubclass(Number.class));
        }
        return this.put(key.getName(), id);
    }

    public final SQLRowValues setAll(Map<String, ?> m) {
        return this.loadAll(m, true);
    }

    public final SQLRowValues putAll(Map<String, ?> m) {
        return this.loadAll(m, false);
    }

    private final SQLRowValues loadAll(Map<String, ?> m, boolean clear) {
        if (!this.getTable().getFieldsName().containsAll(m.keySet())) {
            throw new IllegalArgumentException("fields " + m.keySet() + " are not a subset of " + this.getTable() + " : " + this.getTable().getFieldsName());
        }
        if (clear) {
            this.clear();
        }
        for (Map.Entry<String, ?> e : m.entrySet()) {
            this._put(e.getKey(), e.getValue());
        }
        this.getGraph().fireModification(this, m);
        return this;
    }

    public final SQLRowValues setAllToNull() {
        HashMap<String, Object> nullMap = new HashMap<String, Object>();
        for (SQLField f : this.getTable().getFields()) {
            nullMap.put(f.getName(), null);
        }
        return this.setAll(nullMap);
    }

    private void fireRefChange(SQLField f, boolean put, SQLRowValues vals) {
        if (this.referentsListener != null || this.getGraph().referentFireNeeded(put)) {
            ReferentChangeEvent evt = new ReferentChangeEvent(f, put, vals);
            if (this.referentsListener != null) {
                for (ReferentChangeListener l : this.referentsListener.getNonNull(f)) {
                    l.referentChange(evt);
                }
                for (ReferentChangeListener l : this.referentsListener.getNonNull(null)) {
                    l.referentChange(evt);
                }
            }
            this.getGraph().fireModification(evt);
        }
    }

    public final SQLRowValues followPath(Path p) {
        return this.followPath(p, false);
    }

    private final SQLRowValues followPath(Path p, boolean create) {
        Collection<SQLRowValues> res = this.followPath(p, create ? CreateMode.CREATE_ONE : CreateMode.CREATE_NONE, true);
        assert (res.size() <= 1);
        return CollectionUtils.getSole(res);
    }

    public final Collection<SQLRowValues> followPath(Path p, CreateMode create, boolean onlyOne) {
        if (p.getFirst() != this.getTable()) {
            throw new IllegalArgumentException("path " + p + " doesn't start with us " + this);
        }
        if (p.length() > 0) {
            if (onlyOne && create == CreateMode.CREATE_MANY && !p.isSingleLink()) {
                throw new IllegalStateException("more than one link with " + (Object)((Object)create) + " and onlyOne : " + p);
            }
            LinkedIdentitySet<SQLRowValues> next = new LinkedIdentitySet<SQLRowValues>();
            Step firstStep = p.getStep(0);
            Set<SQLField> ffs = firstStep.getFields();
            for (SQLField ff : ffs) {
                SQLRowValues nextOne;
                if (firstStep.isForeign(ff)) {
                    Object fkValue = this.getObject(ff.getName());
                    if (fkValue instanceof SQLRowValues) {
                        next.add((SQLRowValues)fkValue);
                        continue;
                    }
                    if (create != CreateMode.CREATE_ONE && create != CreateMode.CREATE_MANY) continue;
                    assert (create == CreateMode.CREATE_MANY || create == CreateMode.CREATE_ONE && next.size() <= 1);
                    if (create == CreateMode.CREATE_ONE && next.size() == 1) {
                        nextOne = (SQLRowValues)next.iterator().next();
                    } else {
                        nextOne = new SQLRowValues(ff.getDBSystemRoot().getGraph().getForeignTable(ff));
                        if (fkValue instanceof Number) {
                            nextOne.setID((Number)fkValue);
                        }
                        next.add(nextOne);
                    }
                    this.put(ff.getName(), nextOne);
                    continue;
                }
                Set<SQLRowValues> referentRows = this.getReferentRows(ff);
                if (referentRows.size() > 0) {
                    next.addAll(referentRows);
                    continue;
                }
                if (create != CreateMode.CREATE_ONE && create != CreateMode.CREATE_MANY) continue;
                assert (create == CreateMode.CREATE_MANY || create == CreateMode.CREATE_ONE && next.size() <= 1);
                if (create == CreateMode.CREATE_ONE && next.size() == 1) {
                    nextOne = (SQLRowValues)next.iterator().next();
                } else {
                    nextOne = new SQLRowValues(ff.getTable());
                    next.add(nextOne);
                }
                nextOne.put(ff.getName(), this);
            }
            if (onlyOne && next.size() > 1) {
                throw new IllegalStateException("more than one row and onlyOne=true : " + next);
            }
            LinkedIdentitySet<SQLRowValues> res = new LinkedIdentitySet<SQLRowValues>();
            for (SQLRowValues n : next) {
                res.addAll(n.followPath(p.minusFirst(), create, onlyOne));
            }
            return res;
        }
        return Collections.singleton(this);
    }

    public void loadAbsolutelyAll(SQLRow row) {
        this.setAll(row.getAbsolutelyAll());
    }

    public void load(SQLRowAccessor row, Set<String> fieldsNames) {
        HashMap<String, Object> m = new HashMap<String, Object>(row.getAbsolutelyAll());
        if (fieldsNames != null) {
            m.keySet().retainAll(fieldsNames);
        }
        if (row instanceof SQLRowValues) {
            ((SQLRowValues)row).removeAll(m.keySet());
        }
        this.putAll(m);
    }

    void checkValidity() {
        if (!checkValidity) {
            return;
        }
        Object[] pb = this.getInvalid();
        if (pb != null) {
            throw new IllegalStateException("can't update " + this + " : the field " + pb[0] + " points to " + pb[1]);
        }
    }

    public synchronized Object[] getInvalid() {
        Set<SQLField> fk = this.getTable().getForeignKeys();
        for (String fieldName : this.values.keySet()) {
            SQLRow pb;
            SQLField field = this.getTable().getField(fieldName);
            Object fieldVal = this.getObject(fieldName);
            if (!fk.contains(field) || fieldVal == SQL_DEFAULT || fieldVal instanceof SQLRowValues || (pb = this.getTable().checkValidity(field.getName(), (Number)fieldVal)) == null) continue;
            return new Object[]{fieldName, pb};
        }
        return null;
    }

    public synchronized SQLRow insert() throws SQLException {
        return this.insert(false, false);
    }

    public synchronized SQLRow insert(boolean insertPK, boolean insertOrder) throws SQLException {
        this.getGraph().store(new SQLRowValuesCluster.Insert(insertPK, insertOrder));
        return this.getGraph().getRow(this);
    }

    SQLTableEvent insertJustThis(Set<SQLField> autoFields) throws SQLException {
        final Map<String, Object> copy = this.clearFields(new HashMap<String, Object>(this.values), autoFields);
        try {
            Tuple2<List<String>, Number> fieldsAndID = this.getTable().getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Tuple2<List<String>, Number>, SQLException>(){

                @Override
                public Tuple2<List<String>, Number> handle(SQLDataSource ds) throws SQLException {
                    Tuple2 pStmt = SQLRowValues.createInsertStatement(SQLRowValues.this.getTable(), copy);
                    try {
                        Number newID = SQLRowValues.insert((PreparedStatement)pStmt.get0(), SQLRowValues.this.getTable());
                        ((PreparedStatement)pStmt.get0()).close();
                        return Tuple2.create((List)pStmt.get1(), newID);
                    }
                    catch (Exception e) {
                        throw new SQLException("Unable to insert " + pStmt.get0(), e);
                    }
                }
            });
            assert (this.getTable().isRowable() == (fieldsAndID.get1() != null));
            if (this.getTable().isRowable()) {
                return new SQLTableEvent(this.getChangedRow(fieldsAndID.get1().intValue()), SQLTableEvent.Mode.ROW_ADDED, (Collection<String>)fieldsAndID.get0());
            }
            return new SQLTableEvent(this.getTable(), -1, SQLTableEvent.Mode.ROW_ADDED, (Collection<String>)fieldsAndID.get0());
        }
        catch (SQLException e) {
            throw new SQLException("unable to insert " + this + " using " + copy, e);
        }
    }

    private SQLRow getChangedRow(int newID) {
        return new SQLRow(this.getTable(), newID).fetchValues(false);
    }

    public SQLRow update() throws SQLException {
        if (!this.hasID()) {
            throw new IllegalStateException("can't update no ID specified, use update(int)");
        }
        return this.update(this.getID());
    }

    public SQLRow update(int id) throws SQLException {
        this.put(this.getTable().getKey().getName(), id);
        return this.commit();
    }

    SQLTableEvent updateJustThis(final int id) throws SQLException {
        if (id == this.getTable().getUndefinedID()) {
            throw new IllegalArgumentException("can't update undefined");
        }
        final Map<String, Object> updatedValues = this.clearPrimaryKeys(new HashMap<String, Object>(this.values));
        List<String> updatedCols = this.getTable().getDBSystemRoot().getDataSource().useConnection(new ConnectionHandlerNoSetup<List<String>, SQLException>(){

            @Override
            public List<String> handle(SQLDataSource ds) throws SQLException {
                Tuple2 pStmt = SQLRowValues.createUpdateStatement(SQLRowValues.this.getTable(), updatedValues, id);
                ((PreparedStatement)pStmt.get0()).executeUpdate();
                ((PreparedStatement)pStmt.get0()).close();
                return (List)pStmt.get1();
            }
        });
        return new SQLTableEvent(this.getChangedRow(id), SQLTableEvent.Mode.ROW_UPDATED, updatedCols);
    }

    public SQLRow commit() throws SQLException {
        this.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT);
        return this.getGraph().getRow(this);
    }

    SQLTableEvent commitJustThis() throws SQLException {
        if (!this.hasID()) {
            return this.insertJustThis(Collections.<SQLField>emptySet());
        }
        return this.updateJustThis(this.getID());
    }

    public String toString() {
        String result = String.valueOf(this.getClass().getSimpleName()) + " on " + this.getTable() + " : {";
        result = String.valueOf(result) + CollectionUtils.join(this.values.entrySet(), ", ", new ITransformer<Map.Entry<String, ?>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, ?> e) {
                SQLRowValues foreignVals;
                String className;
                String string = className = e.getValue() == null ? "" : "(" + e.getValue().getClass() + ")";
                String value = e.getValue() instanceof SQLRowValues ? ((foreignVals = (SQLRowValues)e.getValue()) == SQLRowValues.this ? "this" : (foreignVals.hasID() ? foreignVals.getIDNumber().toString() : "@" + System.identityHashCode(foreignVals))) : String.valueOf(e.getValue());
                return String.valueOf(e.getKey()) + "=" + value + className;
            }
        });
        result = String.valueOf(result) + "}";
        return result;
    }

    public final String printTree() {
        return this.getGraph().printTree(this, 16);
    }

    public final String printGraph() {
        return this.getGraph().printNodes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLRowValues) {
            SQLRowValues o = (SQLRowValues)obj;
            return this.getTable().equals(o.getTable()) && this.values.equals(o.values);
        }
        return false;
    }

    public int hashCode() {
        return this.getTable().hashCode();
    }

    private static Tuple2<PreparedStatement, List<String>> createInsertStatement(SQLTable table, Map<String, Object> values) throws SQLException {
        Tuple2<List<String>, List<Object>> l = CollectionUtils.mapToLists(values);
        List<String> fieldsNames = l.get0();
        List<Object> vals = l.get1();
        SQLRowValues.addMetadata(fieldsNames, vals, table.getCreationUserField(), SQLRowValues.getUser());
        SQLRowValues.addMetadata(fieldsNames, vals, table.getCreationDateField(), new Timestamp(System.currentTimeMillis()));
        return SQLRowValues.createStatement(table, fieldsNames, vals, true);
    }

    private static Tuple2<PreparedStatement, List<String>> createUpdateStatement(SQLTable table, Map<String, Object> values, int id) throws SQLException {
        Tuple2<List<String>, List<Object>> l = CollectionUtils.mapToLists(values);
        List<String> fieldsNames = l.get0();
        List<Object> vals = l.get1();
        vals.add(new Integer(id));
        return SQLRowValues.createStatement(table, fieldsNames, vals, false);
    }

    private static void addMetadata(List<String> fieldsNames, List<Object> values, SQLField field, Object fieldValue) throws SQLException {
        if (field != null) {
            int index = fieldsNames.indexOf(field.getName());
            if (index < 0) {
                fieldsNames.add(0, field.getName());
                values.add(0, fieldValue);
            } else {
                values.set(index, fieldValue);
            }
        }
    }

    private static Object getUser() {
        int userID = UserManager.getUserID();
        return userID < 0 ? SQL_DEFAULT : Integer.valueOf(userID);
    }

    private static Tuple2<PreparedStatement, List<String>> createStatement(SQLTable table, List<String> fieldsNames, List<Object> values, boolean insert) throws SQLException {
        PreparedStatement pStmt;
        SQLRowValues.addMetadata(fieldsNames, values, table.getModifUserField(), SQLRowValues.getUser());
        SQLRowValues.addMetadata(fieldsNames, values, table.getModifDateField(), new Timestamp(System.currentTimeMillis()));
        String tableQuoted = table.getSQLName().quote();
        String req = String.valueOf(insert ? "INSERT INTO " : "UPDATE ") + tableQuoted + " ";
        if (insert) {
            boolean selectOrder;
            assert (fieldsNames.size() == values.size());
            int i = values.size() - 1;
            while (i >= 0) {
                if (values.get(i) == SQL_DEFAULT) {
                    fieldsNames.remove(i);
                    values.remove(i);
                }
                --i;
            }
            assert (fieldsNames.size() == values.size());
            SQLField order = table.getOrderField();
            if (order != null && !fieldsNames.contains(order.getName())) {
                fieldsNames.add(order.getName());
                selectOrder = true;
            } else {
                selectOrder = false;
            }
            if (fieldsNames.size() == 0 && table.getServer().getSQLSystem() != SQLSystem.MYSQL) {
                req = String.valueOf(req) + "DEFAULT VALUES";
            } else {
                req = String.valueOf(req) + "(" + CollectionUtils.join(fieldsNames, ", ", new ITransformer<String, String>(){

                    @Override
                    public String transformChecked(String input) {
                        return SQLBase.quoteIdentifier(input);
                    }
                }) + ")";
                String questionMarks = CollectionUtils.join(Collections.nCopies(values.size(), "?"), ", ");
                if (selectOrder) {
                    req = String.valueOf(req) + " select ";
                    req = String.valueOf(req) + questionMarks;
                    if (values.size() > 0) {
                        req = String.valueOf(req) + ", ";
                    }
                    req = String.valueOf(req) + "COALESCE(MAX(" + SQLBase.quoteIdentifier(order.getName()) + "), " + ReOrder.MIN_ORDER + ") + 1 FROM " + tableQuoted;
                } else {
                    req = String.valueOf(req) + " VALUES (";
                    req = String.valueOf(req) + questionMarks;
                    req = String.valueOf(req) + ")";
                }
            }
            pStmt = SQLRowValues.createInsertStatement(req, table);
        } else {
            assert (fieldsNames.size() == values.size() - 1);
            ArrayList<String> fieldAndValues = new ArrayList<String>(fieldsNames.size());
            ListIterator<String> iter = fieldsNames.listIterator();
            while (iter.hasNext()) {
                String fieldName = iter.next();
                SQLField field = table.getField(fieldName);
                Object value = values.get(iter.previousIndex());
                fieldAndValues.add(String.valueOf(SQLBase.quoteIdentifier(field.getName())) + "= " + SQLRowValues.getFieldValue(value));
            }
            req = String.valueOf(req) + "SET " + CollectionUtils.join(fieldAndValues, ", ");
            req = String.valueOf(req) + " WHERE " + table.getKey().getFieldRef() + "= ?";
            Connection c = table.getBase().getDataSource().getConnection();
            pStmt = c.prepareStatement(req);
        }
        int i = 0;
        for (Object value : values) {
            if (value == SQL_DEFAULT) continue;
            Object toIns = value instanceof SQLRowValues ? ((SQLRowValues)value).insert().getIDNumber() : value;
            if (toIns instanceof Date) {
                pStmt.setObject(i + 1, new Timestamp(((Date)toIns).getTime()));
            } else {
                pStmt.setObject(i + 1, toIns);
            }
            ++i;
        }
        return Tuple2.create(pStmt, fieldsNames);
    }

    private static String getFieldValue(Object value) {
        return value == SQL_DEFAULT ? "DEFAULT" : "?";
    }

    @Override
    public SQLTableModifiedListener createTableListener(SQLDataListener l) {
        return new SQLTableListenerData<SQLRowValues>(this, l);
    }

    public static final PreparedStatement createInsertStatement(String req, SQLTable table) throws SQLException {
        boolean isPG;
        boolean rowable = table.isRowable();
        boolean bl = isPG = table.getServer().getSQLSystem() == SQLSystem.POSTGRESQL;
        if (rowable && isPG) {
            req = String.valueOf(req) + " RETURNING " + SQLBase.quoteIdentifier(table.getKey().getName());
        }
        Connection c = table.getDBSystemRoot().getDataSource().getConnection();
        int returnGenK = rowable && !isPG && c.getMetaData().supportsGetGeneratedKeys() ? 1 : 2;
        return c.prepareStatement(req, returnGenK);
    }

    public static final Number insert(PreparedStatement pStmt, SQLTable table) throws SQLException {
        Number newID;
        pStmt.execute();
        if (table.isRowable()) {
            ResultSet rs = table.getServer().getSQLSystem() == SQLSystem.POSTGRESQL ? pStmt.getResultSet() : pStmt.getGeneratedKeys();
            try {
                if (!rs.next()) {
                    throw new IllegalStateException("no keys have been autogenerated for the successfully executed statement :" + pStmt);
                }
                newID = (Number)rs.getObject(1);
            }
            catch (SQLException exn) {
                throw new IllegalStateException("can't get autogenerated keys for the successfully executed statement :" + pStmt);
            }
        } else {
            newID = null;
        }
        return newID;
    }

    public static final int insertCount(SQLTable t, String sql) throws SQLException {
        return SQLRowValues.insert(t, sql, null).getCount();
    }

    private static final Insertion<?> insert(final SQLTable t, final String sql, final Boolean scalar) throws SQLException {
        final SQLSystem sys = t.getServer().getSQLSystem();
        if (scalar != null && sys == SQLSystem.H2) {
            throw new IllegalArgumentException("H2 use IDENTITY() which only returns the last ID: " + t.getSQLName());
        }
        if (scalar != null && sys == SQLSystem.MSSQL) {
            throw new IllegalArgumentException("In MS getUpdateCount() is correct but getGeneratedKeys() only returns the last ID: " + t.getSQLName());
        }
        return (Insertion)SQLUtils.executeAtomic(t.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Insertion<?>, SQLException>(){

            @Override
            public Insertion<?> handle(SQLDataSource ds) throws SQLException {
                Statement stmt = ds.getConnection().createStatement();
                try {
                    Insertion res;
                    int count;
                    List list;
                    ResultSet rs;
                    String insertInto = "INSERT INTO " + t.getSQLName().quote() + " " + sql;
                    if (sys == SQLSystem.POSTGRESQL) {
                        String returning = scalar != null && t.getPrimaryKeys().size() > 0 ? " RETURNING " + CollectionUtils.join(t.getPrimaryKeys(), ", ", new ITransformer<SQLField, String>(){

                            @Override
                            public String transformChecked(SQLField pk) {
                                return SQLBase.quoteIdentifier(pk.getName());
                            }
                        }) : "";
                        stmt.execute(String.valueOf(insertInto) + returning);
                        rs = stmt.getResultSet();
                    } else {
                        boolean dontGetGK = scalar == null || sys == SQLSystem.MYSQL && t.getPrimaryKeys().size() != 1;
                        stmt.execute(insertInto, dontGetGK ? 2 : 1);
                        ResultSet resultSet = rs = dontGetGK ? null : stmt.getGeneratedKeys();
                    }
                    if (rs == null || scalar == null) {
                        list = null;
                        count = stmt.getUpdateCount();
                    } else {
                        list = (List)(scalar != false ? SQLDataSource.COLUMN_LIST_HANDLER : SQLDataSource.ARRAY_LIST_HANDLER).handle(rs);
                        count = list.size();
                    }
                    Insertion insertion = res = new Insertion(list, count);
                    return insertion;
                }
                finally {
                    stmt.close();
                }
            }
        });
    }

    public static final List<SQLRowValues> trim(Collection<SQLRowValues> graphs) {
        ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(graphs.size());
        for (SQLRowValues r : graphs) {
            res.add(SQLRowValues.trim(r));
        }
        return res;
    }

    public static final SQLRowValues trim(SQLRowValues r) {
        return new SQLRowValues(r, ForeignCopyMode.COPY_ID_OR_RM);
    }

    public static enum CreateMode {
        CREATE_NONE,
        CREATE_ONE,
        CREATE_MANY;

    }

    public static enum ForeignCopyMode {
        NO_COPY,
        COPY_ID_OR_RM,
        COPY_ID_OR_ROW,
        COPY_ROW;

    }

    public static final class Insertion<T> {
        private final List<T> list;
        private final int count;

        private Insertion(List<T> res, int count) {
            this.list = res;
            this.count = count;
            assert (res == null || res.size() == count);
        }

        public final int getCount() {
            return this.count;
        }
    }

    public class ReferentChangeEvent
    extends EventObject {
        private final SQLField f;
        private final SQLRowValues vals;
        private final boolean put;

        public ReferentChangeEvent(SQLField f, boolean put, SQLRowValues vals) {
            super(SQLRowValues.this);
            assert (f != null && f.getDBSystemRoot().getGraph().getForeignTable(f) == this.getSource().getTable() && f.getTable() == vals.getTable());
            this.f = f;
            this.put = put;
            this.vals = vals;
        }

        @Override
        public SQLRowValues getSource() {
            return (SQLRowValues)super.getSource();
        }

        public final SQLField getField() {
            return this.f;
        }

        public final SQLRowValues getChangedReferent() {
            return this.vals;
        }

        public final boolean isAddition() {
            return this.put;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + (this.isAddition() ? " added" : " removed") + " on field " + this.getField() + " from " + this.getSource().asRow() + " : " + this.getChangedReferent();
        }
    }

    public static interface ReferentChangeListener
    extends EventListener {
        public void referentChange(ReferentChangeEvent var1);
    }
}

