/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.EnumOrderedSet;

public enum HierarchyLevel {
    SQLSERVER{

        @Override
        public Class<? extends DBStructureItemJDBC> getJDBCClass() {
            return SQLServer.class;
        }
    }
    ,
    SQLBASE{

        @Override
        public Class<? extends DBStructureItemJDBC> getJDBCClass() {
            return SQLBase.class;
        }
    }
    ,
    SQLSCHEMA{

        @Override
        public Class<? extends DBStructureItemJDBC> getJDBCClass() {
            return SQLSchema.class;
        }
    }
    ,
    SQLTABLE{

        @Override
        public Class<? extends DBStructureItemJDBC> getJDBCClass() {
            return SQLTable.class;
        }
    }
    ,
    SQLFIELD{

        @Override
        public Class<? extends DBStructureItemJDBC> getJDBCClass() {
            return SQLField.class;
        }
    };

    private static Map<Class<? extends DBStructureItemJDBC>, HierarchyLevel> byClass;

    private HierarchyLevel() {
    }

    abstract Class<? extends DBStructureItemJDBC> getJDBCClass();

    public static final EnumOrderedSet<HierarchyLevel> getAll() {
        return new EnumOrderedSet<HierarchyLevel>(EnumSet.allOf(HierarchyLevel.class));
    }

    static final HierarchyLevel get(Class<? extends DBStructureItemJDBC> clazz) {
        HierarchyLevel res = HierarchyLevel.getByClass().get(clazz);
        if (res != null) {
            return res;
        }
        for (Map.Entry<Class<? extends DBStructureItemJDBC>, HierarchyLevel> e : HierarchyLevel.getByClass().entrySet()) {
            if (!e.getKey().isAssignableFrom(clazz)) continue;
            return e.getValue();
        }
        throw new IllegalArgumentException(clazz + " hierarchy unknown");
    }

    private static final Map<Class<? extends DBStructureItemJDBC>, HierarchyLevel> getByClass() {
        if (byClass == null) {
            byClass = new HashMap<Class<? extends DBStructureItemJDBC>, HierarchyLevel>();
            HierarchyLevel[] hierarchyLevelArray = HierarchyLevel.values();
            int n = hierarchyLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                HierarchyLevel l = hierarchyLevelArray[n2];
                byClass.put(l.getJDBCClass(), l);
                ++n2;
            }
        }
        return byClass;
    }

    /* synthetic */ HierarchyLevel(String string, int n, HierarchyLevel hierarchyLevel) {
        this();
    }
}

