/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.config.CloudPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.InstallationPanel;
import org.openconcerto.erp.config.ServerConfigListModel;
import org.openconcerto.erp.config.ServerFinderConfig;
import org.openconcerto.erp.core.sales.pos.ui.ConfigCaissePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.ProductInfo;

public class ServerFinderPanel
extends JPanel {
    private ServerConfigListModel dataModel;
    private File confFile;
    private JComboBox comboMode;
    private JTextField textMainProperties;
    private JTextField textIP;
    private JTextField textPort;
    private JTextField textFile;
    private JTextField textBase;
    private Properties props = new Properties();
    private JButton buttonDir;
    private JTabbedPane tabbedPane;

    public static void main(String[] args) {
        System.out.println("Reading configuration from: " + ComptaPropsConfiguration.getConfFile().getAbsolutePath());
        if (System.getProperty("org.openconcerto.sql.deafState") == null) {
            System.setProperty("org.openconcerto.sql.deafState", "true");
        }
        System.setProperty("redirectToFile", "true");
        System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
        ExceptionHandler.setForceUI(true);
        ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
        ProductInfo.setInstance(new ProductInfo("OpenConcerto"));
        PropsConfiguration conf = new PropsConfiguration(new Properties()){

            @Override
            protected File createWD() {
                return new File(String.valueOf(DesktopEnvironment.getDE().getDocumentsFolder().getAbsolutePath()) + File.separator + "OpenConcerto");
            }
        };
        conf.setupLogging();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame("Configuration OpenConcerto");
                f.setDefaultCloseOperation(3);
                ServerFinderPanel panel = new ServerFinderPanel();
                panel.setConfigFile(ComptaPropsConfiguration.getConfFile());
                panel.uiInit();
                panel.loadConfigFile();
                f.setContentPane(panel);
                f.pack();
                f.setMinimumSize(new Dimension(f.getWidth(), f.getHeight()));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    public static final boolean containsValidH2DB(File dir) {
        File db;
        return dir.exists() && (db = new File(dir, "OpenConcerto.h2.db")).exists() && db.length() > 50000L;
    }

    protected void loadConfigFile() {
        this.textMainProperties.setText(this.confFile.getAbsolutePath());
        if (!this.confFile.exists()) {
            System.out.println("Unable to find: " + this.confFile.getAbsolutePath());
            File dir1 = new File(Configuration.getDefaultConfDir(), "OpenConcerto-GESTION_DEFAULT/DBData");
            File dir2 = new File(Configuration.getDefaultConfDir(), "OpenConcerto/DBData");
            if (ServerFinderPanel.containsValidH2DB(dir1)) {
                this.textFile.setText(dir1.getAbsolutePath());
            } else if (ServerFinderPanel.containsValidH2DB(dir2)) {
                this.textFile.setText(dir2.getAbsolutePath());
            }
            return;
        }
        System.out.println("Loading: " + this.confFile.getAbsolutePath());
        if (!this.confFile.isFile()) {
            JOptionPane.showMessageDialog(null, this.confFile + " n'est pas un fichier valide");
        } else if (!this.confFile.canRead()) {
            JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de lire le fichier " + this.confFile);
        } else {
            if (!this.confFile.canWrite()) {
                JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de modifier le fichier " + this.confFile);
            }
            try {
                this.props.load(new FileInputStream(this.confFile));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Impossible de lire le fichier " + this.confFile + " \n" + e.getLocalizedMessage());
            }
            String serverIp = this.props.getProperty("server.ip", "127.0.0.1:5432");
            String serverDriver = this.props.getProperty("server.driver", "postgresql").toLowerCase();
            if (serverDriver.startsWith("h2")) {
                this.updateUIForMode("H2");
            } else if (serverDriver.startsWith("mysql")) {
                this.updateUIForMode("MySQL");
                this.textPort.setText("3306");
            } else {
                this.updateUIForMode("PostgreSQL");
                this.textPort.setText("5432");
            }
            this.textBase.setText(this.props.getProperty("systemRoot", "OpenConcerto"));
            if (serverIp.contains("file:")) {
                this.textFile.setText(serverIp.substring(5));
            } else if (serverIp.contains(":")) {
                int i = serverIp.lastIndexOf(58);
                if (i > 0) {
                    this.textIP.setText(serverIp.substring(0, i));
                    this.textPort.setText(serverIp.substring(i + 1));
                }
            } else {
                this.textIP.setText(serverIp);
            }
        }
    }

    protected void saveConfigFile() {
        block33: {
            System.out.println("Saving:" + this.confFile.getAbsolutePath());
            if (this.confFile.getParentFile() != null) {
                try {
                    FileUtils.mkdir_p(this.confFile.getParentFile());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Impossible de cr\u00e9er le dossier");
                    return;
                }
            }
            if (this.confFile.exists()) {
                if (!this.confFile.isFile()) {
                    JOptionPane.showMessageDialog(null, this.confFile + " n'est pas un fichier valide");
                    return;
                }
                if (!this.confFile.canRead()) {
                    JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de lire le fichier " + this.confFile);
                    return;
                }
                if (!this.confFile.canWrite()) {
                    JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de modifier le fichier " + this.confFile);
                    return;
                }
            }
            FileOutputStream out = null;
            try {
                try {
                    String serverIp;
                    String serverDriver;
                    if (this.comboMode.getSelectedItem().equals("H2")) {
                        serverDriver = "h2";
                        String filePath = this.textFile.getText();
                        if (filePath == null || filePath.trim().length() == 0) {
                            filePath = "";
                            JOptionPane.showMessageDialog(null, "Attention. Le dossier de donn\u00e9es n'est pas rempli");
                        }
                        if (!filePath.endsWith("/")) {
                            filePath = String.valueOf(filePath) + "/";
                        }
                        serverIp = "file:" + filePath;
                    } else if (this.comboMode.getSelectedItem().equals("MySQL")) {
                        String port;
                        serverDriver = "mysql";
                        String ip = this.textIP.getText();
                        if (ip == null || ip.trim().length() == 0) {
                            ip = "127.0.0.1";
                            JOptionPane.showMessageDialog(null, "Attention. L'adresse du serveur n'est pas remplie");
                        }
                        if ((port = this.textPort.getText()) == null || port.trim().length() == 0) {
                            port = "3306";
                        }
                        serverIp = String.valueOf(ip) + ":" + port;
                    } else {
                        String port;
                        serverDriver = "postgresql";
                        String ip = this.textIP.getText();
                        if (ip == null || ip.trim().length() == 0) {
                            ip = "127.0.0.1";
                            JOptionPane.showMessageDialog(null, "Attention. L'adresse du serveur n'est pas remplie");
                        }
                        if ((port = this.textPort.getText()) == null || port.trim().length() == 0) {
                            port = "5432";
                        }
                        serverIp = String.valueOf(ip) + ":" + port;
                    }
                    this.props.put("server.driver", serverDriver);
                    this.props.put("server.ip", serverIp);
                    if (this.props.getProperty("systemRoot") == null) {
                        this.props.put("systemRoot", ComptaPropsConfiguration.APP_NAME);
                    }
                    if (this.props.getProperty("customer") == null) {
                        this.props.put("customer", "Gestion_Default");
                    }
                    out = new FileOutputStream(this.confFile);
                    this.props.store(out, "OpenConcerto");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Impossible d'\u00e9crire le fichier " + this.confFile + " \n" + e.getLocalizedMessage());
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        JOptionPane.showMessageDialog(this, "Configuration sauvegard\u00e9e.\n" + this.confFile.getAbsolutePath());
    }

    protected void deleteConfigFile() {
        if (this.confFile.exists()) {
            int ans = JOptionPane.showConfirmDialog(this, "Supprimer le fichier de configuration ?", "Confirmation", 0);
            if (ans == 0 && !this.confFile.delete()) {
                JOptionPane.showMessageDialog(this, "Impossible d'effacer le fichier " + this.confFile, "Erreur", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Rien \u00e0 effacer", null, 1);
        }
    }

    protected void setConfigFile(File f) {
        this.confFile = f;
        this.props = new Properties();
        if (f.exists()) {
            try {
                this.props.load(new FileInputStream(this.confFile));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Impossible de lire le fichier " + this.confFile + " \n" + e.getLocalizedMessage());
            }
        }
    }

    private void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, c);
        JPanel configurationPanel = this.createPanelConfig();
        JPanel findServerPanel = this.createPanelFinder();
        if (this.getToken() == null) {
            this.tabbedPane.addTab("Configuration", configurationPanel);
            this.tabbedPane.addTab("Recherche", findServerPanel);
        }
        final ConfigCaissePanel createPanelCaisse = this.createPanelCaisse();
        this.tabbedPane.addTab("Caisse", createPanelCaisse);
        this.tabbedPane.addTab("Installation", new InstallationPanel(this));
        this.tabbedPane.addTab("Cloud", new CloudPanel(this));
        if (this.getToken() != null) {
            this.tabbedPane.setSelectedIndex(2);
        }
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2, 2, 1));
        buttons.setOpaque(false);
        buttons.add(new JButton(new AbstractAction("Supprimer la configuration"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServerFinderPanel.this.deleteConfigFile();
            }
        }));
        JButton bSave = new JButton("Enregistrer la configuration");
        bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerFinderPanel.this.saveConfigFile();
                createPanelCaisse.saveConfiguration();
            }
        });
        buttons.add(bSave);
        c.weighty = 0.0;
        ++c.gridy;
        this.add((Component)buttons, c);
        this.updateUIForMode("H2");
        this.comboMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerFinderPanel.this.updateUIForMode(ServerFinderPanel.this.comboMode.getSelectedItem().toString());
            }
        });
    }

    private ConfigCaissePanel createPanelCaisse() {
        ConfigCaissePanel configCaissePanel = new ConfigCaissePanel(this);
        configCaissePanel.loadConfiguration();
        return configCaissePanel;
    }

    public void updateUIForMode(String mode) {
        if (mode.endsWith("H2")) {
            this.comboMode.setSelectedItem("H2");
            this.textIP.setEnabled(false);
            this.textPort.setEnabled(false);
            this.textFile.setEnabled(true);
            this.buttonDir.setEnabled(true);
        } else if (mode.endsWith("MySQL")) {
            this.comboMode.setSelectedItem("MySQL");
            this.textIP.setEnabled(true);
            this.textPort.setEnabled(true);
            this.textFile.setEnabled(false);
            this.buttonDir.setEnabled(false);
        } else if (mode.endsWith("PostgreSQL")) {
            this.comboMode.setSelectedItem("PostgreSQL");
            this.textIP.setEnabled(true);
            this.textPort.setEnabled(true);
            this.textFile.setEnabled(false);
            this.buttonDir.setEnabled(false);
        } else {
            throw new IllegalArgumentException(String.valueOf(mode) + " is not a valid access mode");
        }
    }

    private JPanel createPanelConfig() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 0.0;
        p.add((Component)new JLabel("Fichier de configuration", 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.textMainProperties = new JTextField("");
        this.textMainProperties.setEditable(false);
        p.add((Component)this.textMainProperties, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Type", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.comboMode = new JComboBox<String>(new String[]{"H2", "PostgreSQL", "MySQL"});
        p.add((Component)this.comboMode, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        p.add((Component)new JLabel("Adresse du serveur", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        this.textIP = new JTextField(20);
        p.add((Component)this.textIP, c);
        ++c.gridx;
        c.weightx = 0.0;
        p.add((Component)new JLabel("port", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        this.textPort = new JTextField(5);
        p.add((Component)this.textPort, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Base de donn\u00e9es", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.textBase = new JTextField();
        this.textBase.setEditable(false);
        p.add((Component)this.textBase, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        p.add((Component)new JLabel("Dossier de base de donn\u00e9es", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        c.gridwidth = 2;
        this.textFile = new JTextField();
        this.textFile.setEditable(false);
        p.add((Component)this.textFile, c);
        c.gridx += 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.buttonDir = new JButton("S\u00e9lectionner");
        this.buttonDir.setOpaque(false);
        this.buttonDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                File oldDir = new File(ServerFinderPanel.this.textFile.getText());
                if (oldDir.exists() && oldDir.isDirectory()) {
                    fc.setCurrentDirectory(oldDir);
                }
                if ((returnVal = fc.showOpenDialog(ServerFinderPanel.this)) == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        ServerFinderPanel.this.textFile.setText(file.getCanonicalPath());
                    }
                    catch (IOException e1) {
                        ServerFinderPanel.this.textFile.setText(file.getAbsolutePath());
                        e1.printStackTrace();
                    }
                }
            }
        });
        p.add((Component)this.buttonDir, c);
        c.gridx = 1;
        ++c.gridy;
        final JButton buttonTest = new JButton("Tester la connexion");
        buttonTest.setOpaque(false);
        buttonTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonTest.setEnabled(false);
                SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

                    @Override
                    public String doInBackground() {
                        ServerFinderConfig conf = ServerFinderPanel.this.createServerFinderConfig();
                        System.out.println("Testing:" + conf);
                        String test = conf.test();
                        test = test.replace("(", "\n(");
                        System.out.println(test);
                        return test;
                    }

                    @Override
                    public void done() {
                        buttonTest.setEnabled(true);
                        try {
                            String r = (String)this.get();
                            JOptionPane.showMessageDialog(ServerFinderPanel.this, r);
                        }
                        catch (InterruptedException r) {
                        }
                        catch (ExecutionException e) {
                            JOptionPane.showMessageDialog(ServerFinderPanel.this, e.getMessage());
                        }
                    }
                };
                worker.execute();
            }
        });
        c.fill = 0;
        p.add((Component)buttonTest, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        spacer.setPreferredSize(new Dimension(10, 200));
        p.add((Component)spacer, c);
        return p;
    }

    private JPanel createPanelFinder() {
        JPanel p = new JPanel();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        p.setLayout(new GridBagLayout());
        final JProgressBar bar = new JProgressBar(0, 100);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        p.add((Component)bar, c);
        final JButton searchButton = new JButton("Rechercher");
        searchButton.setOpaque(false);
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchButton.setEnabled(false);
                searchButton.setText("Recherche en cours...");
                bar.setValue(0);
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    public Void doInBackground() {
                        try {
                            ServerFinderPanel.this.dataModel.startScan(new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent evt) {
                                    final int i = (Integer)evt.getNewValue();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            bar.setValue(i);
                                        }
                                    });
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }

                    @Override
                    public void done() {
                        bar.setValue(100);
                        searchButton.setEnabled(true);
                        searchButton.setText("Rechercher");
                    }
                };
                worker.execute();
            }
        });
        c.weightx = 0.0;
        ++c.gridx;
        p.add((Component)searchButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        p.add((Component)new JLabel("Bases de donn\u00e9es disponibles:"), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.dataModel = new ServerConfigListModel();
        final JList l = new JList(this.dataModel);
        l.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel p = new JPanel();
                if (!isSelected) {
                    p.setBackground(list.getBackground());
                    p.setForeground(list.getForeground());
                } else {
                    p.setBackground(list.getSelectionBackground());
                    p.setForeground(list.getSelectionForeground());
                }
                p.setLayout(new VFlowLayout());
                ServerFinderConfig c = (ServerFinderConfig)value;
                String label = !c.getType().equals("H2") ? String.valueOf(c.getIp()) + ":" + c.getPort() + " " + c.getType() : String.valueOf(c.getFile().getAbsolutePath()) + " " + c.getType();
                JLabelBold l1 = new JLabelBold(label);
                l1.setOpaque(false);
                p.add(l1);
                JLabel l2 = new JLabel(c.getProduct() == null ? "Connexion impossible" : c.getProduct());
                l2.setOpaque(false);
                p.add(l2);
                JLabel l3 = new JLabel(c.getError() == null ? "Serveur op\u00e9rationnel" : c.getError());
                l3.setOpaque(false);
                p.add(l3);
                l1.setForeground(p.getForeground());
                l2.setForeground(p.getForeground());
                l3.setForeground(p.getForeground());
                return p;
            }
        });
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ServerFinderPanel.this.useSelectedConfig(l);
                }
            }
        });
        l.setSelectionMode(0);
        l.setBorder(BorderFactory.createEtchedBorder());
        final JButton buttonSelect = new JButton("Utiliser ce serveur");
        buttonSelect.setOpaque(false);
        buttonSelect.setEnabled(false);
        buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerFinderPanel.this.useSelectedConfig(l);
            }
        });
        l.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object sel = l.getSelectedValue();
                    System.err.println(sel + " " + ((ServerFinderConfig)sel).getError());
                    buttonSelect.setEnabled(sel != null);
                }
            }
        });
        p.add(l, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weighty = 0.0;
        p.add((Component)buttonSelect, c);
        p.setOpaque(false);
        return p;
    }

    public ServerFinderConfig getServerConfig() {
        ServerFinderConfig conf = new ServerFinderConfig();
        conf.setType(this.comboMode.getSelectedItem().toString());
        conf.setIp(this.textIP.getText());
        conf.setPort(this.textPort.getText());
        conf.setSystemRoot(this.textBase.getText());
        return conf;
    }

    private void useSelectedConfig(JList l) {
        Object sel = l.getSelectedValue();
        if (sel != null) {
            ServerFinderConfig config = (ServerFinderConfig)sel;
            this.textIP.setText(config.getIp());
            this.textPort.setText(String.valueOf(config.getPort()));
            if (config.getType().equals("H2")) {
                this.textIP.setText("");
                this.textPort.setText("");
                this.textFile.setText(config.getFile().getAbsolutePath());
            } else {
                this.textIP.setText(config.getIp());
                this.textPort.setText(String.valueOf(config.getPort()));
            }
            this.updateUIForMode(config.getType());
            this.tabbedPane.setSelectedIndex(0);
            if (((ServerFinderConfig)sel).getError() != null) {
                JOptionPane.showMessageDialog(this, "Attention. Ce serveur n'est pas configur\u00e9 correctement.");
            }
        }
    }

    public ServerFinderConfig createServerFinderConfig() {
        ServerFinderConfig conf = new ServerFinderConfig();
        conf.setType(this.comboMode.getSelectedItem().toString());
        conf.setSystemRoot(this.textBase.getText());
        if (!conf.getType().equals("H2")) {
            conf.setIp(this.textIP.getText());
            conf.setPort(this.textPort.getText());
        } else {
            File file = new File(this.textFile.getText());
            conf.setFile(file);
            conf.setIp("");
            conf.setPort("");
        }
        return conf;
    }

    public String getToken() {
        String property = this.props.getProperty("token");
        if (property != null && property.length() < 20) {
            return null;
        }
        return property;
    }

    public void setToken(String token) {
        if (token == null) {
            this.props.remove("token");
        } else {
            this.props.setProperty("token", token);
        }
    }
}

