/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public final class ValidChangeSupport {
    private final ValidObject target;
    private final List<ValidListener> listeners;
    private ValidState validState;

    public ValidChangeSupport(ValidObject target) {
        this(target, null);
    }

    public ValidChangeSupport(ValidObject target, ValidState initialState) {
        if (target == null) {
            throw new NullPointerException("null target");
        }
        this.listeners = new ArrayList<ValidListener>(3);
        this.target = target;
        this.validState = initialState;
    }

    public final ValidState getValidState() {
        return this.validState;
    }

    public final void fireValidChange(ValidState newValue) {
        if (!newValue.equals(this.validState)) {
            this.validState = newValue;
            for (ValidListener l : this.listeners) {
                l.validChange(this.target, this.validState);
            }
        }
    }

    public void addValidListener(ValidListener l) {
        this.listeners.add(l);
    }
}

