/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class DecimalUtils {
    public static final MathContext HIGH_PRECISION = new MathContext(MathContext.DECIMAL128.getPrecision(), RoundingMode.HALF_UP);

    public static int intDigits(BigDecimal d) {
        return Math.max(1, d.precision() - d.scale());
    }

    public static BigDecimal round(BigDecimal d, int decimalDigits) {
        return DecimalUtils.round(d, decimalDigits, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal d, int decimalDigits, RoundingMode rmode) {
        return d.round(new MathContext(DecimalUtils.intDigits(d) + decimalDigits, rmode));
    }
}

