/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Backup {
    private final File dest;

    public static final Logger getLogger() {
        return Logger.getLogger("org.openconcerto.backup");
    }

    public Backup(File dest) {
        this.dest = dest;
    }

    private int copy(File sourceFile, File destFile) {
        int failed;
        block18: {
            failed = 0;
            if (sourceFile.isDirectory()) {
                destFile.mkdirs();
                return 0;
            }
            try {
                if (destFile.exists()) {
                    destFile.delete();
                }
                destFile.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                FileOutputStream bufOut = new FileOutputStream(destFile);
                FileInputStream bufIn = new FileInputStream(sourceFile);
                try {
                    try {
                        int nbLecture;
                        byte[] buffer = new byte[524288];
                        while ((nbLecture = bufIn.read(buffer)) != -1) {
                            bufOut.write(buffer, 0, nbLecture);
                        }
                    }
                    catch (IOException e) {
                        Backup.getLogger().log(Level.SEVERE, "Copy Failed for file : " + sourceFile);
                        System.err.println("Failed : " + sourceFile);
                        failed = 1;
                        e.printStackTrace();
                        try {
                            bufIn.close();
                            bufOut.close();
                        }
                        catch (IOException e2) {
                            Backup.getLogger().log(Level.SEVERE, "Error to close Stream in copy." + sourceFile);
                            failed = 1;
                            e2.printStackTrace();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        bufIn.close();
                        bufOut.close();
                    }
                    catch (IOException e) {
                        Backup.getLogger().log(Level.SEVERE, "Error to close Stream in copy." + sourceFile);
                        failed = 1;
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    bufIn.close();
                    bufOut.close();
                }
                catch (IOException e) {
                    Backup.getLogger().log(Level.SEVERE, "Error to close Stream in copy." + sourceFile);
                    failed = 1;
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                Backup.getLogger().log(Level.SEVERE, "Copy Failed, File not found " + sourceFile);
                failed = 1;
                e.printStackTrace();
            }
        }
        destFile.setLastModified(sourceFile.lastModified());
        return failed;
    }

    public int applyTo(File dir) {
        Backup.getLogger().log(Level.INFO, "Copy start from " + dir + " to " + this.dest);
        return this.applyTo(dir, dir);
    }

    private int applyTo(File origine, final File dir) {
        int failed = 0;
        if (dir.exists()) {
            File[] list;
            File file = this.getFile(origine, dir);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((list = dir.listFiles()) != null) {
                int i = 0;
                while (i < list.length) {
                    File f = list[i];
                    File f2 = this.getFile(origine, f);
                    if (f.isDirectory()) {
                        if (!f2.exists()) {
                            failed += this.copy(f, f2);
                        }
                        this.applyTo(origine, f);
                    } else if (f2.exists()) {
                        boolean dateModif;
                        boolean bl = dateModif = f.lastModified() == f2.lastModified();
                        if (!dateModif || f.length() != f2.length()) {
                            failed += this.copy(f, f2);
                        } else if (!dateModif && f.length() == f2.length()) {
                            String MD5f = this.getMD5(f);
                            String MD5f2 = this.getMD5(f2);
                            boolean md5 = MD5f.equalsIgnoreCase(MD5f2);
                            if (MD5f.length() <= 0 || MD5f2.length() <= 0) {
                                if (md5) {
                                    f2.setLastModified(f.lastModified());
                                } else {
                                    failed += this.copy(f, f2);
                                }
                            } else {
                                failed += this.copy(f, f2);
                            }
                        }
                    } else {
                        failed += this.copy(f, f2);
                    }
                    ++i;
                }
            } else {
                ++failed;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Impossible de lister le r\u00e9pertoire " + dir + ".\n Vous n'avez pas les droits suffisants!");
                    }
                });
            }
        }
        return failed;
    }

    private File getFile(File origine, File f) {
        File base = origine.getParentFile() == null ? origine : origine.getParentFile();
        String s2 = base.toURI().relativize(f.toURI()).getPath();
        return new File(this.dest, s2);
    }

    private String getMD5(File f) {
        String output = "";
        try {
            FileInputStream is = new FileInputStream(f);
            try {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    is = new FileInputStream(f);
                    byte[] buffer = new byte[524288];
                    int read = 0;
                    while ((read = ((InputStream)is).read(buffer)) > 0) {
                        digest.update(buffer, 0, read);
                    }
                    byte[] md5sum = digest.digest();
                    BigInteger bigInt = new BigInteger(1, md5sum);
                    output = bigInt.toString(16);
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    Backup.getLogger().log(Level.INFO, "Unable to process file for MD5. " + f);
                    throw new RuntimeException("Unable to process file for MD5", e);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e2) {
                        Backup.getLogger().log(Level.INFO, "Unable to close file at the end of MD5. " + f);
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    Backup.getLogger().log(Level.INFO, "Unable to close file at the end of MD5. " + f);
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e1) {
            Backup.getLogger().log(Level.INFO, "File not found for MD5. " + f);
            e1.printStackTrace();
        }
        return output;
    }

    public void close() {
    }
}

