/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openconcerto.ui.PopupMouseListener;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.MutableListCombo;

public class MutableListComboPopupListener {
    private static final Set<JPopupMenu> toClose = new HashSet<JPopupMenu>();
    private static final PropertyChangeListener propL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPopupMenu src = (JPopupMenu)evt.getSource();
            if (!src.isVisible()) {
                MutableListComboPopupListener.removePopup(src);
            }
        }
    };
    private static final AWTEventListener l = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            MouseEvent me = (MouseEvent)event;
            if (me.getID() != 501 && me.getID() != 507) {
                return;
            }
            Component src = me.getComponent();
            JPopupMenu menuClicked = SwingThreadUtils.getAncestorOrSelf(JPopupMenu.class, src);
            HashSet sansClicked = new HashSet(toClose);
            if (menuClicked != null) {
                sansClicked.remove(menuClicked);
            }
            for (JPopupMenu menu : sansClicked) {
                menu.setVisible(false);
            }
        }
    };
    private final MutableListCombo combo;
    private JPopupMenu popup;

    private static void addPopup(JPopupMenu p) {
        if (toClose.add(p) && toClose.size() == 1) {
            Toolkit.getDefaultToolkit().addAWTEventListener(l, 16L);
        }
        p.addPropertyChangeListener("visible", propL);
    }

    private static void removePopup(JPopupMenu p) {
        p.removePropertyChangeListener("visible", propL);
        if (toClose.remove(p) && toClose.size() == 0) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(l);
        }
    }

    public MutableListComboPopupListener(MutableListCombo combo) {
        this.combo = combo;
        this.popup = null;
    }

    public void listen() {
        this.combo.getPopupComp().addMouseListener(new PopupMouseListener(){

            @Override
            protected JPopupMenu createPopup(MouseEvent e) {
                return MutableListComboPopupListener.this.getPopup(e);
            }
        });
    }

    protected final JPopupMenu getPopup(MouseEvent ev) {
        boolean displayPopup;
        if (!this.combo.getPopupComp().isEnabled()) {
            return null;
        }
        boolean bl = displayPopup = this.combo.getMode().isListMutable() || ev.isControlDown() && this.combo.getMode() == ComboLockedMode.ITEMS_LOCKED;
        if (!displayPopup) {
            return null;
        }
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            JMenuItem menu1 = new JMenuItem("Ajouter \u00e0 la liste");
            this.popup.add(menu1);
            menu1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MutableListComboPopupListener.this.combo.addCurrentText();
                }
            });
            JMenuItem menu2 = new JMenuItem("Supprimer de la liste");
            this.popup.add(menu2);
            menu2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MutableListComboPopupListener.this.combo.removeCurrentText();
                }
            });
            if (this.combo.canReload()) {
                this.popup.add(new JMenuItem(new AbstractAction("Recharger la liste"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MutableListComboPopupListener.this.combo.reload();
                    }
                }));
            }
        }
        if (SwingThreadUtils.getAncestorOrSelf(JComboBox.class, this.combo.getPopupComp()) != null) {
            MutableListComboPopupListener.addPopup(this.popup);
        }
        return this.popup;
    }
}

