/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import javax.swing.SwingUtilities;

public abstract class Timer
extends Thread {
    protected final Runnable r;
    private final Runnable finalizer;
    private boolean stop = false;
    private int delay;
    private final int min;
    private final int accel;

    public Timer(Runnable r, int delay, int accel, int min) {
        this(r, delay, accel, min, null);
    }

    public Timer(Runnable r, int delay, int accel, int min, Runnable finalizer) {
        super("timer on " + r + " initial delay: " + delay + " created " + System.currentTimeMillis());
        if (delay <= 0) {
            throw new IllegalArgumentException("delay must be strictly positive");
        }
        this.delay = delay;
        if (accel < 0) {
            throw new IllegalArgumentException("accel must be positive");
        }
        this.accel = accel;
        if (min <= 0) {
            throw new IllegalArgumentException("min must be strictly positive");
        }
        this.min = min;
        this.r = r;
        this.finalizer = finalizer;
    }

    @Override
    public final void run() {
        while (!this.canceled()) {
            this.invokeTask();
            try {
                this.waitForTask();
                Thread.sleep(this.delay);
                if (this.delay <= this.min) continue;
                this.delay -= this.accel;
                if (this.delay >= this.min) continue;
                this.delay = this.min;
            }
            catch (InterruptedException e) {
                this.cancel();
            }
        }
        if (this.finalizer != null) {
            SwingUtilities.invokeLater(this.finalizer);
        }
    }

    protected abstract void invokeTask();

    protected abstract void waitForTask() throws InterruptedException;

    public final synchronized void cancel() {
        if (!this.canceled()) {
            this.stop = true;
            this.interrupt();
        }
    }

    final synchronized boolean canceled() {
        return this.stop || this.isInterrupted();
    }
}

