/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.sqlobject.ITextWithCompletion;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.TextAreaTableCellEditor;
import org.openconcerto.utils.checks.ValidState;

public class TextTableCellEditorWithCompletion
extends TextAreaTableCellEditor {
    private ITextWithCompletion textWithCompl;
    private ValidStateChecker validStateChecker;

    public TextTableCellEditorWithCompletion(JTable table, ITextWithCompletion t, ValidStateChecker validStateChecker) {
        super(table);
        this.textWithCompl = t;
        this.validStateChecker = validStateChecker;
        t.setPopupInvoker(this.getTextArea());
        t.setTextEditor(this.getTextArea());
        this.textWithCompl.setSelectionAutoEnabled(true);
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.textWithCompl.hidePopup();
    }

    @Override
    public boolean stopCellEditing() {
        this.textWithCompl.hidePopup();
        if (!this.getValidState().isValid()) {
            JOptionPane.showMessageDialog(SwingUtilities.getRoot(this.getTextArea()), this.getValidState().getValidationText());
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public void setLimitedSize(int nbChar) {
        this.textWithCompl.setLimitedSize(nbChar);
    }

    public ValidState getValidState() {
        return this.validStateChecker.getValidState(this.textWithCompl.getText());
    }
}

