/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.Dimension;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.openconcerto.sql.view.list.RowValuesTableModel;

public class RowValuesTableHeader
extends JTableHeader {
    public RowValuesTableHeader(TableColumnModel model) {
        super(model);
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.resizeFromTable();
        super.columnAdded(e);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.resizeFromTable();
        super.columnRemoved(e);
    }

    public void resizeFromTable() {
        int val = 0;
        int col = 0;
        while (col < this.table.getColumnCount()) {
            val += ((RowValuesTableModel)this.table.getModel()).getSQLTableElementAt(col).getPreferredSize();
            ++col;
        }
        Dimension d = this.table.getPreferredScrollableViewportSize();
        Dimension d2 = new Dimension(d.width, this.table.getMinimumSize().height);
        this.table.setPreferredScrollableViewportSize(d2);
        if (val > 0) {
            this.table.setMinimumSize(new Dimension(val, Math.max(this.table.getMinimumSize().height, 80)));
        } else {
            this.table.setMinimumSize(new Dimension(900, Math.max(this.table.getMinimumSize().height, 80)));
        }
        this.table.invalidate();
        this.table.revalidate();
        this.table.repaint();
        this.setSize(new Dimension(this.table.getSize().width, this.getSize().height));
    }
}

