/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.ui.Login;
import org.openconcerto.sql.users.AccesSocieteTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ISpinner;
import org.openconcerto.ui.ISpinnerIntegerModel;
import org.openconcerto.ui.valuewrapper.TextValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class UserCommonSQLElement
extends ConfSQLElement {
    public UserCommonSQLElement() {
        super("USER_COMMON", "un utilisateur", "utilisateurs");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("PRENOM");
        l.add("LOGIN");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("PRENOM");
        return l;
    }

    @Override
    protected ComboSQLRequest createComboRequest() {
        ComboSQLRequest res = super.createComboRequest();
        res.setFieldSeparator(" ");
        return res;
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        return CollectionMap.singleton(null, new String[]{"PRENOM", "NOM"});
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private JPasswordField passField;
            private JPasswordField passFieldConfirm;
            private JPanel panelWarning;
            private AccesSocieteTable table;
            private final JTextField encryptedPass;
            {
                this.encryptedPass = new JTextField();
            }

            protected final JPasswordField getPassField() {
                return this.passField;
            }

            protected final JPasswordField getPassFieldConfirm() {
                return this.passFieldConfirm;
            }

            @Override
            public void addViews() {
                GridBagConstraints c = new GridBagConstraints();
                c.insets = new Insets(0, 0, 0, 0);
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.fill = 2;
                c.anchor = 17;
                this.panelWarning = new JPanel(new GridBagLayout());
                this.panelWarning.setBorder(null);
                JLabelWarning labelWarning = new JLabelWarning();
                this.panelWarning.add((Component)labelWarning, c);
                JLabel labelTextWarning = new JLabel("Confirmation incorrecte");
                ++c.gridx;
                this.panelWarning.add((Component)labelTextWarning, c);
                GridBagLayout layout = new GridBagLayout();
                this.setLayout(layout);
                c.gridx = 0;
                c.insets = new Insets(2, 2, 1, 2);
                JLabel labelLogin = new JLabel(this.getLabelFor("LOGIN"));
                labelLogin.setHorizontalAlignment(4);
                this.add((Component)labelLogin, c);
                JTextField textLogin = new JTextField();
                ++c.gridx;
                DefaultGridBagConstraints.lockMinimumSize(textLogin);
                c.weightx = 1.0;
                this.add((Component)textLogin, c);
                c.gridwidth = 0;
                ++c.gridx;
                c.insets = new Insets(0, 0, 0, 0);
                this.add((Component)this.panelWarning, c);
                this.panelWarning.setVisible(false);
                ++c.gridy;
                c.gridwidth = 1;
                c.gridx = 0;
                c.weightx = 0.0;
                c.insets = new Insets(2, 2, 1, 2);
                JLabel labelPass = new JLabel(this.getLabelFor("PASSWORD"));
                labelPass.setHorizontalAlignment(4);
                this.add((Component)labelPass, c);
                this.passField = new JPasswordField(15);
                ++c.gridx;
                c.weightx = 1.0;
                DefaultGridBagConstraints.lockMinimumSize(this.getPassField());
                this.add((Component)this.getPassField(), c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelConfirmationPass = new JLabel("Confirmation");
                labelConfirmationPass.setHorizontalAlignment(4);
                this.add((Component)labelConfirmationPass, c);
                this.passFieldConfirm = new JPasswordField(15);
                ++c.gridx;
                c.weightx = 1.0;
                DefaultGridBagConstraints.lockMinimumSize(this.getPassFieldConfirm());
                this.add((Component)this.getPassFieldConfirm(), c);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                labelNom.setHorizontalAlignment(4);
                this.add((Component)labelNom, c);
                JTextField textNom = new JTextField();
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textNom, c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelPrenom = new JLabel(this.getLabelFor("PRENOM"));
                labelPrenom.setHorizontalAlignment(4);
                this.add((Component)labelPrenom, c);
                JTextField textPrenom = new JTextField();
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textPrenom, c);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                JLabel labelSurnom = new JLabel(this.getLabelFor("SURNOM"));
                labelSurnom.setHorizontalAlignment(4);
                this.add((Component)labelSurnom, c);
                JTextField textSurnom = new JTextField();
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textSurnom, c);
                if (this.getTable().contains("ADMIN")) {
                    ++c.gridx;
                    c.gridwidth = 0;
                    c.weightx = 0.0;
                    JCheckBox checkAdmin = new JCheckBox(this.getLabelFor("ADMIN"));
                    this.add((Component)checkAdmin, c);
                    this.addView(checkAdmin, "ADMIN");
                }
                ++c.gridy;
                c.gridwidth = 1;
                c.gridx = 0;
                c.weightx = 0.0;
                if (this.getTable().contains("MAIL")) {
                    JLabel labelMail = new JLabel(this.getLabelFor("MAIL"));
                    labelMail.setHorizontalAlignment(4);
                    c.anchor = 18;
                    this.add((Component)labelMail, c);
                    ++c.gridx;
                    JTextField textMail = new JTextField();
                    c.gridwidth = 0;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    this.add((Component)textMail, c);
                    this.addView(textMail, "MAIL");
                }
                boolean gestionHoraire = false;
                if (Configuration.getInstance().getAppName().startsWith("OpenConcerto") && gestionHoraire) {
                    c.gridwidth = 1;
                    JPanel panelHoraires = new JPanel(new GridBagLayout());
                    DefaultGridBagConstraints cH = new DefaultGridBagConstraints();
                    this.createHalfDay(panelHoraires, cH, "Matin :", "MATIN", 8, 12);
                    this.createHalfDay(panelHoraires, cH, "Apr\u00e8s midi :", "MIDI", 13, 17);
                    ++c.gridy;
                    c.gridx = 0;
                    c.gridwidth = 0;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    panelHoraires.setBorder(BorderFactory.createTitledBorder("Horaires"));
                    this.add((Component)panelHoraires, c);
                    ++c.gridy;
                    c.weighty = 1.0;
                    this.table = new AccesSocieteTable();
                    this.add((Component)this.table, c);
                }
                this.addRequiredSQLObject(textLogin, "LOGIN");
                this.addView(new SimpleRowItemView<String>((ValueWrapper)new TextValueWrapper(this.encryptedPass)){

                    @Override
                    public void setEditable(boolean b) {
                        this.getPassField().setEnabled(b);
                        this.getPassFieldConfirm().setEnabled(b);
                    }
                }, "PASSWORD", (Object)"required");
                this.addSQLObject(textNom, "NOM");
                this.addSQLObject(textPrenom, "PRENOM");
                this.addSQLObject(textSurnom, "SURNOM");
                this.getPassField().getDocument().addDocumentListener(new SimpleDocumentListener(){

                    @Override
                    public void update(DocumentEvent e) {
                        this.updateEncrypted();
                        this.fireValidChange();
                    }
                });
                this.getPassFieldConfirm().getDocument().addDocumentListener(new SimpleDocumentListener(){

                    @Override
                    public void update(DocumentEvent e) {
                        this.fireValidChange();
                    }
                });
            }

            private void createHalfDay(JPanel panelHoraires, GridBagConstraints cH, String label, String field, int startHour, int endHour) {
                panelHoraires.add((Component)new JLabel(label), cH);
                ++cH.gridx;
                this.createTime(panelHoraires, cH, "arriv\u00e9e", String.valueOf(field) + "_A", startHour);
                ++cH.gridy;
                cH.gridx = 1;
                this.createTime(panelHoraires, cH, "d\u00e9part", String.valueOf(field) + "_D", endHour);
                ++cH.gridy;
                cH.gridx = 0;
            }

            private void createTime(JPanel panelHoraires, GridBagConstraints cH, String label, String field, int hour) {
                panelHoraires.add((Component)new JLabel(label), cH);
                ++cH.gridx;
                ISpinner spinHourMA = this.createSpinner(panelHoraires, cH, true, hour);
                ISpinner spinMinMA = this.createSpinner(panelHoraires, cH, false, 0);
                this.addView(new SimpleRowItemView<Integer>(spinHourMA), "HEURE_" + field, null);
                this.addView(new SimpleRowItemView<Integer>(spinMinMA), "MINUTE_" + field, null);
            }

            private ISpinner createSpinner(JPanel panelHoraires, GridBagConstraints cH, boolean hour, int value) {
                ISpinnerIntegerModel modelHourMA = new ISpinnerIntegerModel(0, hour ? 23 : 59, value);
                ISpinner spinHourMA = new ISpinner(modelHourMA);
                panelHoraires.add((Component)spinHourMA.getComp(), cH);
                ++cH.gridx;
                panelHoraires.add((Component)new JLabel(hour ? "h" : "min"), cH);
                ++cH.gridx;
                return spinHourMA;
            }

            private void updateEncrypted() {
                String pass = String.valueOf(this.getPassField().getPassword());
                String dbPass = Boolean.getBoolean("org.openconcerto.sql.legacyPasswords") ? String.valueOf('\"') + pass + '\"' : pass;
                this.encryptedPass.setText(Login.encodePassword(dbPass));
            }

            private boolean checkValidityPassword() {
                boolean b = String.valueOf(this.getPassField().getPassword()).equalsIgnoreCase(String.valueOf(this.getPassFieldConfirm().getPassword()));
                this.panelWarning.setVisible(!b);
                return b;
            }

            @Override
            public synchronized ValidState getValidState() {
                return super.getValidState().and(ValidState.createCached(this.checkValidityPassword(), "Les mots de passe ne correspondent pas"));
            }

            @Override
            public void select(SQLRowAccessor row) {
                if (row != null) {
                    String bogusPass = "bogusPass!";
                    this.getPassField().setText("bogusPass!");
                    this.getPassFieldConfirm().setText("bogusPass!");
                    if (this.table != null) {
                        this.table.insertFrom("ID_USER_COMMON", row.getID());
                    }
                }
                super.select(row);
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                if (this.table != null) {
                    this.table.updateField("ID_USER_COMMON", id);
                }
                return id;
            }

            @Override
            public void update() {
                super.update();
                if (this.table != null) {
                    this.table.updateField("ID_USER_COMMON", this.getSelectedID());
                }
            }
        };
    }
}

