/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.preferences;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.replication.MemoryRep;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.RTInterruptedException;

public class SQLPreferences
extends AbstractPreferences {
    private static final Map<DBRoot, SQLPreferences> memCachedbyRoots = new IdentityHashMap<DBRoot, SQLPreferences>(8);
    private final SQLTable prefRT;
    private final SQLTable prefWT;
    private final SQLTable nodeRT;
    private final SQLTable nodeWT;
    private final MemoryRep rep;
    private Map<String, String> values;
    private final Map<String, String> changedValues;
    private final Set<String> removedKeys;
    private SQLRow node;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLPreferences getMemCached(DBRoot root) {
        SQLPreferences res;
        Map<DBRoot, SQLPreferences> map = memCachedbyRoots;
        synchronized (map) {
            res = memCachedbyRoots.get(root);
        }
        if (res == null) {
            throw new IllegalStateException("No preferences for " + root);
        }
        return res;
    }

    public SQLPreferences(DBRoot db) {
        this(null, db.getTable("PREF_VALUE"), db.getTable("PREF_VALUE"), db.getTable("PREF_NODE"), db.getTable("PREF_NODE"));
    }

    private SQLPreferences(MemoryRep rep, SQLTable prefRT, SQLTable prefWT, SQLTable nodeRT, SQLTable nodeWT) {
        this(null, "", rep, prefRT, prefWT, nodeRT, nodeWT);
    }

    private SQLPreferences(SQLPreferences parent, String name) {
        this(parent, name, parent.rep, parent.prefRT, parent.prefWT, parent.nodeRT, parent.nodeWT);
    }

    private SQLPreferences(SQLPreferences parent, String name, MemoryRep rep, SQLTable prefRT, SQLTable prefWT, SQLTable nodeRT, SQLTable nodeWT) {
        super(parent, name);
        this.prefRT = prefRT;
        this.prefWT = prefWT;
        this.nodeRT = nodeRT;
        this.nodeWT = nodeWT;
        this.rep = rep;
        this.values = null;
        this.changedValues = new HashMap<String, String>();
        this.removedKeys = new HashSet<String>();
        this.node = null;
    }

    private final SQLTable getNodeRT() {
        return this.nodeRT;
    }

    private final SQLTable getPrefRT() {
        return this.prefRT;
    }

    private final SQLTable getNodeWT() {
        return this.nodeWT;
    }

    private final SQLTable getPrefWT() {
        return this.prefWT;
    }

    private final SQLDataSource getReadDS() {
        return this.getPrefRT().getDBSystemRoot().getDataSource();
    }

    private final SQLDataSource getWriteDS() {
        return this.getPrefWT().getDBSystemRoot().getDataSource();
    }

    private Object execute(String sel, ResultSetHandler rsh) {
        if (this.rep != null) {
            try {
                this.rep.waitOnLastManualFuture();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.getReadDS().execute(sel, new IResultSetHandler(rsh, false));
    }

    private final void replicate() {
        if (this.rep != null) {
            this.rep.submitReplicate();
        }
    }

    private final LinkedList<SQLPreferences> getAncestors() {
        SQLPreferences p;
        LinkedList<SQLPreferences> res = new LinkedList<SQLPreferences>();
        res.add(this);
        SQLPreferences current = this;
        while ((p = (SQLPreferences)current.parent()) != null) {
            res.addFirst(p);
            current = p;
        }
        return res;
    }

    public final SQLRow getNode() {
        if (this.node == null) {
            Where parentW;
            SQLPreferences parent = (SQLPreferences)this.parent();
            if (parent == null) {
                parentW = Where.isNull(this.getNodeRT().getField("ID_PARENT"));
            } else {
                SQLRow parentNode = parent.getNode();
                Where where = parentW = parentNode == null ? null : new Where((FieldRef)this.getNodeRT().getField("ID_PARENT"), "=", parentNode.getID());
            }
            if (parentW == null) {
                this.node = null;
            } else {
                SQLSelect sel = new SQLSelect().addSelectStar(this.getNodeRT());
                sel.setWhere(parentW.and(new Where((FieldRef)this.getNodeRT().getField("NAME"), "=", (Object)this.name())));
                Map m = (Map)this.execute(sel.asString(), SQLDataSource.MAP_HANDLER);
                this.node = m == null ? null : new SQLRow(this.getNodeRT(), m);
            }
        }
        return this.node;
    }

    private final SQLRow createThisNode() throws SQLException {
        SQLPreferences parent = (SQLPreferences)this.parent();
        SQLRowValues insVals = new SQLRowValues(this.getNodeWT());
        insVals.put("ID_PARENT", parent == null ? SQLRowValues.SQL_EMPTY_LINK : Integer.valueOf(parent.node.getID()));
        insVals.put("NAME", this.name());
        this.node = insVals.insert();
        return this.node;
    }

    private final boolean createNode() throws SQLException {
        if (this.node == null) {
            Iterator iter = this.getAncestors().iterator();
            boolean rowExists = true;
            SQLPreferences ancestor = null;
            while (iter.hasNext() && rowExists) {
                ancestor = (SQLPreferences)iter.next();
                boolean bl = rowExists = ancestor.getNode() != null;
            }
            if (!rowExists) {
                super.createThisNode();
                while (iter.hasNext()) {
                    ancestor = (SQLPreferences)iter.next();
                    ancestor.createThisNode();
                }
                return true;
            }
        }
        return false;
    }

    public final Map<String, String> getValues() {
        if (this.values == null) {
            this.values = new HashMap<String, String>();
            SQLRow node = this.getNode();
            if (node != null) {
                SQLSelect sel = new SQLSelect().addSelectStar(this.getPrefRT());
                sel.setWhere(new Where((FieldRef)this.getPrefRT().getField("ID_NODE"), "=", node.getID()));
                List l = (List)this.execute(sel.asString(), SQLDataSource.MAP_LIST_HANDLER);
                for (Map r : l) {
                    this.values.put(r.get("NAME").toString(), r.get("VALUE").toString());
                }
            }
        }
        return this.values;
    }

    @Override
    protected void putSpi(String key, String value) {
        this.changedValues.put(key, value);
        this.removedKeys.remove(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.removedKeys.add(key);
        this.changedValues.remove(key);
    }

    @Override
    protected String getSpi(String key) {
        if (this.removedKeys.contains(key)) {
            return null;
        }
        if (this.changedValues.containsKey(key)) {
            return this.changedValues.get(key);
        }
        return this.getValues().get(key);
    }

    private void deleteValues(Set<String> keys) {
        SQLRow node = this.getNode();
        if (node != null) {
            String keysW = keys == null ? "" : " and " + new Where(this.getPrefWT().getField("NAME"), keys).getClause();
            this.getWriteDS().execute("DELETE FROM " + this.getPrefWT().getSQLName().quote() + " where \"ID_NODE\" = " + node.getID() + keysW);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            final SQLRow node = this.getNode();
            if (node != null) {
                SQLUtils.executeAtomic(this.getWriteDS(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException {
                        SQLPreferences.this.deleteValues(null);
                        ds.execute("DELETE FROM " + SQLPreferences.this.getNodeWT().getSQLName().quote() + " where \"ID\" = " + node.getID());
                        return null;
                    }
                });
                this.replicate();
                this.node = null;
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        assert (this.node == null);
        this.values = null;
        this.removedKeys.clear();
        this.changedValues.clear();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        try {
            Set<String> res;
            Set<String> committedKeys = this.getValues().keySet();
            if (this.removedKeys.isEmpty() && this.changedValues.isEmpty()) {
                res = committedKeys;
            } else {
                res = new HashSet<String>(committedKeys);
                res.removeAll(this.removedKeys);
                res.addAll(this.changedValues.keySet());
            }
            return res.toArray(new String[res.size()]);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        try {
            SQLRow node = this.getNode();
            if (node == null) {
                return new String[0];
            }
            int nodeID = node.getID();
            SQLSelect sel = new SQLSelect().addSelect(this.getNodeRT().getField("NAME"));
            Where w = new Where((FieldRef)this.getNodeRT().getField("ID_PARENT"), "=", nodeID);
            sel.setWhere(w);
            List names = (List)this.execute(sel.asString(), SQLDataSource.COLUMN_LIST_HANDLER);
            return names.toArray(new String[names.size()]);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected SQLPreferences childSpi(String name) {
        return new SQLPreferences(this, name);
    }

    @Override
    public void sync() throws BackingStoreException {
        this.replicate();
        super.sync();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.flushSpi();
        this.values = null;
        this.node = null;
        if (this.getNode() == null) {
            this.removeNode();
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        if (!this.nodeExists("")) {
            return;
        }
        try {
            SQLUtils.executeAtomic(this.getWriteDS(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    SQLPreferences.this.flushTxn();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
    }

    protected final void flushTxn() throws SQLException {
        boolean masterChanged = this.createNode();
        if (this.removedKeys.size() > 0 || this.changedValues.size() > 0) {
            this.deleteValues(CollectionUtils.union(this.removedKeys, this.changedValues.keySet()));
            this.removedKeys.clear();
            if (this.changedValues.size() > 0) {
                int nodeID = this.getNode().getID();
                ArrayList<String> insValues = new ArrayList<String>(this.changedValues.size());
                for (Map.Entry<String, String> e : this.changedValues.entrySet()) {
                    insValues.add("(" + nodeID + ", " + this.getPrefWT().getBase().quoteString(e.getKey()) + ", " + this.getPrefWT().getBase().quoteString(e.getValue()) + ")");
                }
                SQLRowValues.insertCount(this.getPrefWT(), "(\"ID_NODE\", \"NAME\", \"VALUE\") VALUES" + CollectionUtils.join(insValues, ", "));
                this.changedValues.clear();
            }
            masterChanged = true;
        }
        if (masterChanged) {
            this.replicate();
        }
    }
}

