/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.utils.EnumOrderedSet;
import org.openconcerto.utils.cc.ITransformer;

public enum SQLSystem {
    POSTGRESQL{

        @Override
        void removeRootsToIgnore(Set<String> s) {
            super.removeRootsToIgnore(s);
            Iterator<String> iter = s.iterator();
            while (iter.hasNext()) {
                String r = iter.next();
                if (!r.startsWith("pg_")) continue;
                iter.remove();
            }
        }

        @Override
        public boolean isClearingPathSupported() {
            return true;
        }

        @Override
        public boolean autoCreatesFKIndex() {
            return false;
        }

        @Override
        public boolean isIndexFilterConditionSupported() {
            return true;
        }
    }
    ,
    MYSQL{

        @Override
        EnumSet<HierarchyLevel> createLevels() {
            return EnumSet.complementOf(EnumSet.of(HierarchyLevel.SQLSCHEMA));
        }

        @Override
        void removeRootsToIgnore(Set<String> s) {
            super.removeRootsToIgnore(s);
            s.remove("mysql");
        }

        @Override
        public boolean isInterBaseSupported() {
            return true;
        }

        @Override
        public boolean isDBPathEmpty() {
            return true;
        }

        @Override
        public boolean isFractionalSecondsSupported() {
            return false;
        }
    }
    ,
    H2{

        @Override
        ITransformer<String, String> getURLTransf(final SQLServer s) {
            if (s.getSQLSystem() != this) {
                throw new IllegalArgumentException(s + " is not " + (Object)((Object)this));
            }
            return new ITransformer<String, String>(){

                @Override
                public String transformChecked(String base) {
                    String sep = s.getName().equals("mem") ? ":" : "";
                    return String.valueOf(s.getName()) + sep + base;
                }
            };
        }

        @Override
        public boolean isClearingPathSupported() {
            return false;
        }

        @Override
        public boolean isMultipleResultSetsSupported() {
            return false;
        }
    }
    ,
    MSSQL{

        @Override
        public String getJDBCName() {
            return "sqlserver";
        }

        @Override
        ITransformer<String, String> getURLTransf(final SQLServer s) {
            return new ITransformer<String, String>(){

                @Override
                public String transformChecked(String base) {
                    return "//" + s.getName() + ";databaseName=" + base;
                }
            };
        }

        @Override
        void removeRootsToIgnore(Set<String> s) {
            super.removeRootsToIgnore(s);
            Iterator<String> iter = s.iterator();
            while (iter.hasNext()) {
                String r = iter.next();
                if (!r.startsWith("db_") && !r.equals("sys")) continue;
                iter.remove();
            }
        }

        @Override
        public boolean autoCreatesFKIndex() {
            return false;
        }
    }
    ,
    DERBY;

    private final EnumOrderedSet<HierarchyLevel> levels = new EnumOrderedSet<HierarchyLevel>(this.createLevels());

    private SQLSystem() {
    }

    public static SQLSystem get(String name) {
        String normalized = name.toUpperCase();
        try {
            return SQLSystem.valueOf(normalized);
        }
        catch (IllegalArgumentException e) {
            if (normalized.equals("PSQL")) {
                return POSTGRESQL;
            }
            throw e;
        }
    }

    public String getJDBCName() {
        return this.name().toLowerCase();
    }

    EnumSet<HierarchyLevel> createLevels() {
        return EnumSet.allOf(HierarchyLevel.class);
    }

    public final EnumOrderedSet<HierarchyLevel> getLevels() {
        return this.levels;
    }

    public final int getHops(Class<? extends DBStructureItem<?>> clazz1, Class<? extends DBStructureItem<?>> clazz2) {
        EnumOrderedSet<HierarchyLevel> levels = DBStructureItemDB.class.isAssignableFrom(clazz1) || DBStructureItemDB.class.isAssignableFrom(clazz2) ? this.getLevels() : HierarchyLevel.getAll();
        return levels.getHops(this.getLevel(clazz1), this.getLevel(clazz2));
    }

    public final HierarchyLevel getDBRootLevel() {
        return this.getLevels().getPrevious(HierarchyLevel.SQLTABLE);
    }

    public final HierarchyLevel getDBLevel(Class<? extends DBStructureItemDB> clazz) {
        if (clazz.equals(DBRoot.class)) {
            return this.getDBRootLevel();
        }
        if (clazz.equals(DBSystemRoot.class)) {
            return this.getLevels().getPrevious(this.getDBRootLevel());
        }
        throw new IllegalArgumentException(clazz + " should be either DBRoot or DBSystemRoot");
    }

    public final HierarchyLevel getLevel(Class<? extends DBStructureItem<?>> clazz) {
        if (DBStructureItemDB.class.isAssignableFrom(clazz)) {
            return this.getDBLevel(clazz.asSubclass(DBStructureItemDB.class));
        }
        return HierarchyLevel.get(clazz.asSubclass(DBStructureItemJDBC.class));
    }

    void removeRootsToIgnore(Set<String> s) {
        s.remove("information_schema");
        s.remove("INFORMATION_SCHEMA");
    }

    ITransformer<String, String> getURLTransf(final SQLServer s) {
        if (s.getSQLSystem() != this) {
            throw new IllegalArgumentException(s + " is not " + (Object)((Object)this));
        }
        return new ITransformer<String, String>(){

            @Override
            public String transformChecked(String base) {
                return "//" + s.getName() + "/" + base;
            }
        };
    }

    public final boolean isNoDefaultSchemaSupported() {
        return this.isClearingPathSupported() || this.isDBPathEmpty();
    }

    public boolean isClearingPathSupported() {
        return false;
    }

    public boolean isDBPathEmpty() {
        return false;
    }

    public boolean isInterBaseSupported() {
        return false;
    }

    public boolean autoCreatesFKIndex() {
        return true;
    }

    public boolean isIndexFilterConditionSupported() {
        return false;
    }

    public boolean isFractionalSecondsSupported() {
        return true;
    }

    public boolean isMultipleResultSetsSupported() {
        return true;
    }

    public String getMDName(String name) {
        return name;
    }

    public final SQLSyntax getSyntax() {
        try {
            return SQLSyntax.get(this);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /* synthetic */ SQLSystem(String string, int n, SQLSystem sQLSystem) {
        this();
    }
}

