/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Matrix;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.cc.Closure;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.cc.IdentitySet;

public class SQLRowValuesCluster {
    private static final Comparator<SQLField> FIELD_COMPARATOR = new Comparator<SQLField>(){

        @Override
        public int compare(SQLField o1, SQLField o2) {
            return o1.getSQLName().quote().compareTo(o2.getSQLName().quote());
        }
    };
    private final List<Link> links = new ArrayList<Link>();
    private final IdentitySet<SQLRowValues> items = new IdentityHashSet<SQLRowValues>();
    private final Map<SQLRowValues, Node> nodes = new IdentityHashMap<SQLRowValues, Node>();
    private Map<SQLRowValues, List<ValueChangeListener>> listeners = null;

    private SQLRowValuesCluster() {
    }

    SQLRowValuesCluster(SQLRowValues vals) {
        this();
        this.links.add(new Link(vals));
        this.items.add(vals);
    }

    private final SQLRowValues getHead() {
        return this.links.get(0).getSrc();
    }

    private final Map<SQLRowValues, Node> getNodes() {
        return this.nodes;
    }

    private final DBSystemRoot getSystemRoot() {
        return this.getHead().getTable().getDBSystemRoot();
    }

    public final Set<SQLRowValues> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public final int size() {
        return this.items.size();
    }

    public final boolean contains(SQLRowValues start) {
        return this.items.contains(start);
    }

    private final void containsCheck(SQLRowValues vals) {
        if (!this.contains(vals)) {
            throw new IllegalArgumentException(vals + " not in " + this);
        }
    }

    void remove(SQLRowValues src, SQLField f, SQLRowValues dest) {
        assert (dest != null);
        assert (src.getGraph() == this);
        assert (src.getTable() == f.getTable());
        Link toRm = new Link(src, f, dest);
        this.links.remove(toRm);
        IdentitySet<SQLRowValues> reachable = this.getReachable(src);
        if (reachable.size() < this.size()) {
            SQLRowValuesCluster newCluster = new SQLRowValuesCluster();
            Iterator<Link> iter = this.links.iterator();
            while (iter.hasNext()) {
                Link l = iter.next();
                assert (l.getDest() == null || reachable.contains(l.getSrc()) == reachable.contains(l.getDest()));
                if (reachable.contains(l.getSrc())) continue;
                iter.remove();
                newCluster.links.add(l);
            }
            assert (newCluster.items.isEmpty());
            Iterator itemIter = this.items.iterator();
            while (itemIter.hasNext()) {
                SQLRowValues key = (SQLRowValues)itemIter.next();
                if (reachable.contains(key)) continue;
                itemIter.remove();
                newCluster.items.add(key);
                if (this.listeners == null || !this.listeners.containsKey(key)) continue;
                newCluster.getListeners().put(key, this.listeners.remove(key));
            }
            assert (!newCluster.items.isEmpty() && !CollectionUtils.containsAny(this.items, newCluster.items));
            this.nodes.keySet().retainAll(reachable);
            for (SQLRowValues vals : newCluster.getItems()) {
                vals.setGraph(newCluster);
            }
        }
    }

    void add(SQLRowValues src, SQLField f, SQLRowValues dest) {
        assert (dest != null);
        assert (src.getGraph() == this);
        assert (this.contains(src));
        assert (src.getTable() == f.getTable());
        Link toAdd = new Link(src, f, dest);
        if (this.contains(dest)) {
            this.links.add(toAdd);
        } else {
            assert (src.getGraph() != dest.getGraph());
            SQLRowValuesCluster destGraph = dest.getGraph();
            this.links.add(0, toAdd);
            this.links.addAll(0, destGraph.links);
            destGraph.links.clear();
            this.items.addAll(destGraph.getItems());
            for (SQLRowValues newlyAdded : destGraph.getItems()) {
                newlyAdded.setGraph(this);
            }
            destGraph.items.clear();
            if (destGraph.listeners != null) {
                this.getListeners().putAll(destGraph.listeners);
                destGraph.listeners = null;
            }
        }
        assert (src.getGraph() == dest.getGraph());
    }

    public final SQLRow getRow(SQLRowValues vals) {
        this.containsCheck(vals);
        return this.nodes.get(vals).getStoredRow();
    }

    private IdentitySet<SQLRowValues> getReachable(SQLRowValues from) {
        IdentityHashSet<SQLRowValues> res = new IdentityHashSet<SQLRowValues>();
        this.getReachableRec(from, res);
        return res;
    }

    private void getReachableRec(SQLRowValues from, IdentitySet<SQLRowValues> acc) {
        if (!acc.add(from)) {
            return;
        }
        for (SQLRowValues fVals : from.getForeigns().values()) {
            this.getReachableRec(fVals, acc);
        }
        for (SQLRowValues fVals : from.getReferentRows()) {
            this.getReachableRec(fVals, acc);
        }
    }

    final synchronized SQLRowValues deepCopy(SQLRowValues v) {
        IdentityHashMap<SQLRowValues, SQLRowValues> noLinkCopy = new IdentityHashMap<SQLRowValues, SQLRowValues>();
        for (SQLRowValues n : this.getItems()) {
            noLinkCopy.put(n, new SQLRowValues(n, SQLRowValues.ForeignCopyMode.NO_COPY));
        }
        for (SQLRowValues n : this.getItems()) {
            for (Map.Entry<String, SQLRowValues> e : n.getForeigns().entrySet()) {
                ((SQLRowValues)noLinkCopy.get(n)).put(e.getKey(), noLinkCopy.get(e.getValue()));
            }
        }
        return (SQLRowValues)noLinkCopy.get(v);
    }

    public final synchronized void store(StoreMode mode) throws SQLException {
        this.store(mode, true);
    }

    public final synchronized void store(final StoreMode mode, boolean checkValidity) throws SQLException {
        this.reset();
        if (checkValidity) {
            for (Node n : this.getNodes().values()) {
                n.noLink.checkValidity();
            }
        }
        final ArrayList<StoringLink> storingLinks = new ArrayList<StoringLink>(this.links.size());
        for (Link l : this.links) {
            storingLinks.add(new StoringLink(l));
        }
        List<SQLTableEvent> events = SQLUtils.executeAtomic(this.getSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<List<SQLTableEvent>, SQLException>(){

            @Override
            public List<SQLTableEvent> handle(SQLDataSource ds) throws SQLException {
                ArrayList<SQLTableEvent> res = new ArrayList<SQLTableEvent>();
                while (storingLinks.size() > 0) {
                    StoringLink toStore = (StoringLink)storingLinks.remove(0);
                    if (!toStore.canStore()) {
                        throw new IllegalStateException();
                    }
                    Node n = (Node)SQLRowValuesCluster.this.getNodes().get(toStore.getSrc());
                    boolean lastDBAccess = true;
                    Iterator iter = storingLinks.iterator();
                    while (iter.hasNext()) {
                        StoringLink sl = (StoringLink)iter.next();
                        if (sl.getSrc() != toStore.getSrc()) continue;
                        if (sl.canStore()) {
                            iter.remove();
                            if (sl.destID == null) continue;
                            n.noLink.put(sl.getField().getName(), sl.destID);
                            continue;
                        }
                        lastDBAccess = false;
                    }
                    if (n.isStored()) {
                        res.add(n.update());
                    } else {
                        res.add(n.store(mode));
                        SQLRow r = n.getStoredRow();
                        for (StoringLink sl : storingLinks) {
                            if (sl.getDest() != toStore.getSrc()) continue;
                            sl.destID = r.getIDNumber();
                            ((Node)SQLRowValuesCluster.this.getNodes().get(sl.getSrc())).noLink.put(sl.getField().getName(), r.getIDNumber());
                        }
                    }
                    if (!lastDBAccess) continue;
                    for (Map.Entry<String, SQLRowValues> e : toStore.getSrc().getForeigns().entrySet()) {
                        SQLRowValues foreign = ((Node)SQLRowValuesCluster.this.getNodes().get(e.getValue())).getStoredValues();
                        if (!$assertionsDisabled && foreign == null) {
                            throw new AssertionError((Object)"since this the last db access for this row, all foreigns should have been inserted");
                        }
                        if (n.getStoredValues().getLong(e.getKey()) != foreign.getIDNumber().longValue()) {
                            throw new IllegalStateException("stored " + n.getStoredValues().getObject(e.getKey()) + " but foreign is " + SQLRowValues.trim(foreign));
                        }
                        n.getStoredValues().put(e.getKey(), foreign);
                    }
                }
                return res;
            }
        });
        for (SQLTableEvent n : events) {
            n.getTable().fire(n);
        }
    }

    private final void reset() {
        this.getNodes().clear();
        for (SQLRowValues vals : this.getItems()) {
            this.getNodes().put(vals, new Node(vals));
        }
    }

    public final <T> void walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure) {
        this.walk(start, acc, closure, RecursionType.BREADTH_FIRST);
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, RecursionType recType) {
        return this.walk(start, acc, closure, recType, true);
    }

    public final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, RecursionType recType, Boolean foreign) {
        return this.walk(start, acc, closure, recType, foreign, true);
    }

    final <T> StopRecurseException walk(SQLRowValues start, T acc, ITransformer<State<T>, T> closure, RecursionType recType, Boolean foreign, boolean includeStart) {
        this.containsCheck(start);
        return this.walk(new State<T>(Collections.singletonList(start), new Path(start.getTable()), acc, closure), recType, foreign, includeStart);
    }

    private final <T> StopRecurseException walk(State<T> state, RecursionType recType, Boolean foreign, boolean computeThisState) {
        StopRecurseException e;
        StopRecurseException e2;
        if (computeThisState && recType == RecursionType.BREADTH_FIRST && (e2 = state.compute()) != null) {
            return e2;
        }
        StopRecurseException res = null;
        if (foreign == null || Boolean.TRUE.equals(foreign)) {
            res = this.rec(state, recType, foreign, true);
        }
        if (res != null) {
            return res;
        }
        if (foreign == null || Boolean.FALSE.equals(foreign)) {
            res = this.rec(state, recType, foreign, false);
        }
        if (res != null) {
            return res;
        }
        if (computeThisState && recType == RecursionType.DEPTH_FIRST && (e = state.compute()) != null) {
            return e;
        }
        return null;
    }

    private <T> StopRecurseException rec(State<T> state, RecursionType recType, Boolean foreign, boolean actualForeign) {
        CollectionMap<SQLField, SQLRowValues> nextVals;
        SQLRowValues current = state.getCurrent();
        List<SQLRowValues> currentValsPath = state.getValsPath();
        if (actualForeign) {
            Map<SQLField, SQLRowValues> foreigns = current.getForeignsBySQLField();
            nextVals = new CollectionMap(new ArrayList(), foreigns.size());
            nextVals.putAll((Map)foreigns);
        } else {
            nextVals = current.getReferents();
        }
        ArrayList<SQLField> keys = new ArrayList<SQLField>(nextVals.keySet());
        Collections.sort(keys, FIELD_COMPARATOR);
        for (SQLField f : keys) {
            for (SQLRowValues v : nextVals.getNonNull(f)) {
                if (state.identityContains(v)) continue;
                Path path = new Path(state.getPath());
                path.add(f, actualForeign);
                ArrayList<SQLRowValues> valsPath = new ArrayList<SQLRowValues>(currentValsPath);
                valsPath.add(v);
                StopRecurseException e = this.walk(new State<T>(valsPath, path, state.getAcc(), ((State)state).closure), recType, foreign, true);
                if (e == null || !e.isCompletely()) continue;
                return e;
            }
        }
        return null;
    }

    final void walkFields(SQLRowValues start, IClosure<FieldPath> closure, boolean includeFK) {
        this.walkFields(start, new Path(start.getTable()), Collections.singletonList(start), closure, includeFK);
    }

    private void walkFields(SQLRowValues current, Path p, List<SQLRowValues> currentValsPath, IClosure<FieldPath> closure, boolean includeFK) {
        Map<String, SQLRowValues> foreigns = current.getForeigns();
        for (String field : current.getFields()) {
            SQLRowValues newVals;
            boolean isFK = foreigns.containsKey(field);
            if (!isFK || includeFK) {
                closure.executeChecked(new FieldPath(p, field));
            }
            if (!isFK || currentValsPath.contains(newVals = foreigns.get(field))) continue;
            Path newP = new Path(p);
            newP.add(current.getTable().getField(field), true);
            ArrayList<SQLRowValues> newValsPath = new ArrayList<SQLRowValues>(currentValsPath);
            newValsPath.add(newVals);
            this.walkFields(newVals, newP, newValsPath, closure, includeFK);
        }
    }

    final void grow(SQLRowValues start, final SQLRowValues toGrow, final boolean checkFields) {
        this.containsCheck(start);
        if (!start.getTable().equals(toGrow.getTable())) {
            throw new IllegalArgumentException(start + " is not from the same table as " + toGrow);
        }
        this.walk(start, null, new ITransformer<State<Object>, Object>(){

            @Override
            public Object transformChecked(State<Object> input) {
                SQLRowValues existing = toGrow.followPath(input.getPath());
                if (existing == null || checkFields && !existing.getFields().containsAll(input.getCurrent().getFields())) {
                    SQLRowValues leaf = toGrow.assurePath(input.getPath());
                    if (leaf.hasID()) {
                        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(input.getCurrent());
                        fetcher.setSelID(leaf.getID());
                        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                            @Override
                            public SQLSelect transformChecked(SQLSelect input) {
                                input.setExcludeUndefined(false);
                                return input;
                            }
                        });
                        SQLRowValues fetched = CollectionUtils.getSole(fetcher.fetch());
                        if (fetched == null) {
                            throw new IllegalArgumentException("no row for " + fetcher);
                        }
                        leaf.load(fetched, null);
                    } else {
                        throw new IllegalArgumentException("cannot expand, missing ID in " + leaf + " at " + input.getPath());
                    }
                }
                return null;
            }
        }, RecursionType.BREADTH_FIRST);
    }

    public final String printTree(SQLRowValues root, int cellLength) {
        this.containsCheck(root);
        final IdentityHashMap ys = new IdentityHashMap();
        final AtomicInteger currentY = new AtomicInteger(0);
        final Matrix<SQLRowValues> matrix = new Matrix<SQLRowValues>();
        this.walk(root, null, new Closure<State<Object>>(){

            @Override
            public void executeChecked(State<Object> input) {
                SQLRowValues r = input.getCurrent();
                final int y = ys.containsKey(r) ? ((Integer)ys.get(r)).intValue() : currentY.getAndIncrement();
                matrix.put(input.getPath().length(), y, input.getCurrent());
                SQLRowValues ancestor = input.getPrevious();
                if (ancestor != null) {
                    ancestor.walkGraph(null, new Closure<State<Object>>(){

                        @Override
                        public void executeChecked(State<Object> input) {
                            SQLRowValues ancestorRow = input.getCurrent();
                            if (ys.containsKey(ancestorRow)) {
                                throw new StopRecurseException();
                            }
                            ys.put(ancestorRow, y);
                        }
                    });
                }
            }
        }, RecursionType.DEPTH_FIRST, false);
        return matrix.print(cellLength, new ITransformer<SQLRowValues, String>(){

            @Override
            public String transformChecked(SQLRowValues input) {
                if (input == null) {
                    return "";
                }
                if (input.hasID()) {
                    return input.asRow().simpleToString();
                }
                return input.getTable().toString();
            }
        });
    }

    public final String printNodes() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getClass().getSimpleName()) + " of " + this.size() + " nodes:\n");
        for (SQLRowValues n : this.getItems()) {
            sb.append(System.identityHashCode(n));
            sb.append(" ");
            sb.append(n.getTable());
            sb.append("\t");
            for (Map.Entry<String, SQLRowValues> e : n.getForeigns().entrySet()) {
                sb.append(e.getKey());
                sb.append(" -> ");
                sb.append(System.identityHashCode(e.getValue()));
                sb.append(" ; ");
            }
            sb.append(new SQLRowValues(n, SQLRowValues.ForeignCopyMode.NO_COPY));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.links;
    }

    private final Map<SQLRowValues, List<ValueChangeListener>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new IdentityHashMap<SQLRowValues, List<ValueChangeListener>>(4);
        }
        return this.listeners;
    }

    final void fireModification(SQLRowValues vals, String fieldName, Object newValue) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, fieldName, newValue));
        }
    }

    final void fireModification(SQLRowValues vals, Map<String, ?> m) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, m));
        }
    }

    final void fireModification(SQLRowValues vals, Set<String> removed) {
        if (this.hasListeners()) {
            this.fireModification(new ValueChangeEvent(vals, removed));
        }
    }

    private final void fireModification(ValueChangeEvent evt) {
        for (List<ValueChangeListener> list : this.listeners.values()) {
            for (ValueChangeListener l : list) {
                l.valueChange(evt);
            }
        }
    }

    final void fireModification(SQLRowValues.ReferentChangeEvent evt) {
        if (this.referentFireNeeded(evt.isAddition())) {
            for (List<ValueChangeListener> list : this.listeners.values()) {
                for (ValueChangeListener l : list) {
                    l.referentChange(evt);
                }
            }
        }
    }

    final boolean referentFireNeeded(boolean put) {
        return this.hasListeners() && !put;
    }

    final boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public static class Commit
    extends StoreMode {
        @Override
        SQLTableEvent execOn(SQLRowValues vals) throws SQLException {
            return vals.commitJustThis();
        }
    }

    public static class Insert
    extends StoreMode {
        private final boolean insertPK;
        private final boolean insertOrder;

        public Insert(boolean insertPK, boolean insertOrder) {
            this.insertPK = insertPK;
            this.insertOrder = insertOrder;
        }

        @Override
        SQLTableEvent execOn(SQLRowValues vals) throws SQLException {
            HashSet<SQLField> autoFields = new HashSet<SQLField>();
            if (!this.insertPK) {
                autoFields.addAll(vals.getTable().getPrimaryKeys());
            }
            if (!this.insertOrder) {
                autoFields.add(vals.getTable().getOrderField());
            }
            return vals.insertJustThis(autoFields);
        }
    }

    private static class Link {
        private final SQLRowValues src;
        private final SQLField f;
        private final SQLRowValues dest;

        public Link(SQLRowValues src) {
            this(src, null, null);
        }

        public Link(SQLRowValues src, SQLField f, SQLRowValues dest) {
            if (src == null) {
                throw new NullPointerException("src is null");
            }
            assert (f == null && dest == null || dest != null && f.getTable() == src.getTable());
            this.src = src;
            this.f = f;
            this.dest = dest;
        }

        public final SQLRowValues getSrc() {
            return this.src;
        }

        public final SQLRowValues getDest() {
            return this.dest;
        }

        public final SQLField getField() {
            return this.f;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.src);
            result = 31 * result + System.identityHashCode(this.dest);
            result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return this.src == other.src && this.dest == other.dest && CompareUtils.equals(this.f, other.f);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + System.identityHashCode(this.src) + (this.f == null ? "" : " " + this.f.getName() + " " + System.identityHashCode(this.dest));
        }
    }

    private static final class Node {
        private SQLRowValues noLink;
        private final List<SQLTableEvent> modif = new ArrayList<SQLTableEvent>();

        public Node(SQLRowValues vals) {
            this.noLink = new SQLRowValues(vals, SQLRowValues.ForeignCopyMode.NO_COPY);
        }

        public SQLTableEvent store(StoreMode mode) throws SQLException {
            assert (!this.isStored());
            return this.addEvent(mode.execOn(this.noLink));
        }

        public SQLTableEvent update() throws SQLException {
            assert (this.isStored());
            HashSet<String> fieldsToUpdate = new HashSet<String>(this.noLink.getFields());
            fieldsToUpdate.removeAll(this.getEvent().getFieldNames());
            assert (fieldsToUpdate.size() > 0);
            SQLRowValues updatingVals = this.getStoredRow().createEmptyUpdateRow();
            updatingVals.load(this.noLink, fieldsToUpdate);
            SQLTableEvent evt = new Node(updatingVals).store(StoreMode.COMMIT);
            this.getStoredValues().load(evt.getRow(), null);
            evt.setRowValues(this.getStoredValues());
            return this.addEvent(evt);
        }

        public final boolean isStored() {
            return this.modif.size() > 0;
        }

        public final SQLRow getStoredRow() {
            return this.getEvent() == null ? null : this.getEvent().getRow();
        }

        public final SQLRowValues getStoredValues() {
            return this.getEvent() == null ? null : this.getEvent().getRowValues();
        }

        private final SQLTableEvent getEvent() {
            return CollectionUtils.getLast(this.modif);
        }

        private final SQLTableEvent addEvent(SQLTableEvent evt) {
            assert (evt != null);
            this.modif.add(evt);
            return evt;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.noLink;
        }
    }

    public static final class State<T> {
        private final List<SQLRowValues> valsPath;
        private final Path path;
        private T acc;
        private final ITransformer<State<T>, T> closure;

        State(List<SQLRowValues> valsPath, Path path, T acc, ITransformer<State<T>, T> closure) {
            this.valsPath = valsPath;
            this.path = path;
            this.acc = acc;
            this.closure = closure;
        }

        public SQLField getFrom() {
            return this.path.length() == 0 ? null : this.path.getSingleStep(this.path.length() - 1);
        }

        public final boolean isBackwards() {
            if (this.path.length() == 0) {
                throw new IllegalStateException("empty path");
            }
            return this.path.isBackwards(this.path.length() - 1);
        }

        StopRecurseException compute() {
            try {
                this.acc = this.closure.transformChecked(this);
                return null;
            }
            catch (StopRecurseException e) {
                return e;
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " path: " + this.path + " current node: " + this.getCurrent() + " current acc: " + this.getAcc();
        }

        public final SQLRowValues getCurrent() {
            return CollectionUtils.getLast(this.valsPath);
        }

        public final SQLRowValues getPrevious() {
            return CollectionUtils.getNoExn(this.valsPath, this.valsPath.size() - 2);
        }

        public final List<SQLRowValues> getValsPath() {
            return this.valsPath;
        }

        final boolean identityContains(SQLRowValues vals) {
            for (SQLRowValues v : this.valsPath) {
                if (vals != v) continue;
                return true;
            }
            return false;
        }

        public Path getPath() {
            return this.path;
        }

        public T getAcc() {
            return this.acc;
        }
    }

    public static final class StopRecurseException
    extends RuntimeException {
        private boolean completely = true;

        public StopRecurseException() {
        }

        public StopRecurseException(String message, Throwable cause) {
            super(message, cause);
        }

        public StopRecurseException(String message) {
            super(message);
        }

        public StopRecurseException(Throwable cause) {
            super(cause);
        }

        public final StopRecurseException setCompletely(boolean completely) {
            this.completely = completely;
            return this;
        }

        public final boolean isCompletely() {
            return this.completely;
        }
    }

    public static abstract class StoreMode {
        public static final StoreMode COMMIT = new Commit();

        abstract SQLTableEvent execOn(SQLRowValues var1) throws SQLException;
    }

    private static final class StoringLink
    extends Link {
        private Number destID = null;

        private StoringLink(Link l) {
            super(l.getSrc(), l.getField(), l.getDest());
        }

        public final boolean canStore() {
            return this.getDest() == null || this.destID != null;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " destID: " + this.destID;
        }
    }

    public static class ValueChangeEvent
    extends EventObject {
        private final Map<String, ?> added;
        private final Set<String> removed;

        private ValueChangeEvent(SQLRowValues vals, Map<String, ?> m) {
            super(vals);
            this.added = Collections.unmodifiableMap(m);
            this.removed = Collections.emptySet();
        }

        public ValueChangeEvent(SQLRowValues vals, String fieldName, Object newValue) {
            super(vals);
            this.added = Collections.singletonMap(fieldName, newValue);
            this.removed = Collections.emptySet();
        }

        public ValueChangeEvent(SQLRowValues vals, Set<String> removed) {
            super(vals);
            this.added = Collections.emptyMap();
            this.removed = Collections.unmodifiableSet(removed);
        }

        @Override
        public SQLRowValues getSource() {
            return (SQLRowValues)super.getSource();
        }

        public final Set<String> getAddedFields() {
            return this.added.keySet();
        }

        public final Set<String> getRemovedFields() {
            return this.removed;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " added : " + this.getAddedFields() + " removed: " + this.getRemovedFields();
        }
    }

    public static interface ValueChangeListener
    extends SQLRowValues.ReferentChangeListener {
        public void valueChange(ValueChangeEvent var1);
    }
}

