/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StreamUtils;

public class OOgenerationListeXML {
    private static Map<Sheet, Map<String, Map<Integer, String>>> cacheStyle = new HashMap<Sheet, Map<String, Map<Integer, String>>>();
    private static Point testPoint = new Point(0, 0);

    public static File genere(String templateId, File pathDest, String fileDest, Map<Integer, List<Map<String, Object>>> liste, Map<Integer, Map<String, Object>> values, Map<Integer, Map<Integer, String>> mapStyle, List<String> sheetName, SQLRow rowLanguage) {
        cacheStyle.clear();
        SAXBuilder builder = new SAXBuilder();
        try {
            InputStream xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, rowLanguage != null ? rowLanguage.getString("CHEMIN") : null, null);
            Document doc = builder.build(xmlConfiguration);
            Element racine = doc.getRootElement();
            InputStream template = TemplateManager.getInstance().getTemplate(templateId, rowLanguage != null ? rowLanguage.getString("CHEMIN") : null, null);
            SpreadSheet spreadSheet = new ODPackage(template).getSpreadSheet();
            Sheet sheet0 = spreadSheet.getSheet(0);
            if (sheetName != null && sheetName.size() > 0) {
                int i = 1;
                while (i < sheetName.size()) {
                    sheet0.copy(i, sheetName != null ? sheetName.get(i) : "Feuille " + i);
                    ++i;
                }
                spreadSheet.getSheet(0).setName(sheetName.get(0));
            }
            for (Integer i : liste.keySet()) {
                Sheet sheet = spreadSheet.getSheet(i.intValue());
                List children = racine.getChildren("element" + i);
                if (children.size() == 0) {
                    children = racine.getChildren("element");
                }
                OOgenerationListeXML.parseElementsXML(children, sheet, values.get(i));
                Element child = racine.getChild("table" + i);
                if (child == null) {
                    child = racine.getChild("table");
                }
                OOgenerationListeXML.parseListeXML(child, liste.get(i), sheet, mapStyle.get(i));
            }
            cacheStyle.clear();
            return OOgenerationListeXML.saveSpreadSheet(spreadSheet, pathDest, fileDest, templateId, rowLanguage);
        }
        catch (JDOMException e) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration du fichier " + fileDest, e);
        }
        catch (IOException e) {
            ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du fichier " + fileDest, e);
        }
        cacheStyle.clear();
        return null;
    }

    private static void parseElementsXML(List<Element> elts, Sheet sheet, Map<String, Object> values) {
        if (values == null) {
            return;
        }
        for (Element elt : elts) {
            boolean controlLine;
            String name = elt.getAttributeValue("ValueName");
            Object result = values.get(name);
            if (result == null) continue;
            boolean bl = elt.getAttributeValue("controleMultiline") == null ? true : (controlLine = !elt.getAttributeValue("controleMultiline").equalsIgnoreCase("false"));
            boolean useOOFormat = elt.getAttributeValue("useOOFormat") == null ? true : !elt.getAttributeValue("useOOFormat").equalsIgnoreCase("false");
            boolean replace = elt.getAttributeValue("type").equalsIgnoreCase("Replace");
            String replacePattern = elt.getAttributeValue("replacePattern");
            OOgenerationListeXML.fill(sheet.resolveHint(elt.getAttributeValue("location")), result, sheet, replace, replacePattern, null, false, controlLine, useOOFormat);
        }
    }

    private static void parseListeXML(Element tableau, List<Map<String, Object>> liste, Sheet sheet, Map<Integer, String> style) {
        if (liste == null || tableau == null) {
            return;
        }
        String oLastColTmp = tableau.getAttributeValue("lastColumn");
        int lastColumn = -1;
        int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        if (oLastColTmp != null) {
            lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
        }
        Map<String, Map<Integer, String>> mapStyle = OOgenerationListeXML.searchStyle(sheet, lastColumn, endPageLine);
        int nbPage = OOgenerationListeXML.fillTable(tableau, liste, sheet, mapStyle, true, style);
        int firstLine = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        int endLine = Integer.valueOf(tableau.getAttributeValue("endLine"));
        Object printRangeObj = sheet.getPrintRanges();
        System.err.println("Nombre de page == " + nbPage);
        if (nbPage == 1) {
            OOgenerationListeXML.fillTable(tableau, liste, sheet, mapStyle, false, style);
        } else {
            String pageRef;
            if (printRangeObj != null) {
                String s = printRangeObj.toString();
                String[] range = s.split(":");
                int i = 0;
                while (i < range.length) {
                    String string = range[i];
                    range[i] = string.subSequence(string.indexOf(46) + 1, string.length()).toString();
                    ++i;
                }
                int rowEnd = -1;
                if (range.length > 1) {
                    rowEnd = sheet.resolveHint((String)range[1]).y + 1;
                    int rowEndNew = rowEnd * (nbPage + 1);
                    String sNew = s.replaceAll(String.valueOf(rowEnd), String.valueOf(rowEndNew));
                    sheet.setPrintRanges(sNew);
                    System.err.println(" ******  Replace print ranges; Old:" + rowEnd + "--" + s + " New:" + rowEndNew + "--" + sNew);
                }
            }
            sheet.duplicateFirstRows(endLine, 1);
            int lineToAdd = endPageLine - endLine;
            sheet.insertDuplicatedRows(firstLine, lineToAdd);
            System.err.println("nbPage == " + nbPage);
            if (nbPage > 2) {
                sheet.duplicateFirstRows(endPageLine, nbPage - 2);
            }
            if ((pageRef = tableau.getAttributeValue("pageRef")) != null && pageRef.trim().length() > 0) {
                MutableCell cell = sheet.getCellAt(pageRef);
                cell.setValue((Object)("Page 1/" + nbPage));
                int i = 1;
                while (i < nbPage) {
                    MutableCell cell2 = sheet.getCellAt(cell.getX(), cell.getY() + endPageLine * i);
                    cell2.setValue((Object)("Page " + (i + 1) + "/" + nbPage));
                    ++i;
                }
            }
            OOgenerationListeXML.fillTable(tableau, liste, sheet, mapStyle, false, style);
        }
    }

    private static int fillTable(Element tableau, List<Map<String, Object>> liste, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test, Map<Integer, String> style) {
        String oTmpA;
        String oTmp;
        String styleOOA;
        Map<Integer, String> mTmp;
        int nbPage = 1;
        int currentLineTmp = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        int currentLine = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        List listElts = tableau.getChildren("element");
        Object o = null;
        String columnSousTotal = tableau.getAttributeValue("groupSousTotalColumn");
        HashMap<String, Double> mapSousTotal = new HashMap<String, Double>();
        HashMap<String, Double> mapTotal = new HashMap<String, Double>();
        int i = 0;
        while (i < liste.size()) {
            Map<String, Object> mValues = liste.get(i);
            String styleName = null;
            int nbCellule = 1;
            Iterator j = listElts.iterator();
            while (j.hasNext()) {
                boolean useOOFormat;
                boolean controlLine;
                if (currentLine - 1 + OOgenerationListeXML.fill(testPoint, "test", sheet, false, null, null, true) > endPageLine * nbPage) {
                    currentLineTmp = currentLine = currentLineTmp + endPageLine;
                    ++nbPage;
                }
                Element e = (Element)j.next();
                String loc = String.valueOf(e.getAttributeValue("location").trim()) + currentLine;
                boolean bl = e.getAttributeValue("controleMultiline") == null ? true : (controlLine = !e.getAttributeValue("controleMultiline").equalsIgnoreCase("false"));
                boolean bl2 = e.getAttributeValue("useOOFormat") == null ? true : (useOOFormat = !e.getAttributeValue("useOOFormat").equalsIgnoreCase("false"));
                if (!e.getAttributeValue("type").equalsIgnoreCase("fill") && !e.getAttributeValue("type").equalsIgnoreCase("replace")) continue;
                Object value = OOgenerationListeXML.getElementValue(e, mValues);
                Point resolveHint = sheet.resolveHint(loc);
                if (e.getAttributeValue("location").trim().equals(columnSousTotal)) {
                    if (o != null) {
                        if (!o.equals(value)) {
                            for (String object : mapSousTotal.keySet()) {
                                System.err.println(String.valueOf(object) + " = " + mapSousTotal.get(object));
                                String styleSousTotalName = "Titre 1";
                                if (style != null && style.get(i) != null) {
                                    styleSousTotalName = style.get(i);
                                }
                                Map<Integer, String> mTmp2 = mapStyle.get(styleSousTotalName);
                                String styleOO = null;
                                String styleOOA2 = null;
                                if (mTmp2 != null) {
                                    String oTmp2 = mTmp2.get(resolveHint.x);
                                    styleOO = oTmp2 == null ? null : oTmp2.toString();
                                    String oTmpA2 = mTmp2.get(0);
                                    styleOOA2 = oTmpA2 == null ? null : oTmpA2.toString();
                                }
                                OOgenerationListeXML.fill(test ? testPoint : sheet.resolveHint("A" + currentLine), "Sous total", sheet, false, null, styleOOA2, test, controlLine, useOOFormat);
                                OOgenerationListeXML.fill(test ? testPoint : sheet.resolveHint(String.valueOf(object) + currentLine), mapSousTotal.get(object), sheet, false, null, styleOO, test, controlLine, useOOFormat);
                            }
                            mapSousTotal.clear();
                            loc = String.valueOf(e.getAttributeValue("location").trim()) + (currentLine += 2);
                            resolveHint = sheet.resolveHint(loc);
                            o = value;
                        }
                    } else {
                        o = value;
                    }
                }
                if (value instanceof Number) {
                    String attributeValue2;
                    String attributeValue = e.getAttributeValue("total");
                    if (attributeValue != null && attributeValue.equalsIgnoreCase("true")) {
                        OOgenerationListeXML.incrementTotal(e.getAttributeValue("location"), (Number)value, mapTotal);
                    }
                    if ((attributeValue2 = e.getAttributeValue("sousTotal")) != null && attributeValue2.equalsIgnoreCase("true")) {
                        OOgenerationListeXML.incrementTotal(e.getAttributeValue("location"), (Number)value, mapSousTotal);
                    }
                }
                boolean replace = e.getAttributeValue("type").equalsIgnoreCase("replace");
                if (test || sheet.isCellValid(resolveHint.x, resolveHint.y)) {
                    if (style != null) {
                        styleName = style.get(i);
                    }
                    Map<Integer, String> mTmp3 = styleName == null ? null : mapStyle.get(styleName);
                    String styleOO = null;
                    if (mTmp3 != null) {
                        String oTmp3 = mTmp3.get(new Integer(resolveHint.x));
                        styleOO = oTmp3 == null ? null : oTmp3.toString();
                    }
                    int tmpCelluleAffect = OOgenerationListeXML.fill(test ? testPoint : resolveHint, value, sheet, replace, null, styleOO, test, controlLine, useOOFormat);
                    nbCellule = Math.max(nbCellule, tmpCelluleAffect);
                    continue;
                }
                System.err.println("Cell not valid at " + loc);
            }
            currentLine += nbCellule;
            ++i;
        }
        for (String object : mapSousTotal.keySet()) {
            System.err.println(String.valueOf(object) + " = " + mapSousTotal.get(object));
            mTmp = mapStyle.get("Titre 1");
            String styleOO = null;
            styleOOA = null;
            if (mTmp != null) {
                oTmp = mTmp.get(sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)object)).append((int)currentLine).toString()).x);
                styleOO = oTmp == null ? null : oTmp.toString();
                oTmpA = mTmp.get(0);
                styleOOA = oTmpA == null ? null : oTmpA.toString();
            }
            OOgenerationListeXML.fill(test ? testPoint : sheet.resolveHint("A" + currentLine), "Sous total", sheet, false, null, styleOOA, test);
            OOgenerationListeXML.fill(test ? testPoint : sheet.resolveHint(String.valueOf(object) + currentLine), mapSousTotal.get(object), sheet, false, null, styleOO, test);
        }
        for (String object : mapTotal.keySet()) {
            System.err.println(String.valueOf(object) + " = " + mapTotal.get(object));
            mTmp = mapStyle.get("Titre 1");
            String styleOO = null;
            styleOOA = null;
            if (mTmp != null) {
                oTmp = mTmp.get(sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)object)).append((int)(currentLine + 1)).toString()).x);
                styleOO = oTmp == null ? null : oTmp.toString();
                oTmpA = mTmp.get(0);
                styleOOA = oTmpA == null ? null : oTmpA.toString();
            }
            OOgenerationListeXML.fill(test ? testPoint : sheet.resolveHint("A" + (currentLine + 1)), "Total", sheet, false, null, styleOOA, test);
            OOgenerationListeXML.fill(test ? testPoint : sheet.resolveHint(String.valueOf(object) + (currentLine + 1)), mapTotal.get(object), sheet, false, null, styleOO, test);
        }
        return nbPage;
    }

    private static void incrementTotal(String field, Number value, Map<String, Double> map) {
        Double d = map.get(field);
        if (d == null) {
            map.put(field, value.doubleValue());
        } else {
            map.put(field, d + value.doubleValue());
        }
    }

    private static Object getElementValue(Element elt, Map<String, Object> mValues) {
        String attributeValueMaxChar;
        Object res = "";
        List eltFields = elt.getChildren("field");
        if (eltFields != null) {
            if (eltFields.size() > 1) {
                String result = "";
                Iterator j = eltFields.iterator();
                while (j.hasNext()) {
                    Object o = OOgenerationListeXML.getValueOfComposant((Element)j.next(), mValues);
                    if (o == null) continue;
                    result = String.valueOf(result) + o.toString() + " ";
                }
                res = result;
            } else {
                res = OOgenerationListeXML.getValueOfComposant((Element)eltFields.get(0), mValues);
            }
        }
        if ((attributeValueMaxChar = elt.getAttributeValue("maxChar")) != null) {
            int maxChar = Integer.valueOf(attributeValueMaxChar);
            if (res != null && res.toString().length() > maxChar) {
                res = res.toString().substring(0, maxChar);
            }
        }
        return res;
    }

    private static Object getValueOfComposant(Element eltField, Map<String, Object> mValues) {
        String field = eltField.getAttributeValue("name");
        return mValues.get(field);
    }

    private static int fill(Point resolveHint, Object value, Sheet sheet, boolean replace, String replacePattern, String styleOO, boolean test) {
        return OOgenerationListeXML.fill(resolveHint, value, sheet, replace, replacePattern, styleOO, test, true, true);
    }

    private static int fill(Point resolveHint, Object value, Sheet sheet, boolean replace, String replacePattern, String styleOO, boolean test, boolean controlLine, boolean useOOFormat) {
        int nbCellule = 1;
        if (test || sheet.isCellValid(resolveHint.x, resolveHint.y)) {
            if (controlLine && value != null && value.toString().indexOf(10) >= 0) {
                if (!test) {
                    MutableCell cell = sheet.getCellAt(resolveHint.x, resolveHint.y);
                    String firstPart = value.toString().substring(0, value.toString().indexOf(10));
                    String secondPart = value.toString().substring(value.toString().indexOf(10) + 1, value.toString().length());
                    secondPart = secondPart.replace('\n', ',');
                    OOgenerationListeXML.setCellValue(cell, firstPart, replace, replacePattern, useOOFormat);
                    if (styleOO != null) {
                        cell.setStyleName(styleOO);
                    }
                    try {
                        MutableCell cellSec = sheet.getCellAt(resolveHint.x, resolveHint.y + 1);
                        OOgenerationListeXML.setCellValue(cellSec, secondPart, replace, replacePattern, useOOFormat);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                nbCellule = 2;
            } else if (!test) {
                MutableCell cell = sheet.getCellAt(resolveHint.x, resolveHint.y);
                OOgenerationListeXML.setCellValue(cell, value, replace, replacePattern, useOOFormat);
                if (styleOO != null) {
                    cell.setStyleName(styleOO);
                }
            }
        }
        return nbCellule;
    }

    private static void setCellValue(MutableCell cell, Object value, boolean replace, String replacePattern, boolean useOOFormat) {
        if (value == null) {
            value = "";
        }
        if (replace) {
            if (replacePattern != null) {
                cell.replaceBy(replacePattern, value.toString());
            } else {
                cell.replaceBy("_", value.toString());
            }
        } else if (useOOFormat) {
            cell.setValue(value);
        } else {
            cell.setTextP(value.toString());
        }
    }

    private static File saveSpreadSheet(SpreadSheet ssheet, File pathDest, String fileName, String templateId, SQLRow rowLanguage) throws IOException {
        if (ssheet == null || pathDest == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        File fDest = new File(pathDest, String.valueOf(fileName) + ".ods");
        if (!pathDest.exists()) {
            pathDest.mkdirs();
        }
        SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, pathDest, fDest);
        try {
            ssheet.saveAs(fDest);
        }
        catch (FileNotFoundException e) {
            final File F = fDest;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JOptionPane.showMessageDialog(null, "Le fichier " + F.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n V\u00e9rifiez qu'il n'est pas d\u00e9j\u00e0 ouvert.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            e.printStackTrace();
        }
        try {
            File odspOut = new File(pathDest, String.valueOf(fileName) + ".odsp");
            InputStream odspIn = TemplateManager.getInstance().getTemplatePrintConfiguration(templateId, rowLanguage != null ? rowLanguage.getString("CHEMIN") : null, null);
            if (odspIn != null) {
                StreamUtils.copy(odspIn, odspOut);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Le fichier odsp n'existe pas.");
        }
        return fDest;
    }

    private static Map<String, Map<Integer, String>> searchStyle(Sheet sheet, int colEnd, int rowEnd) {
        if (cacheStyle.get(sheet) != null) {
            return cacheStyle.get(sheet);
        }
        Map<String, Map<Integer, String>> mapStyleDef = StyleSQLElement.getMapAllStyle();
        int columnCount = colEnd == -1 ? sheet.getColumnCount() : colEnd + 1;
        System.err.println("End column search : " + columnCount);
        int rowCount = rowEnd > 0 ? rowEnd : sheet.getRowCount();
        System.err.println("End row search : " + rowCount);
        int i = 0;
        while (i < rowCount) {
            int x = 0;
            HashMap<Integer, String> mapCellStyle = new HashMap<Integer, String>();
            String style = "";
            int j = 0;
            while (j < columnCount) {
                block11: {
                    try {
                        if (!sheet.isCellValid(j, i)) break block11;
                        MutableCell c = sheet.getCellAt(j, i);
                        String cellStyle = c.getStyleName();
                        try {
                            if (mapStyleDef.containsKey(c.getValue().toString())) {
                                style = c.getValue().toString();
                            }
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        mapCellStyle.put(x, cellStyle);
                        if (style.trim().length() != 0) {
                            String styleCell;
                            c.clearValue();
                            if (!style.trim().equalsIgnoreCase("Normal") && mapStyleDef.get("Normal") != null && (styleCell = mapStyleDef.get("Normal").get(x)) != null && styleCell.length() != 0) {
                                c.setStyleName(styleCell);
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println("Index out of bounds Exception");
                    }
                }
                ++x;
                ++j;
            }
            if (style.length() > 0) {
                mapStyleDef.put(style, mapCellStyle);
            }
            ++i;
        }
        cacheStyle.put(sheet, mapStyleDef);
        return mapStyleDef;
    }
}

