/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;

public class FamilleArticleSQLElement
extends ComptaSQLConfElement {
    public FamilleArticleSQLElement() {
        super("FAMILLE_ARTICLE", "une famille d'article", "familles d'articles");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"), 4);
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)labelNom, c);
                JTextField textNom = new JTextField(15);
                ++c.gridx;
                c.weightx = 1.0;
                DefaultGridBagConstraints.lockMinimumSize(textNom);
                this.add((Component)textNom, c);
                this.addRequiredSQLObject(textNom, "NOM");
                JLabel labelFamille = new JLabel(this.getLabelFor("ID_FAMILLE_ARTICLE_PERE"), 4);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                this.add((Component)labelFamille, c);
                ElementComboBox familleBox = new ElementComboBox(true, 25);
                DefaultGridBagConstraints.lockMinimumSize(familleBox);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)familleBox, c);
                this.addSQLObject(familleBox, "ID_FAMILLE_ARTICLE_PERE");
                JLabel labelCompte = new JLabel(this.getLabelFor("ID_COMPTE_PCE"), 4);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                this.add((Component)labelCompte, c);
                ElementComboBox compteBox = new ElementComboBox(true, 25);
                DefaultGridBagConstraints.lockMinimumSize(compteBox);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)compteBox, c);
                this.addSQLObject(compteBox, "ID_COMPTE_PCE");
                JLabel labelCompteAchat = new JLabel(this.getLabelFor("ID_COMPTE_PCE_ACHAT"), 4);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                this.add((Component)labelCompteAchat, c);
                ElementComboBox compteBoxAchat = new ElementComboBox(true, 25);
                DefaultGridBagConstraints.lockMinimumSize(compteBoxAchat);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)compteBoxAchat, c);
                this.addSQLObject(compteBoxAchat, "ID_COMPTE_PCE_ACHAT");
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
                this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
                c.fill = 2;
                c.weightx = 1.0;
                this.add((Component)addP, c);
            }

            @Override
            public void update() {
                super.update();
                SQLRow row = this.getTable().getRow(this.getSelectedID());
                int idPere = row.getInt("ID_FAMILLE_ARTICLE_PERE");
                StringBuffer code = new StringBuffer();
                if (idPere > 1) {
                    SQLRow rowPere = this.getTable().getRow(idPere);
                    code.append(rowPere.getString("CODE"));
                } else {
                    code.append('1');
                }
                code.append("." + this.getSelectedID());
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("CODE", code.toString());
                try {
                    rowVals.update(this.getSelectedID());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                SQLRow row = this.getTable().getRow(id);
                int idPere = row.getInt("ID_FAMILLE_ARTICLE_PERE");
                StringBuffer code = new StringBuffer();
                if (idPere > 1) {
                    SQLRow rowPere = this.getTable().getRow(idPere);
                    code.append(rowPere.getString("CODE"));
                } else {
                    code.append('1');
                }
                code.append("." + id);
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("CODE", code.toString());
                try {
                    rowVals.update(id);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return id;
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".family";
    }
}

