/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;

public class PaiementPanel
extends JPanel
implements MouseListener,
BarcodeListener,
CaisseListener {
    private Image bg;
    private Image bg2;
    private Image bgCB;
    private Image bgCHEQUE;
    private Image bgESPECES;
    private CaisseControler controller;
    private String calculatorValue = "";
    private char mode = (char)32;
    private boolean init = true;

    public PaiementPanel(CaisseControler controller) {
        this.controller = controller;
        this.controller.addCaisseListener(this);
        this.controller.addBarcodeListener(this);
        this.setOpaque(false);
        this.bg = new ImageIcon(TicketPanel.class.getResource("calculator.png")).getImage();
        this.bg2 = new ImageIcon(TicketPanel.class.getResource("calculator_selected.png")).getImage();
        this.bgCB = new ImageIcon(TicketPanel.class.getResource("cb.png")).getImage();
        this.bgCHEQUE = new ImageIcon(TicketPanel.class.getResource("cheque.png")).getImage();
        this.bgESPECES = new ImageIcon(TicketPanel.class.getResource("especes.png")).getImage();
        this.addMouseListener(this);
        this.setLayout(null);
        StatusBar st = new StatusBar();
        st.setTitle("R\u00e8glement");
        st.setLocation(0, 0);
        st.setSize(320, (int)st.getPreferredSize().getHeight());
        this.add(st);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int y = this.getHeight() - this.bg.getHeight(null);
        if (this.controller.getArticleSelected() != null || this.controller.getPaiementSelected() != null) {
            g.drawImage(this.bg2, 0, y, null);
        } else {
            g.drawImage(this.bg, 0, y, null);
        }
        g.drawLine(0, 0, 0, this.getHeight());
        y = 50;
        for (Paiement p : this.controller.getPaiements()) {
            if (p.getType() == 3) {
                g.drawImage(this.bgCB, 0, y, null);
                this.drawMontant(g, p, 242, y);
            } else if (p.getType() == 2) {
                g.drawImage(this.bgCHEQUE, 0, y, null);
                this.drawMontant(g, p, 242, y);
            } else if (p.getType() == 1) {
                g.drawImage(this.bgESPECES, 0, y, null);
                this.drawMontant(g, p, 300, y);
            }
            y += 64;
        }
        this.drawCalculator(g);
        if (Boolean.getBoolean("sales.pos.debug")) {
            this.drawGrid(g);
        }
        super.paint(g);
    }

    private void drawGrid(Graphics g) {
        g.setColor(Color.RED);
        int x = 0;
        while (x < 320) {
            int y = 28;
            while (y < 900) {
                g.drawLine(x, y, x + 2, y + 2);
                y += 72;
            }
            x += 80;
        }
    }

    private void drawCalculator(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int y = this.getHeight() - this.bg.getHeight(null);
        g.setFont(new Font("Arial", 0, 32));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Article article = this.controller.getArticleSelected();
        g.setColor(Color.DARK_GRAY);
        if (article != null) {
            String string = this.calculatorValue;
            g.setFont(g.getFont().deriveFont(52.0f));
            Rectangle2D r1 = g.getFontMetrics().getStringBounds(string, g2);
            g.drawString(string, (int)(260.0 - r1.getWidth()), 500 + y);
            g.setFont(g.getFont().deriveFont(14.0f));
            g.drawString("Quantit\u00e9", 10, 460 + y);
        } else {
            Paiement paiement = this.controller.getPaiementSelected();
            if (paiement != null) {
                String string = this.calculatorValue;
                g.setFont(g.getFont().deriveFont(52.0f));
                Rectangle2D r1 = g.getFontMetrics().getStringBounds(string, g2);
                g.drawString(string, (int)(300.0 - r1.getWidth()), 500 + y);
                g.setFont(g.getFont().deriveFont(14.0f));
                String str = "Paiement ";
                if (paiement.getType() == 3) {
                    str = String.valueOf(str) + " CB";
                } else if (paiement.getType() == 1) {
                    str = String.valueOf(str) + " en esp\u00e8ces";
                } else if (paiement.getType() == 2) {
                    str = String.valueOf(str) + " par ch\u00e8que";
                }
                g.drawString(str, 10, 460 + y);
            }
        }
        g.setFont(g.getFont().deriveFont(14.0f));
        g.drawString("" + this.mode, 10, 480 + y);
    }

    private char getToucheFrom(int x, int y) {
        int yy = (this.getHeight() - y) / 72;
        int xx = x / 80;
        switch (yy) {
            case 0: {
                if (xx == 0) {
                    return '0';
                }
                if (xx == 1) {
                    return '0';
                }
                if (xx == 2) {
                    return '.';
                }
                if (xx != 3) break;
                return '=';
            }
            case 1: {
                if (xx == 0) {
                    return '1';
                }
                if (xx == 1) {
                    return '2';
                }
                if (xx == 2) {
                    return '3';
                }
                if (xx != 3) break;
                return '=';
            }
            case 2: {
                if (xx == 0) {
                    return '4';
                }
                if (xx == 1) {
                    return '5';
                }
                if (xx == 2) {
                    return '6';
                }
                if (xx != 3) break;
                return '+';
            }
            case 3: {
                if (xx == 0) {
                    return '7';
                }
                if (xx == 1) {
                    return '8';
                }
                if (xx == 2) {
                    return '9';
                }
                if (xx != 3) break;
                return '+';
            }
            case 4: {
                if (xx == 0) {
                    return 'c';
                }
                if (xx == 1) {
                    return 'c';
                }
                if (xx == 2) {
                    return '*';
                }
                if (xx != 3) break;
                return '-';
            }
        }
        return '?';
    }

    private void drawMontant(Graphics g, Paiement p, int x, int y) {
        y += 36;
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.GRAY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int cents = p.getMontantInCents() % 100;
        int euros = p.getMontantInCents() / 100;
        String sCents = String.valueOf(cents);
        if (sCents.length() < 2) {
            sCents = "0" + sCents;
        }
        g.setFont(this.getFont().deriveFont(18.0f));
        Rectangle2D r1 = g.getFontMetrics().getStringBounds(sCents, g2);
        g.drawString(sCents, (int)((double)x - r1.getWidth()), y);
        g.setFont(g.getFont().deriveFont(36.0f));
        g.setFont(g.getFont().deriveFont(1));
        g.setColor(Color.WHITE);
        String sEuros = String.valueOf(String.valueOf(euros)) + ".";
        Rectangle2D r2 = g.getFontMetrics().getStringBounds(sEuros, g2);
        g.drawString(sEuros, (int)((double)x - r1.getWidth() - r2.getWidth()), y);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(320, 900);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(320, 900);
    }

    @Override
    public void caisseStateChanged() {
        if (this.controller.getArticleSelected() != null) {
            this.initCaisseArticle();
        } else if (this.controller.getPaiementSelected() != null) {
            this.initCaissePaiement();
        }
        this.repaint();
    }

    private void initCaisseArticle() {
        this.calculatorValue = String.valueOf(this.controller.getItemCount(this.controller.getArticleSelected()));
        this.init = true;
        this.mode = (char)32;
    }

    private void initCaissePaiement() {
        this.calculatorValue = TicketCellRenderer.centsToString(this.controller.getPaiementSelected().getMontantInCents());
        this.init = true;
        this.mode = (char)32;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        char c = this.getToucheFrom(e.getX(), e.getY());
        if (c != '?') {
            this.handleCharacter(c);
        } else {
            Paiement p = this.getPaiementFrom(e.getY());
            if (p != null) {
                if (e.getX() > 256 && p.getType() != 1 && this.controller.canAddPaiement(p.getType())) {
                    p = new Paiement(p.getType());
                    this.controller.addPaiement(p);
                }
                this.controller.autoFillPaiement(p);
                this.calculatorValue = TicketCellRenderer.centsToString(p.getMontantInCents());
                if (p.getType() == 1) {
                    this.controller.openDrawer();
                }
            }
            this.controller.setPaiementSelected(p);
        }
    }

    private void handleCharacter(char c) {
        System.out.println("Handle: " + c);
        if (c == '?') {
            return;
        }
        Article article = this.controller.getArticleSelected();
        if (c == '+' || c == '-' || c == '*') {
            this.mode = c;
            this.repaint();
            return;
        }
        if (article != null) {
            if (c == 'c' || c == '/') {
                System.out.println("Clear quantit\u00e9");
                this.mode = (char)32;
                this.controller.clearArticle(article);
            } else if (c == '=' || c == '\n') {
                if (!this.init) {
                    int v = Integer.parseInt(this.calculatorValue);
                    if (this.mode == ' ') {
                        this.controller.setArticleCount(article, v);
                    } else if (this.mode == '+') {
                        this.controller.setArticleCount(article, this.controller.getItemCount(article) + v);
                    } else if (this.mode == '-') {
                        this.controller.setArticleCount(article, this.controller.getItemCount(article) - v);
                    } else if (this.mode == '*') {
                        this.controller.setArticleCount(article, this.controller.getItemCount(article) * v);
                    }
                }
                this.initCaisseArticle();
            } else if (Character.isDigit(c)) {
                if (this.init) {
                    this.calculatorValue = "";
                    this.init = false;
                }
                if (this.calculatorValue.length() < 8) {
                    this.calculatorValue = String.valueOf(this.calculatorValue) + c;
                }
            }
        } else {
            Paiement paiement = this.controller.getPaiementSelected();
            if (paiement != null) {
                if (c == 'c' || c == '/') {
                    System.out.println("Clear paiement");
                    this.mode = (char)32;
                    this.controller.clearPaiement(paiement);
                } else if (c == '.' && this.calculatorValue.indexOf(46) < 0) {
                    this.calculatorValue = String.valueOf(this.calculatorValue) + ".";
                } else if (c == '=' || c == '\n') {
                    if (!this.init) {
                        int v = this.getCentsFrom(this.calculatorValue);
                        if (this.mode == ' ') {
                            this.controller.setPaiementValue(paiement, v);
                        } else if (this.mode == '+') {
                            this.controller.setPaiementValue(paiement, paiement.getMontantInCents() + v);
                        } else if (this.mode == '-') {
                            this.controller.setPaiementValue(paiement, paiement.getMontantInCents() - v);
                        } else if (this.mode == '*') {
                            this.controller.setPaiementValue(paiement, paiement.getMontantInCents() * v);
                        }
                    }
                    this.initCaissePaiement();
                    this.controller.setPaiementSelected(null);
                } else if (Character.isDigit(c)) {
                    int i;
                    if (this.init) {
                        this.calculatorValue = "";
                        this.init = false;
                    }
                    if (this.calculatorValue.length() < 9 && ((i = this.calculatorValue.indexOf(46)) < 0 || i >= 0 && this.calculatorValue.length() - i < 3)) {
                        this.calculatorValue = String.valueOf(this.calculatorValue) + c;
                    }
                }
            }
        }
        this.repaint();
    }

    private int getCentsFrom(String str) {
        int i = str.indexOf(46);
        if (i >= 0) {
            String euros = str.substring(0, i);
            String cents = str.substring(i + 1);
            if (cents.length() == 1) {
                cents = String.valueOf(cents) + "0";
            }
            int e = 0;
            if (euros.length() > 0) {
                e = Integer.parseInt(euros);
            }
            int c = 0;
            if (cents.length() > 0) {
                c = Integer.parseInt(cents);
            }
            return e * 100 + c;
        }
        return Integer.parseInt(str) * 100;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void barcodeRead(String code) {
    }

    private Paiement getPaiementFrom(int y) {
        int index = (y - 50) / 64;
        if (index < this.controller.getPaiements().size() && index >= 0) {
            return this.controller.getPaiements().get(index);
        }
        return null;
    }

    @Override
    public void keyReceived(KeyEvent e) {
        if (e.getID() == 400) {
            System.out.println("PaiementPanel.keyPressed()" + e.getKeyChar());
            this.handleCharacter(e.getKeyChar());
        }
    }
}

