/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.GestionDevise;

public class DeviseKmRowValuesRenderer
extends DefaultTableCellRenderer {
    private static final Color red = new Color(255, 31, 52);
    private static final Color redGrey = new Color(224, 115, 137);
    private static final Color redLightGrey = new Color(240, 65, 85);
    private List<Integer> listRow = new ArrayList<Integer>();

    public DeviseKmRowValuesRenderer() {
        AlternateTableCellRenderer.setBGColorMap(this, red, redLightGrey);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value.getClass() == Long.class) {
            this.setText(GestionDevise.currencyToString((Long)value));
            this.setHorizontalAlignment(4);
        }
        if (this.listRow.contains(row)) {
            if (isSelected) {
                this.setBackground(redGrey);
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(red);
                this.setForeground(Color.WHITE);
            }
        } else {
            TableCellRendererUtils.setColors(this, table, isSelected);
        }
        return this;
    }

    public void setValid(boolean b, int index) {
        if (b) {
            if (this.listRow.contains(index)) {
                this.listRow.remove((Object)index);
            }
        } else if (!this.listRow.contains(index)) {
            this.listRow.add(index);
        }
    }
}

