/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.utils.GestionDevise;

public class DeviseCellEditor
extends AbstractCellEditor
implements MouseListener,
TableCellEditor {
    private JTextField textField = new JTextField();
    private float taxe = 19.6f;

    public DeviseCellEditor() {
        this.textField.setBorder(new LineBorder(Color.black));
        this.textField.setHorizontalAlignment(4);
        this.textField.addKeyListener(new KeyAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = DeviseCellEditor.this.textField.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (DeviseCellEditor.this.textField.getSelectedText() != null) return;
                    if (DeviseCellEditor.this.textField.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (DeviseCellEditor.this.textField.getText().substring(pointPosition).length() <= 2) {
                        return;
                    }
                }
                if (keychar == '.' && DeviseCellEditor.this.textField.getText().indexOf(46) < 0) {
                    return;
                }
                if (keychar == '-' && DeviseCellEditor.this.textField.getText().indexOf(45) < 0 && DeviseCellEditor.this.textField.getCaretPosition() == 0) {
                    return;
                }
                keyEvent.consume();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DeviseCellEditor.this.textField.selectAll();
            }
        });
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        return new Long(GestionDevise.parseLongCurrency(this.textField.getText()));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(GestionDevise.currencyToString(value == null ? 0L : (Long)value));
        this.textField.selectAll();
        this.textField.grabFocus();
        return this.textField;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.textField.getText().trim().length() > 0 && e.getButton() == 3) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Convertir en HT (TVA " + this.taxe + ")"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = DeviseCellEditor.this.textField.getText();
                    PrixTTC p = new PrixTTC(GestionDevise.parseLongCurrency(s));
                    DeviseCellEditor.this.textField.setText(GestionDevise.currencyToString(p.calculLongHT((double)DeviseCellEditor.this.taxe / 100.0)));
                }
            });
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

