/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.openconcerto.erp.panel.PostgreSQLFrame;
import org.openconcerto.erp.panel.UserExitPanel;
import org.openconcerto.utils.ExceptionHandler;

public class Gestion {
    public static final File MODULES_DIR = new File("Modules");
    private static List<Image> frameIcon;
    static final boolean MAC_OS_X;
    public static PostgreSQLFrame pgFrameStart;
    private static JDialog frameExit;

    static {
        MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        pgFrameStart = null;
        frameExit = null;
    }

    static boolean inWebStart() {
        try {
            String[] names = (String[])Class.forName("javax.jnlp.ServiceManager").getMethod("getServiceNames", new Class[0]).invoke(null, new Object[0]);
            return names != null && names.length > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static final boolean isMinimalMode() {
        return Boolean.getBoolean("org.openconcerto.erp.minimal");
    }

    static void askForExit() {
        JDialog exitDialog = new JDialog();
        exitDialog.setModal(true);
        if (frameExit == null) {
            frameExit = new JDialog();
            frameExit.setContentPane(new UserExitPanel());
            frameExit.setTitle("Quitter");
            frameExit.setModal(true);
            frameExit.setIconImages(Gestion.getFrameIcon());
            frameExit.setDefaultCloseOperation(1);
        }
        frameExit.pack();
        frameExit.setResizable(false);
        frameExit.setLocationRelativeTo(null);
        frameExit.setAlwaysOnTop(true);
        frameExit.setVisible(true);
    }

    public static List<Image> getFrameIcon() {
        if (frameIcon == null) {
            frameIcon = new ArrayList<Image>();
            int[] sizes = new int[]{16, 32, 48, 96};
            int i = 0;
            while (i < sizes.length) {
                int v = sizes[i];
                try {
                    frameIcon.add(new ImageIcon(Gestion.class.getResource(String.valueOf(v) + ".png")).getImage());
                }
                catch (Exception e) {
                    ExceptionHandler.die("Impossible de charger l'icone de fenetre " + v + ".png");
                }
                ++i;
            }
        }
        return frameIcon;
    }
}

