/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.ClosestFirstIterator;

public final class DijkstraShortestPath<V, E> {
    private List<E> edgeList;
    private double pathLength;

    public DijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex) {
        this(graph, startVertex, endVertex, Double.POSITIVE_INFINITY);
    }

    public DijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex, double radius) {
        if (!graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIterator<V, E> iter = new ClosestFirstIterator<V, E>(graph, startVertex, radius);
        while (iter.hasNext()) {
            Object vertex = iter.next();
            if (!vertex.equals(endVertex)) continue;
            this.createEdgeList(graph, iter, endVertex);
            this.pathLength = iter.getShortestPathLength(endVertex);
            return;
        }
        this.edgeList = null;
        this.pathLength = Double.POSITIVE_INFINITY;
    }

    public List<E> getPathEdgeList() {
        return this.edgeList;
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V startVertex, V endVertex) {
        DijkstraShortestPath<V, E> alg = new DijkstraShortestPath<V, E>(graph, startVertex, endVertex);
        return alg.getPathEdgeList();
    }

    private void createEdgeList(Graph<V, E> graph, ClosestFirstIterator<V, E> iter, V endVertex) {
        E edge;
        this.edgeList = new ArrayList();
        while ((edge = iter.getSpanningTreeEdge(endVertex)) != null) {
            this.edgeList.add(edge);
            endVertex = Graphs.getOppositeVertex(graph, edge, endVertex);
        }
        Collections.reverse(this.edgeList);
    }
}

