/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringUtils;

public final class FileUtils {
    private static final int CHANNEL_MAX_COUNT = Math.min(67076096, Integer.MAX_VALUE);
    public static final Set<String> VersionControl = CollectionUtils.createSet(".svn", "CVS");
    private static final Map<URL, File> files = new HashMap<URL, File>();
    private static final Map<String, String> ext2mime = new HashMap<String, String>();
    public static final Collection<Character> INVALID_CHARS;
    public static final StringUtils.Escaper FILENAME_ESCAPER;
    public static final FileFilter DIR_FILTER;
    public static final FileFilter REGULAR_FILE_FILTER;

    static {
        ext2mime.put(".xml", "text/xml");
        ext2mime.put(".jpg", "image/jpeg");
        ext2mime.put(".png", "image/png");
        ext2mime.put(".tiff", "image/tiff");
        FILENAME_ESCAPER = new StringUtils.Escaper('\'', 'Q');
        FILENAME_ESCAPER.add('\"', 'D').add(':', 'C').add('/', 'S').add('\\', 'A');
        FILENAME_ESCAPER.add('<', 'L').add('>', 'G').add('*', 'R').add('|', 'P').add('?', 'M');
        INVALID_CHARS = FILENAME_ESCAPER.getEscapedChars();
        DIR_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        REGULAR_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        };
    }

    private FileUtils() {
    }

    public static final List<File> list(File root, int depth, FileFilter ff) {
        return FileUtils.list(root, depth, depth, ff);
    }

    public static final List<File> list(File root, int minDepth, int maxDepth, FileFilter ff) {
        return FileUtils.list(root, minDepth, maxDepth, ff, false);
    }

    public static final List<File> list(File root, int minDepth, int maxDepth, FileFilter ff, boolean sort) {
        File currentFile;
        if (minDepth > maxDepth) {
            throw new IllegalArgumentException(String.valueOf(minDepth) + " > " + maxDepth);
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException(String.valueOf(maxDepth) + " < 0");
        }
        if (!root.exists()) {
            return Collections.emptyList();
        }
        File file = currentFile = FileUtils.accept(ff, minDepth, maxDepth, root, 0) ? root : null;
        if (maxDepth == 0) {
            return currentFile == null ? Collections.emptyList() : Collections.singletonList(currentFile);
        }
        ArrayList<File> res = new ArrayList<File>();
        Object[] children = root.listFiles();
        if (children == null) {
            throw new IllegalStateException("cannot list " + root);
        }
        if (sort) {
            Arrays.sort(children);
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (maxDepth > 1 && ((File)child).isDirectory()) {
                res.addAll(FileUtils.list((File)child, minDepth - 1, maxDepth - 1, ff, sort));
            } else if (FileUtils.accept(ff, minDepth, maxDepth, (File)child, 1)) {
                res.add((File)child);
            }
            ++n2;
        }
        if (currentFile != null) {
            res.add(currentFile);
        }
        return res;
    }

    private static final boolean accept(FileFilter ff, int minDepth, int maxDepth, File f, int depth) {
        return minDepth <= depth && depth <= maxDepth && (ff == null || ff.accept(f));
    }

    public static final String relative(File fromDir, File to) throws IOException {
        if (fromDir.exists() && !fromDir.isDirectory()) {
            throw new IllegalArgumentException(fromDir + " is not a directory");
        }
        File fromF = fromDir.getCanonicalFile();
        File toF = to.getCanonicalFile();
        List<File> toPath = FileUtils.getAncestors(toF);
        List<File> fromPath = FileUtils.getAncestors(fromF);
        if (!toPath.get(0).equals(fromPath.get(0))) {
            return toF.getPath();
        }
        int commonIndex = Math.min(toPath.size(), fromPath.size()) - 1;
        boolean found = false;
        while (commonIndex >= 0 && !found) {
            found = fromPath.get(commonIndex).equals(toPath.get(commonIndex));
            if (found) continue;
            --commonIndex;
        }
        ArrayList<String> complete = new ArrayList<String>(Collections.nCopies(fromPath.size() - 1 - commonIndex, ".."));
        if (complete.isEmpty()) {
            complete.add(".");
        }
        for (File f : toPath.subList(commonIndex + 1, toPath.size())) {
            complete.add(f.getName());
        }
        return CollectionUtils.join(complete, File.separator);
    }

    public static final List<File> getAncestors(File f) {
        ArrayList<File> path = new ArrayList<File>();
        File currentF = f;
        while (currentF != null) {
            path.add(0, currentF);
            currentF = currentF.getParentFile();
        }
        return path;
    }

    public static final File[] mvOut(File parent, String name, String suffix) {
        File renamed;
        File fDest = new File(parent, String.valueOf(name) + suffix);
        if (fDest.exists()) {
            int i = 0;
            File free = fDest;
            while (free.exists()) {
                free = new File(parent, String.valueOf(name) + "_" + i + suffix);
                ++i;
            }
            assert (!fDest.equals(free));
            if (!fDest.renameTo(free)) {
                throw new IllegalStateException("Couldn't rename " + fDest + " to " + free);
            }
            renamed = free;
        } else {
            renamed = null;
        }
        assert (!fDest.exists());
        return new File[]{fDest, renamed};
    }

    public static String mv(File f, File dest) {
        File canonDest;
        File canonF;
        try {
            canonF = f.getCanonicalFile();
            canonDest = dest.getCanonicalFile();
        }
        catch (IOException e) {
            return ExceptionUtils.getStackTrace(e);
        }
        if (canonF.equals(canonDest)) {
            return null;
        }
        if (canonDest.isDirectory()) {
            canonDest = new File(canonDest, canonF.getName());
        }
        if (canonDest.exists()) {
            return canonDest + " exists";
        }
        if (!canonDest.getParentFile().exists()) {
            return "parent of " + canonDest + " does not exist";
        }
        File destF = canonDest;
        if (!canonF.renameTo(destF)) {
            try {
                FileUtils.copyDirectory(canonF, destF);
                if (destF.exists()) {
                    FileUtils.rmR(canonF);
                }
            }
            catch (IOException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }
        return null;
    }

    public static void copyFile(File in, File out) throws IOException {
        FileUtils.copyFile(in, out, CHANNEL_MAX_COUNT);
    }

    public static void copyFile(File in, File out, long maxCount) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        if (maxCount == 0L) {
            maxCount = sourceChannel.size();
        }
        try {
            long size = sourceChannel.size();
            long position = 0L;
            while (position < size) {
                position += sourceChannel.transferTo(position, maxCount, destinationChannel);
            }
        }
        finally {
            sourceChannel.close();
            destinationChannel.close();
        }
    }

    public static void copyFile(File in, File out, boolean useTime) throws IOException {
        if (!useTime || in.lastModified() != out.lastModified()) {
            FileUtils.copyFile(in, out);
            if (useTime) {
                out.setLastModified(in.lastModified());
            }
        }
    }

    public static void copyDirectory(File in, File out) throws IOException {
        FileUtils.copyDirectory(in, out, Collections.<String>emptySet());
    }

    public static void copyDirectory(File in, File out, Set<String> toIgnore) throws IOException {
        FileUtils.copyDirectory(in, out, toIgnore, false);
    }

    public static void copyDirectory(File in, File out, Set<String> toIgnore, boolean useTime) throws IOException {
        if (toIgnore.contains(in.getName())) {
            return;
        }
        if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdir();
            }
            String[] children = in.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.copyDirectory(new File(in, children[i]), new File(out, children[i]), toIgnore, useTime);
                ++i;
            }
        } else if (!in.getName().equals("Thumbs.db")) {
            FileUtils.copyFile(in, out, useTime);
        }
    }

    public static boolean rmR(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtils.rmR(children[i]);
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static final File mkdir_p(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("cannot create directory " + dir);
        }
        return dir;
    }

    public static BufferedWriter createXMLWriter(File f) throws IOException {
        FileOutputStream outs = new FileOutputStream(f);
        try {
            return StreamUtils.createXMLWriter(outs);
        }
        catch (RuntimeException e) {
            outs.close();
            throw e;
        }
        catch (IOException e) {
            outs.close();
            throw e;
        }
    }

    private static final File getShortCutFile() throws IOException {
        return FileUtils.getFile(FileUtils.class.getResource("shortcut.vbs"));
    }

    public static final File getFile(URL url) throws IOException {
        File shortcutFile;
        File urlFile = null;
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                urlFile = new File(url.toURI());
            }
            catch (Exception e) {
                Log.get().log(Level.FINER, "couldn't convert to file " + url, e);
            }
        }
        if (urlFile != null) {
            return urlFile;
        }
        File currentFile = files.get(url);
        if (currentFile == null || !currentFile.exists()) {
            shortcutFile = File.createTempFile("windowsIsLame", ".vbs");
            shortcutFile.deleteOnExit();
            files.put(url, shortcutFile);
            InputStream stream = url.openStream();
            FileOutputStream out = new FileOutputStream(shortcutFile);
            try {
                StreamUtils.copy(stream, out);
            }
            finally {
                out.close();
                stream.close();
            }
        } else {
            shortcutFile = currentFile;
        }
        return shortcutFile;
    }

    public static final File ln(File target, File link) throws IOException {
        File res;
        Process ps;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            ps = Runtime.getRuntime().exec(new String[]{"cscript", FileUtils.getShortCutFile().getAbsolutePath(), link.getAbsolutePath(), target.getCanonicalPath()});
            res = new File(link.getParentFile(), String.valueOf(link.getName()) + ".LNK");
        } else {
            String rel = FileUtils.relative(link.getAbsoluteFile().getParentFile(), target);
            String[] cmdarray = new String[]{"ln", "-sfn", rel, link.getAbsolutePath()};
            ps = Runtime.getRuntime().exec(cmdarray);
            res = link;
        }
        try {
            int exitValue = ps.waitFor();
            if (exitValue == 0) {
                return res;
            }
            throw new IOException("Abnormal exit value: " + exitValue);
        }
        catch (InterruptedException e) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted", e);
        }
    }
}

