/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

abstract class SystemQueryExecutor {
    private final ITransformer<Tuple2<String, String>, SQLTable> tableFinder;

    public SystemQueryExecutor(ITransformer<Tuple2<String, String>, SQLTable> tableFinder) {
        this.tableFinder = tableFinder;
    }

    protected abstract Object getQuery(SQLBase var1, TablesMap var2);

    protected abstract void apply(SQLTable var1, Map var2);

    public final void apply(SQLBase b, TablesMap tables) throws QueryExn {
        Object sel = this.getQuery(b, tables);
        for (Map m : this.exec(b, sel)) {
            SQLTable newTable = this.getTable(m);
            if (newTable == null) continue;
            this.apply(newTable, m);
        }
    }

    private final List<Map> exec(SQLBase b, Object sel) {
        if (sel instanceof Throwable) {
            throw new QueryExn((Throwable)sel);
        }
        if (sel instanceof List) {
            return (List)sel;
        }
        if (sel != null) {
            return (List)b.getDataSource().execute(sel.toString(), new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        }
        return Collections.emptyList();
    }

    private final SQLTable getTable(Map m) {
        return this.tableFinder.transformChecked(this.createTuple(m));
    }

    private Tuple2<String, String> createTuple(Map m) {
        return Tuple2.create((String)m.get("TABLE_SCHEMA"), (String)m.get("TABLE_NAME"));
    }

    public class QueryExn
    extends RuntimeException {
        public QueryExn(Throwable cause) {
            super(cause);
        }
    }
}

