/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.LoadingListener;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IClosure;

public final class DBSystemRoot
extends DBStructureItemDB {
    private final Object treeMutex = new String("Tree mutex");
    private DatabaseGraph graph = null;
    private final Object graphMutex = new String("Graph mutex");
    private Set<String> rootsToMap;
    private boolean useCache;
    private final PropertyChangeSupport supp;
    private SQLDataSource ds;
    private List<String> schemaPath;
    private boolean incoherentPath;
    private final PropertyChangeListener coherenceListener;
    private final LoadingListener.LoadingChangeSupport loadingListenersSupp;

    DBSystemRoot(DBStructureItemJDBC delegate) {
        super(delegate);
        this.mapNoRoots();
        this.useCache = Boolean.getBoolean("org.openconcerto.sql.structure.useXML");
        this.ds = null;
        this.schemaPath = Collections.emptyList();
        this.incoherentPath = false;
        this.supp = new PropertyChangeSupport(this);
        this.coherenceListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DBSystemRoot.this.rootsChanged(evt);
            }
        };
        this.loadingListenersSupp = new LoadingListener.LoadingChangeSupport(this);
        this.getServer().init(this);
    }

    private synchronized void rootsChanged(PropertyChangeEvent evt) {
        if (this.isIncoherentPath()) {
            this.setRootPathFromDS();
        } else {
            Collection newVal = (Collection)evt.getNewValue();
            List<String> rootPath = this.getRootPath();
            Collection<String> inexistant = CollectionUtils.substract(rootPath, newVal);
            if (inexistant.size() > 0) {
                ArrayList<String> copy = new ArrayList<String>(rootPath);
                copy.removeAll(inexistant);
                if (copy.size() > 0) {
                    this.setRootPathWithPrivate(copy);
                } else {
                    this.unsetRootPath();
                }
            }
        }
    }

    public final Object getTreeMutex() {
        return this.treeMutex;
    }

    public final DBRoot getRoot(String name) {
        return (DBRoot)this.getCheckedChild(name);
    }

    @Override
    public Map<String, DBRoot> getChildrenMap() {
        return super.getChildrenMap();
    }

    public final void mapAllRoots() {
        this.setRootsToMap(null);
    }

    public final void mapNoRoots() {
        this.setRootsToMap(Collections.<String>emptySet(), false, true);
    }

    public final void setRootToMap(String rootName) {
        this.setRootsToMap(Collections.singleton(rootName), false, true);
    }

    public final void setRootsToMap(Collection<String> rootsNames) {
        this.setRootsToMap(rootsNames, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> getRootsToMap() {
        DBSystemRoot dBSystemRoot = this;
        synchronized (dBSystemRoot) {
            return this.rootsToMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setRootsToMap(Collection<String> rootsNames, boolean copy, boolean immutable) {
        Set<String> s;
        if (rootsNames == null) {
            s = null;
        } else {
            boolean needsCopy = copy || !(rootsNames instanceof Set);
            Set<String> set = s = needsCopy ? new HashSet<String>(rootsNames) : (Set)rootsNames;
            if (needsCopy || !immutable) {
                s = Collections.unmodifiableSet(s);
            }
        }
        DBSystemRoot dBSystemRoot = this;
        synchronized (dBSystemRoot) {
            this.rootsToMap = s;
        }
    }

    public final synchronized boolean useCache() {
        return this.useCache;
    }

    public final SQLTable findTable(String name) {
        return this.findTable(name, false);
    }

    public final SQLTable findTable(String name, boolean mustExist) {
        Map<String, DBRoot> children = this.getChildrenMap();
        List<String> path = this.getRootPath();
        for (String root : path) {
            SQLTable res;
            DBRoot child = children.get(root);
            SQLTable sQLTable = res = child == null ? null : child.getTable(name);
            if (res == null) continue;
            return res;
        }
        if (mustExist) {
            throw new DBStructureItemNotFound("table " + name + " not found in " + path);
        }
        return null;
    }

    final boolean createNode(DBStructureItemJDBC parent, String childName) {
        if (!this.isSystemRoot(parent)) {
            return true;
        }
        HashSet<String> s = new HashSet<String>();
        s.add(childName);
        this.filterNodes(parent, s);
        return !s.isEmpty();
    }

    public final boolean shouldMap(String childName) {
        Set<String> rootsToMap = this.getRootsToMap();
        return rootsToMap == null || rootsToMap.contains(childName);
    }

    private boolean isSystemRoot(DBStructureItemJDBC parent) {
        return parent.getDBSystemRoot() == parent.getRawAlterEgo();
    }

    final void filterNodes(DBStructureItemJDBC parent, Set<String> childrenNames) {
        if (this.isSystemRoot(parent)) {
            parent.getServer().getSQLSystem().removeRootsToIgnore(childrenNames);
            Iterator<String> iter = childrenNames.iterator();
            while (iter.hasNext()) {
                String childName = iter.next();
                if (this.shouldMap(childName)) continue;
                iter.remove();
            }
        }
    }

    void descendantsChanged(DBStructureItemJDBC parent, Set<String> childrenRefreshed, boolean readCache) {
        this.descendantsChanged(TablesMap.createByRootFromChildren(parent, childrenRefreshed), readCache, true);
    }

    void descendantsChanged(TablesMap tablesRefreshed, boolean readCache, boolean tableListChange) {
        assert (Thread.holdsLock(this.getTreeMutex())) : "By definition descendants must be changed with the tree lock";
        try {
            this.getGraph().refresh(tablesRefreshed, readCache);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't refresh the graph");
        }
        if (tableListChange) {
            this.getDataSource().setTables(this.getDescs(SQLTable.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseGraph getGraph() {
        Object object = this.graphMutex;
        synchronized (object) {
            return this.graph;
        }
    }

    public final synchronized SQLDataSource getDataSource() {
        if (this.ds == null) {
            throw new IllegalStateException("setDS() was not called");
        }
        return this.ds;
    }

    public final synchronized boolean hasDataSource() {
        return this.ds != null;
    }

    @Override
    protected synchronized void onDrop() {
        this.rmChildrenListener(this.coherenceListener);
        if (this.ds != null) {
            try {
                this.ds.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        super.onDrop();
    }

    public void refetch() throws SQLException {
        this.refetch(null);
    }

    public void refetch(Set<String> childrenNames) throws SQLException {
        this.refresh(childrenNames, false);
    }

    public final TablesMap refresh(Set<String> childrenNames, boolean readCache) throws SQLException {
        return this.refresh(TablesMap.createFromKeys(childrenNames), readCache);
    }

    public final TablesMap refresh(TablesMap tables, boolean readCache) throws SQLException {
        if (this.getJDBC() instanceof SQLBase) {
            return ((SQLBase)this.getJDBC()).refresh(tables, readCache);
        }
        if (this.getJDBC() instanceof SQLServer) {
            HashMap<String, TablesMap> toRefresh;
            if (tables == null) {
                toRefresh = null;
            } else {
                int size = tables.size();
                if (size == 0) {
                    return tables;
                }
                toRefresh = new HashMap<String, TablesMap>(size);
                for (Map.Entry e : tables.entrySet()) {
                    toRefresh.put((String)e.getKey(), TablesMap.createFromTables(null, (Collection)e.getValue()));
                }
            }
            Map<String, TablesMap> refreshed = ((SQLServer)this.getJDBC()).refresh(toRefresh, readCache);
            TablesMap res = new TablesMap(refreshed.size());
            for (Map.Entry<String, TablesMap> e : refreshed.entrySet()) {
                assert (e.getValue().keySet().equals(Collections.singleton(null)));
                res.addAll(e.getKey(), (Collection)e.getValue().get(null));
            }
            return res;
        }
        throw new IllegalStateException();
    }

    public final void addLoadingListener(LoadingListener l) {
        this.loadingListenersSupp.addLoadingListener(l);
    }

    final void fireLoading(LoadingListener.LoadingEvent evt) {
        this.loadingListenersSupp.fireLoading(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void setDS(String login, String pass, IClosure<SQLDataSource> dsInit) {
        if (this.ds != null) {
            throw new IllegalStateException("already set: " + this.ds);
        }
        this.checkDropped();
        String baseName = this.getLevel() == HierarchyLevel.SQLBASE ? this.getName() : "";
        this.ds = new SQLDataSource(this.getServer(), baseName, login, pass);
        if (dsInit != null) {
            dsInit.executeChecked(this.ds);
        }
        Object object = this.graphMutex;
        synchronized (object) {
            this.graph = new DatabaseGraph(this);
        }
        this.addChildrenListener(this.coherenceListener);
        this.setRootPathFromDS();
    }

    private synchronized void setRootPathFromDS() {
        String dsSchema = this.ds.getSchema();
        Set<String> childrenNames = this.getChildrenNames();
        if (dsSchema != null && childrenNames.contains(dsSchema)) {
            this.setDefaultRoot(dsSchema);
        } else if (childrenNames.size() == 1) {
            this.setDefaultRoot(childrenNames.iterator().next());
        } else if (this.getServer().getSQLSystem().isNoDefaultSchemaSupported()) {
            this.clearRootPath();
        } else {
            this.schemaPath = Collections.emptyList();
            this.incoherentPath = true;
            Log.get().warning("db default schema is " + dsSchema + " and the schemas of " + this + " are empty ; the first created schema will become the default one");
        }
    }

    public final synchronized boolean isIncoherentPath() {
        return this.incoherentPath;
    }

    public final void setDefaultRoot(String schemaName) {
        this.setRootPathWithImmutable(Collections.singletonList(schemaName));
    }

    public final void appendToRootPath(String schemaName) {
        this.appendToRootPath(Collections.singletonList(schemaName));
    }

    public final synchronized void appendToRootPath(List<String> schemasNames) {
        ArrayList<String> newPath = new ArrayList<String>(this.getRootPath());
        newPath.addAll(schemasNames);
        this.setRootPathWithPrivate(newPath);
    }

    public final void clearRootPath() {
        this.setRootPathWithImmutable(Collections.<String>emptyList());
    }

    public final synchronized void unsetRootPath() {
        this.getDataSource().unsetInitialSchema();
        this.setRootPathFromDS();
    }

    private final void setRootPathWithPrivate(List<String> schemaNames) {
        this.setRootPathWithImmutable(Collections.unmodifiableList(schemaNames));
    }

    private final synchronized void setRootPathWithImmutable(List<String> schemaNames) {
        if (!this.getChildrenNames().containsAll(schemaNames)) {
            throw new IllegalArgumentException(schemaNames + " are not all in " + this + ": " + this.getChildrenNames());
        }
        this.schemaPath = schemaNames;
        String dsSchema = schemaNames.size() > 0 ? schemaNames.get(0) : null;
        this.getDataSource().setInitialSchema(dsSchema);
        this.incoherentPath = false;
    }

    public final synchronized List<String> getRootPath() {
        return this.schemaPath;
    }

    public final DBRoot getDefaultRoot() {
        List<String> path = this.getRootPath();
        if (path.size() > 0) {
            return this.getRoot(path.get(0));
        }
        return null;
    }
}

