/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public final class SQLElementDirectory {
    private final Map<SQLTable, SQLElement> elements = new HashMap<SQLTable, SQLElement>();
    private final CollectionMap<String, SQLTable> tableNames = new CollectionMap(HashSet.class);
    private final CollectionMap<String, SQLTable> byCode = new CollectionMap(HashSet.class);
    private final CollectionMap<Class<? extends SQLElement>, SQLTable> byClass = new CollectionMap(HashSet.class);
    private final List<DirectoryListener> listeners = new ArrayList<DirectoryListener>();

    private static <K> SQLTable getSoleTable(CollectionMap<K, SQLTable> m, K key) throws IllegalArgumentException {
        Collection<SQLTable> res = m.getNonNull(key);
        if (res.size() > 1) {
            throw new IllegalArgumentException(key + " is not unique: " + CollectionUtils.join(res, ",", new ITransformer<SQLTable, SQLName>(){

                @Override
                public SQLName transformChecked(SQLTable input) {
                    return input.getSQLName();
                }
            }));
        }
        return CollectionUtils.getSole(res);
    }

    public final synchronized void putAll(SQLElementDirectory o) {
        for (SQLElement elem : o.getElements()) {
            if (this.contains(elem.getTable())) continue;
            this.addSQLElement(elem);
        }
    }

    public final void addSQLElement(Class<? extends SQLElement> element) {
        try {
            this.addSQLElement(element.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DBStructureItemNotFound) {
                Log.get().config("ignore inexistent tables: " + e.getCause().getLocalizedMessage());
                return;
            }
            throw new IllegalArgumentException("ctor failed", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("no-arg ctor failed", e);
        }
    }

    public final synchronized void addSQLElement(SQLElement elem) {
        this.elements.put(elem.getTable(), elem);
        this.tableNames.put((Object)elem.getTable().getName(), (Object)elem.getTable());
        this.byCode.put((Object)elem.getCode(), (Object)elem.getTable());
        this.byClass.put(elem.getClass(), (Object)elem.getTable());
        for (DirectoryListener dl : this.listeners) {
            dl.elementAdded(elem);
        }
        elem.setDirectory(this);
    }

    public final synchronized boolean contains(SQLTable t) {
        return this.elements.containsKey(t);
    }

    public final synchronized SQLElement getElement(SQLTable t) {
        return this.elements.get(t);
    }

    public final synchronized SQLElement getElement(String tableName) {
        return this.getElement(SQLElementDirectory.getSoleTable(this.tableNames, tableName));
    }

    public final synchronized SQLElement getElementForCode(String code) {
        return this.getElement(SQLElementDirectory.getSoleTable(this.byCode, code));
    }

    public final synchronized Collection<SQLElement> getElements() {
        return this.getElementsMap().values();
    }

    public final Map<SQLTable, SQLElement> getElementsMap() {
        return Collections.unmodifiableMap(this.elements);
    }

    public final synchronized void addListener(DirectoryListener dl) {
        this.listeners.add(dl);
    }

    public final synchronized void removeListener(DirectoryListener dl) {
        this.listeners.remove(dl);
    }

    public static interface DirectoryListener {
        public void elementAdded(SQLElement var1);
    }
}

