/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;

public class ServerModuleManager {
    private static final String FWK_MODULE_TABLENAME = new String("FWK_MODULE_METADATA");
    private DBRoot root;
    private ArrayList<ModuleReference> installedModules;
    private ArrayList<ModuleReference> requiredModules;
    private Map<String, Set<String>> mapCreatedTables = new HashMap<String, Set<String>>();
    private Map<String, Set<SQLName>> mapCreatedItems = new HashMap<String, Set<SQLName>>();

    final synchronized DBRoot getRoot() {
        return this.root;
    }

    synchronized void setRoot(DBRoot root) throws SQLException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalAccessError("Cannot be called in EDT");
        }
        this.root = root;
        this.reload();
    }

    synchronized void reload() throws SQLException {
        SQLRowValues graph = new SQLRowValues(this.getModuleMetadataTable());
        graph.put("ID", null);
        graph.put("MODULE_NAME", null);
        graph.put("TABLE", null);
        graph.put("FIELD", null);
        graph.put("KEY", null);
        graph.put("MODULE_VERSION", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(graph);
        List<SQLRowValues> values = fetcher.fetch();
        HashSet<ModuleReference> installedSet = new HashSet<ModuleReference>();
        HashSet<ModuleReference> requiredSet = new HashSet<ModuleReference>();
        this.mapCreatedTables = new HashMap<String, Set<String>>();
        this.mapCreatedItems = new HashMap<String, Set<SQLName>>();
        for (SQLRowValues row : values) {
            Set<SQLName> items;
            String id = row.getString("MODULE_NAME");
            Long version = row.getLong("MODULE_VERSION");
            if (id == null || version == null) continue;
            String table = row.getString("TABLE");
            ModuleReference ref = new ModuleReference(id, new ModuleVersion(version));
            installedSet.add(ref);
            Set<String> tables = this.mapCreatedTables.get(id);
            if (tables == null) {
                tables = new HashSet<String>();
                this.mapCreatedTables.put(id, tables);
            }
            String field = row.getString("FIELD");
            if (table != null && (field == null || field.isEmpty())) {
                tables.add(table);
                requiredSet.add(ref);
            }
            if ((items = this.mapCreatedItems.get(id)) == null) {
                items = new HashSet<SQLName>();
                this.mapCreatedItems.put(id, items);
            }
            if (field == null) continue;
            items.add(new SQLName(table, field));
        }
        this.installedModules = new ArrayList(installedSet);
        this.requiredModules = new ArrayList(requiredSet);
    }

    synchronized Set<String> getCreatedTables(String id) {
        Set<String> set = this.mapCreatedTables.get(id);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    final synchronized List<ModuleReference> getRequiredModules() {
        return this.requiredModules;
    }

    final synchronized List<ModuleReference> getDBInstalledModules() throws SQLException {
        return this.installedModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLTable getModuleMetadataTable() throws SQLException {
        DBRoot r = this.getRoot();
        String string = FWK_MODULE_TABLENAME;
        synchronized (string) {
            if (!r.contains(FWK_MODULE_TABLENAME)) {
                SQLCreateTable createTable = new SQLCreateTable(r, FWK_MODULE_TABLENAME);
                createTable.setPlain(true);
                createTable.addColumn("ID", createTable.getSyntax().getPrimaryIDDefinition());
                createTable.addVarCharColumn("MODULE_NAME", 128);
                createTable.addColumn("TABLE", "varchar(128) NULL");
                createTable.addColumn("FIELD", "varchar(128) NULL");
                createTable.addColumn("KEY", "boolean NULL");
                createTable.addColumn("MODULE_VERSION", "bigint NOT NULL");
                createTable.addUniqueConstraint("uniqModule", Arrays.asList("MODULE_NAME", "TABLE", "FIELD"));
                r.createTable(createTable);
            }
        }
        return r.getTable(FWK_MODULE_TABLENAME);
    }
}

