/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Request;
import com.jcraft.jsch.RequestSftp;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.util.Hashtable;

public class ChannelSftp
extends ChannelSession {
    private boolean interactive = false;
    private int seq = 1;
    private int[] ackid = new int[1];
    private Buffer buf;
    private Packet packet = new Packet(this.buf);
    private int client_version = 3;
    private int server_version = 3;
    private String version = String.valueOf(this.client_version);
    private Hashtable extensions = null;
    private InputStream io_in = null;
    private static final String file_separator = File.separator;
    private static final char file_separatorc = File.separatorChar;
    private static boolean fs_is_bs = (byte)File.separatorChar == 92;
    private String lcwd;
    private String fEncoding = "UTF-8";
    private boolean fEncoding_is_utf8 = true;

    void init() {
    }

    public void start() throws JSchException {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.io.setOutputStream(pipedOutputStream);
            Channel.MyPipedInputStream myPipedInputStream = new Channel.MyPipedInputStream(pipedOutputStream, 32768);
            this.io.setInputStream(myPipedInputStream);
            this.io_in = this.io.in;
            if (this.io_in == null) {
                throw new JSchException("channel is down");
            }
            RequestSftp requestSftp = new RequestSftp();
            ((Request)requestSftp).request(this.getSession(), this);
            this.buf = new Buffer(this.rmpsize);
            this.packet = new Packet(this.buf);
            boolean bl = false;
            this.sendINIT();
            Header header = new Header();
            header = this.header(this.buf, header);
            int n = header.length;
            if (n > 262144) {
                throw new SftpException(4, "Received message is too long: " + n);
            }
            int n2 = header.type;
            this.server_version = header.rid;
            if (n > 0) {
                this.extensions = new Hashtable();
                this.fill(this.buf, n);
                byte[] byArray = null;
                byte[] byArray2 = null;
                while (n > 0) {
                    byArray = this.buf.getString();
                    n -= 4 + byArray.length;
                    byArray2 = this.buf.getString();
                    n -= 4 + byArray2.length;
                    this.extensions.put(Util.byte2str(byArray), Util.byte2str(byArray2));
                }
            }
            this.lcwd = new File(".").getCanonicalPath();
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    private void sendINIT() throws Exception {
        this.packet.reset();
        this.putHEAD((byte)1, 5);
        this.buf.putInt(3);
        this.getSession().write(this.packet, this, 9);
    }

    private void putHEAD(byte by, int n) throws Exception {
        this.buf.putByte((byte)94);
        this.buf.putInt(this.recipient);
        this.buf.putInt(n + 4);
        this.buf.putInt(n);
        this.buf.putByte(by);
    }

    public void disconnect() {
        super.disconnect();
    }

    private void fill(Buffer buffer, int n) throws IOException {
        buffer.reset();
        this.fill(buffer.buffer, 0, n);
        buffer.skip(n);
    }

    private int fill(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = n;
        while (n2 > 0) {
            n3 = this.io_in.read(byArray, n, n2);
            if (n3 <= 0) {
                throw new IOException("inputstream is closed");
            }
            n += n3;
            n2 -= n3;
        }
        return n - n4;
    }

    private Header header(Buffer buffer, Header header) throws IOException {
        buffer.rewind();
        int n = this.fill(buffer.buffer, 0, 9);
        header.length = buffer.getInt() - 5;
        header.type = buffer.getByte() & 0xFF;
        header.rid = buffer.getInt();
        return header;
    }

    class Header {
        int length;
        int type;
        int rid;

        Header() {
        }
    }
}

