/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class I18nUtils {
    private static final SameLanguageControl INSTANCE = new SameLanguageControl();
    public static final String RSRC_BASENAME = String.valueOf(I18nUtils.class.getPackage().getName()) + ".Resources";

    public static final String getBooleanKey(boolean b) {
        return b ? "true_key" : "false_key";
    }

    public static final String getYesNoKey(boolean b) {
        return b ? "yes_key" : "no_key";
    }

    public static class SameLanguageControl
    extends ResourceBundle.Control {
        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> res = super.getCandidateLocales(baseName, locale);
            assert (res.get(res.size() - 1) == Locale.ROOT);
            res = res.subList(0, res.size() - 1);
            assert (res.isEmpty() || res.get(res.size() - 1).getLanguage().equals(locale.getLanguage()));
            return res;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }
}

