/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObject;

public class EmptyObjectHelper
implements PropertyChangeListener {
    private final EmptyObject target;
    private final Predicate testEmptiness;
    private final List<EmptyListener> listeners = new ArrayList<EmptyListener>(3);
    private boolean emptyState;

    public EmptyObjectHelper(EmptyObject target, Predicate testEmptiness) {
        this.target = target;
        this.testEmptiness = testEmptiness;
        this.emptyState = this.testEmptiness.evaluate(this.target.getUncheckedValue());
        this.target.addValueListener(this);
    }

    public boolean isEmpty() {
        return this.emptyState;
    }

    private void fireInit() {
        for (EmptyListener l : this.listeners) {
            l.emptyChange(this.target, this.isEmpty());
        }
    }

    public void addListener(EmptyListener l) {
        this.listeners.add(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean newState = this.testEmptiness.evaluate(this.target.getUncheckedValue());
        if (newState != this.emptyState) {
            this.emptyState = newState;
            this.fireInit();
        }
    }
}

