/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.task.ModelStateListener;
import org.openconcerto.task.TodoListElement;
import org.openconcerto.task.UserTaskRight;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.cc.IFactory;

public class TodoListModel
extends DefaultTableModel {
    public int mode = 2;
    private long currentDelay = 30L;
    private boolean stop = false;
    private final List<Integer> listIdListener = new Vector<Integer>();
    private JTable table = null;
    private List<ModelStateListener> stateListenerList = new Vector<ModelStateListener>(1);
    private transient User currentUser;
    protected List<UserTaskRight> rights;
    private boolean historyVisible = false;
    private static final int societeID = ((ComptaBasePropsConfiguration)Configuration.getInstance()).getSocieteID();
    private static final DBSystemRoot base = Configuration.getInstance().getSystemRoot();
    private static final SQLTable tableTache = base.getRoot("Common").getTable("TACHE_COMMON");
    private static final Where where2 = new Where((FieldRef)tableTache.getField("ID_SOCIETE_COMMON"), "=", tableTache.getUndefinedID()).or(new Where((FieldRef)tableTache.getField("ID_SOCIETE_COMMON"), "=", societeID));

    TodoListModel(User currentUser) {
        this.currentUser = currentUser;
        this.launchUpdaterThread();
        this.mode = 2;
    }

    private void launchUpdaterThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!TodoListModel.this.stop) {
                    try {
                        Thread.sleep(TodoListModel.this.currentDelay * 1000L);
                        if (TodoListModel.this.stop) continue;
                        TodoListModel.this.synchronousFill();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("TodoListModel UpdaterThread");
        thread.start();
    }

    public void asynchronousFill() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TodoListModel.this.synchronousFill();
            }
        });
        thread.setName("TodoListModel asynchronousFill");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void synchronousFill() {
        int oldSize;
        if (this.table == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TodoListModel.this.fireModelStateChanged(1);
            }
        });
        LinkedHashMap<Integer, TodoListElement> newDataVector = new LinkedHashMap<Integer, TodoListElement>();
        try {
            this.fillFromDatabase(newDataVector);
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TodoListModel.this.fireModelStateChanged(2);
                }
            });
            return;
        }
        final Vector<Integer> rowsModified = new Vector<Integer>();
        Vector<TodoListElement> rowsDeleted = new Vector<TodoListElement>();
        final int newSize = newDataVector.size();
        Vector vector = this.dataVector;
        synchronized (vector) {
            oldSize = this.dataVector.size();
            int i = 0;
            while (i < oldSize) {
                TodoListElement elt = (TodoListElement)this.dataVector.get(i);
                TodoListElement eltN = (TodoListElement)newDataVector.remove(elt.getRowValues().getID());
                if (eltN == null) {
                    rowsDeleted.add(elt);
                } else if (!eltN.equals(elt)) {
                    rowsModified.add(i);
                    elt.reloadValues(eltN.getRowValues());
                }
                ++i;
            }
            for (TodoListElement elt : rowsDeleted) {
                int index = this.dataVector.indexOf(elt);
                if (index < 0) continue;
                this.removeRow(index);
            }
            for (Integer i2 : newDataVector.keySet()) {
                this.dataVector.add(newDataVector.get(i2));
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (rowsModified.size() == newSize && rowsModified.size() > 0) {
                    TodoListModel.this.fireTableDataChanged();
                    TodoListModel.this.fireModelStateChanged(3);
                } else if (newSize != oldSize) {
                    TodoListModel.this.fireTableDataChanged();
                    TodoListModel.this.fireModelStateChanged(3);
                } else {
                    int i = 0;
                    while (i < rowsModified.size()) {
                        Integer indexModified = (Integer)rowsModified.get(i);
                        TodoListModel.this.fireTableRowsUpdated(indexModified, indexModified);
                        ++i;
                    }
                    if (rowsModified.size() > 0) {
                        TodoListModel.this.fireModelStateChanged(3);
                    }
                }
                TodoListModel.this.fireModelStateChanged(0);
            }
        });
    }

    private final Where getAuthorizedTaskTypes(int userID, final SQLTable tableTache) {
        final SQLField typeF = tableTache.getFieldRaw("TYPE");
        if (typeF == null) {
            return null;
        }
        Set<String> types = UserRightsManager.getInstance().getObjects(userID, "TASK", new IFactory<Set<String>>(){

            @Override
            public Set<String> createChecked() {
                SQLSelect sel = new SQLSelect(tableTache.getBase());
                sel.addSelect(typeF);
                sel.addGroupBy(typeF);
                return new HashSet<String>(tableTache.getDBSystemRoot().getDataSource().executeCol(sel.asString()));
            }
        });
        return types == null ? Where.TRUE : new Where(typeF, types);
    }

    private synchronized void fillFromDatabase(Map<Integer, TodoListElement> m) {
        long time1 = System.currentTimeMillis();
        SQLSelect select = new SQLSelect(tableTache.getBase());
        select.addSelectStar(tableTache);
        Where where = new Where(tableTache.getField("ID_USER_COMMON_TO"), this.listIdListener);
        int userID = UserManager.getInstance().getCurrentUser().getId();
        where = where.or(new Where((FieldRef)tableTache.getField("ID_USER_COMMON_ASSIGN_BY"), "=", userID));
        where = where.or(this.getAuthorizedTaskTypes(userID, tableTache));
        if (!this.isHistoryVisible()) {
            Where w3 = new Where((FieldRef)tableTache.getField("FAIT"), "=", (Object)Boolean.FALSE);
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            Where w4 = new Where((FieldRef)tableTache.getField("DATE_FAIT"), "<>", (Object)null);
            w4 = w4.and(new Where((FieldRef)tableTache.getField("DATE_FAIT"), ">", (Object)cal.getTime()));
            w3 = w3.or(w4);
            where = where.and(w3);
        }
        select.setWhere(where.and(where2));
        select.addFieldOrder(tableTache.getField("ID_USER_COMMON_TO"));
        select.addFieldOrder(tableTache.getField("DATE_EXP"));
        this.rights = UserTaskRight.getUserTaskRight(this.getCurrentUser());
        IResultSetHandler rsh = new IResultSetHandler(SQLRowListRSH.createFromSelect(select), false);
        List l = (List)base.getDataSource().execute(select.asString(), rsh);
        for (SQLRow row : l) {
            TodoListElement t = new TodoListElement(row.asRowValues());
            boolean add = false;
            String type = row.getString("TYPE");
            if (type != null && type.trim().length() > 0) {
                add = true;
            } else if (row.getInt("ID_USER_COMMON_CREATE") == userID || row.getInt("ID_USER_COMMON_TO") == userID) {
                add = true;
            } else {
                int i = 0;
                while (i < this.rights.size()) {
                    UserTaskRight element = this.rights.get(i);
                    if (element.getIdToUser() == row.getInt("ID_USER_COMMON_TO") && element.canRead()) {
                        add = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!add) continue;
            m.put(row.getID(), t);
        }
        long time2 = System.currentTimeMillis();
        long t = time2 - time1;
        long delay = 2L + t / 1000L;
        if (delay > 6L) {
            delay = 6L;
        }
        if (delay < 30L) {
            delay = 30L;
        }
        this.currentDelay = delay;
    }

    @Override
    public int getColumnCount() {
        if (this.mode == 1) {
            return 7;
        }
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Vector vector = this.dataVector;
        synchronized (vector) {
            TodoListElement task;
            if (columnIndex == 1) {
                return true;
            }
            if (this.mode == 1 && columnIndex == 3) {
                return false;
            }
            if (this.dataVector.size() <= rowIndex) {
                System.err.println("pb! taille:" + this.dataVector.size() + " i:" + rowIndex);
                rowIndex = 0;
            }
            if ((task = (TodoListElement)this.dataVector.get(rowIndex)) == null) {
                return false;
            }
            if (columnIndex == 0) {
                int i = 0;
                while (i < this.rights.size()) {
                    UserTaskRight right = this.rights.get(i);
                    if (right.getIdToUser() == task.getUserId().intValue() && right.canValidate()) {
                        return true;
                    }
                    ++i;
                }
            } else {
                if (columnIndex == this.getColumnCount() - 1) {
                    return task.getCreatorId().equals(UserManager.getInstance().getCurrentUser().getId());
                }
                int i = 0;
                while (i < this.rights.size()) {
                    UserTaskRight right = this.rights.get(i);
                    if (right.getIdToUser() == task.getCreatorId().intValue() && right.canModify()) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Timestamp.class;
            }
            case 4: {
                if (this.mode != 1) {
                    return Integer.class;
                }
            }
            case 5: {
                return Timestamp.class;
            }
            case 6: {
                return Integer.class;
            }
        }
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Vector vector = this.dataVector;
        synchronized (vector) {
            if (this.dataVector.size() <= rowIndex) {
                System.err.println("pb! taille:" + this.dataVector.size() + " i:" + rowIndex);
                rowIndex = 0;
            }
            TodoListElement task = (TodoListElement)this.dataVector.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return task.isDone();
                }
                case 1: {
                    return task.getPriority();
                }
                case 2: {
                    return task.getName();
                }
                case 3: {
                    if (this.mode == 1) {
                        return task.getDate();
                    }
                    return task.getExpectedDate();
                }
                case 4: {
                    if (this.mode == 1) {
                        return task.getDoneDate();
                    }
                    return task.getUserId();
                }
                case 5: {
                    return task.getExpectedDate();
                }
                case 6: {
                    return task.getUserId();
                }
            }
            return "????????";
        }
    }

    public TodoListElement getTaskAtRow(int rowIndex) {
        return (TodoListElement)this.dataVector.get(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Vector vector = this.dataVector;
        synchronized (vector) {
            if (rowIndex >= this.getRowCount()) {
                return;
            }
            TodoListElement task = (TodoListElement)this.dataVector.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    task.setDone((Boolean)aValue);
                    break;
                }
                case 1: {
                    task.setPriority((Integer)aValue);
                    break;
                }
                case 2: {
                    task.setName((String)aValue);
                    break;
                }
                case 3: {
                    if (this.mode == 1) {
                        task.setDate((Timestamp)aValue);
                    }
                    task.setExpectedDate((Timestamp)aValue);
                    break;
                }
                case 4: {
                    if (this.mode == 1) {
                        task.setDoneDate((Timestamp)aValue);
                        break;
                    }
                    task.setUserId((Integer)aValue);
                    break;
                }
                case 5: {
                    task.setExpectedDate((Timestamp)aValue);
                    break;
                }
                case 6: {
                    task.setUserId((Integer)aValue);
                    break;
                }
            }
            task.commitChanges();
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "A faire...";
            }
            case 3: {
                if (this.mode == 1) {
                    return "cr\u00e9\u00e9 le";
                }
                return "\u00e0 faire pour le";
            }
            case 4: {
                if (this.mode == 1) {
                    return "fait le";
                }
                return "assign\u00e9e \u00e0";
            }
            case 5: {
                return "\u00e0 faire pour le";
            }
            case 6: {
                return "assign\u00e9e \u00e0";
            }
        }
        return "Oups!!!!!!!!!";
    }

    public void addNewTask() {
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                SQLRowValues rowV = new SQLRowValues(Configuration.getInstance().getBase().getTable("TACHE_COMMON"));
                Calendar cal = Calendar.getInstance();
                rowV.put("DATE_ENTREE", new Timestamp(cal.getTimeInMillis()));
                cal.add(11, 1);
                rowV.put("DATE_EXP", new Timestamp(cal.getTimeInMillis()));
                cal.set(1, 2000);
                cal.set(6, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(14, 0);
                rowV.put("DATE_FAIT", new Timestamp(cal.getTimeInMillis()));
                int currentUserId = UserManager.getInstance().getCurrentUser().getId();
                rowV.put("ID_USER_COMMON_ASSIGN_BY", currentUserId);
                rowV.put("ID_USER_COMMON_TO", currentUserId);
                try {
                    rowV.insert();
                }
                catch (SQLException e) {
                    TodoListModel.this.fireModelStateChanged(2);
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            public void done() {
                TodoListModel.this.synchronousFill();
                TodoListModel.this.fireTableRowsInserted(TodoListModel.this.getRowCount(), TodoListModel.this.getRowCount());
            }
        };
        worker.execute();
    }

    synchronized void setMode(int mode) {
        this.mode = mode;
        this.fireTableStructureChanged();
    }

    public synchronized int getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTaskAtIndex(int index) {
        Vector vector = this.dataVector;
        synchronized (vector) {
            TodoListElement t;
            block4: {
                t = (TodoListElement)this.dataVector.get(index);
                int currentUserId = UserManager.getInstance().getCurrentUser().getId();
                if (t.getCreatorId() == currentUserId) break block4;
                JOptionPane.showMessageDialog(this.table, "Vous n'\u00eates pas autoris\u00e9 \u00e0 effacer\n des t\u00e2ches dont vous n'\u00eates pas l'auteur!");
                return false;
            }
            t.archive();
        }
        this.removeRow(index);
        return true;
    }

    public void addIdListener(Integer id) {
        this.listIdListener.add(id);
        this.asynchronousFill();
    }

    public void addIdListenerSilently(Integer id) {
        this.listIdListener.add(id);
    }

    public void removeIdListener(Integer id) {
        this.listIdListener.remove(id);
        this.asynchronousFill();
    }

    public boolean listenToId(Integer id) {
        return this.listIdListener.contains(id);
    }

    public void setTable(JTable t) {
        this.table = t;
    }

    public void stopUpdate() {
        this.stop = true;
    }

    public void addModelStateListener(ModelStateListener l) {
        if (!this.stateListenerList.contains(l)) {
            this.stateListenerList.add(l);
        }
    }

    public void removeModelStateListener(ModelStateListener l) {
        if (this.stateListenerList.contains(l)) {
            this.stateListenerList.remove(l);
        }
    }

    private void fireModelStateChanged(int state) {
        int i = 0;
        while (i < this.stateListenerList.size()) {
            this.stateListenerList.get(i).stateChanged(state);
            ++i;
        }
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public synchronized boolean isHistoryVisible() {
        return this.historyVisible;
    }

    public synchronized void setHistoryVisible(boolean historyVisible) {
        this.historyVisible = historyVisible;
    }
}

