/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.task.TodoListElement;

public class TodoListElementEditorPanel
extends JPanel {
    private transient TodoListElement element;
    final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH:mm");

    TodoListElementEditorPanel(TodoListElement e) {
        this.element = e;
        System.out.println(e);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        JLabel l = new JLabel("R\u00e9sum\u00e9:");
        this.add((Component)l, c);
        ++c.gridx;
        c.weightx = 1.0;
        final JTextField f = new JTextField();
        f.setText(e.getName());
        this.add((Component)f, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        final JTextArea fComment = new JTextArea();
        fComment.setFont(f.getFont());
        fComment.setText(e.getComment());
        this.add((Component)fComment, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 0.0;
        this.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        JLabel label = new JLabel("A r\u00e9aliser pour le " + this.simpleDateFormat.format(e.getExpectedDate()) + " par " + UserManager.getInstance().getUser(e.getUserId()).getFullName());
        this.add((Component)label, c);
        JButton bOk = new JButton("Ok");
        bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TodoListElementEditorPanel.this.element.setName(f.getText());
                TodoListElementEditorPanel.this.element.setComment(fComment.getText());
                TodoListElementEditorPanel.this.element.commitChanges();
                SwingUtilities.getWindowAncestor(TodoListElementEditorPanel.this).dispose();
            }
        });
        JButton bAnnuler = new JButton("Annuler");
        bAnnuler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SwingUtilities.getWindowAncestor(TodoListElementEditorPanel.this).dispose();
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(bOk);
        p.add(bAnnuler);
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)p, c);
    }
}

