/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.LineListener;
import org.openconcerto.sql.view.list.ListAccess;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.search.ChangeListAll;
import org.openconcerto.sql.view.list.search.ChangeListOne;
import org.openconcerto.sql.view.list.search.SearchAll;
import org.openconcerto.sql.view.list.search.SearchOne;
import org.openconcerto.sql.view.list.search.SearchRunnable;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;

public final class SearchQueue
extends SleepingQueue {
    private final ITableModel model;
    SearchSpec search;
    private final List<ListSQLLine> fullList;
    private final ListAccess listAccess;
    private final LineListener lineListener;

    public static boolean isSearch(FutureTask<?> f) {
        return f instanceof IFutureTask && ((IFutureTask)f).getRunnable() instanceof SearchRunnable;
    }

    public SearchQueue(ListAccess la) {
        super(String.valueOf(SearchQueue.class.getName()) + " on " + la.getModel());
        this.listAccess = la;
        this.model = la.getModel();
        this.search = null;
        this.fullList = new ArrayList<ListSQLLine>();
        this.lineListener = new LineListener(){

            @Override
            public void lineChanged(int id, ListSQLLine l, Set<Integer> colIndex) {
                SearchQueue.this.changeFullList(id, l, colIndex);
            }
        };
        this.getModel().getLinesSource().addLineListener(this.lineListener);
    }

    @Override
    protected void dying() {
        super.dying();
        this.getModel().getLinesSource().rmLineListener(this.lineListener);
    }

    public CollectionMap<Path, ListSQLLine> getAffectedPaths(SQLTable t, int id) {
        return this.execGetAffected(t, id, new CollectionMap(), false);
    }

    private <K, V> CollectionMap<K, V> execGetAffected(final SQLTable t, final int id, final CollectionMap<K, V> res, final boolean byLine) {
        return (CollectionMap)this.execute(new Callable<CollectionMap<K, V>>(){

            @Override
            public CollectionMap<K, V> call() throws Exception {
                return SearchQueue.this.getAffected(t, id, res, byLine);
            }
        });
    }

    private <R> R execute(Callable<R> c) {
        try {
            return this.execute(new FutureTask<R>(c)).get();
        }
        catch (InterruptedException e) {
            throw new RTInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private <K, V> CollectionMap<K, V> getAffected(final SQLTable t, int id, CollectionMap<K, V> res, boolean byLine) {
        if (id < 0) {
            throw new IllegalArgumentException("invalid ID: " + id);
        }
        if (!this.fullList.isEmpty()) {
            SQLRowValues proto = this.getModel().getLinesSource().getParent().getMaxGraph();
            ArrayList pathsToT = new ArrayList();
            proto.walkGraph(pathsToT, new ITransformer<SQLRowValuesCluster.State<List<Path>>, List<Path>>(){

                @Override
                public List<Path> transformChecked(SQLRowValuesCluster.State<List<Path>> input) {
                    if (input.getCurrent().getTable() == t) {
                        input.getAcc().add(input.getPath());
                    }
                    return input.getAcc();
                }
            });
            for (Path p : pathsToT) {
                for (ListSQLLine line : this.fullList) {
                    SQLRowValues current = line.getRow().followPath(p);
                    if (current == null || current.getID() != id) continue;
                    if (byLine) {
                        res.put(line, p);
                        continue;
                    }
                    res.put(p, line);
                }
            }
        }
        return res;
    }

    private synchronized void changeFullList(int id, ListSQLLine modifiedLine, Collection<Integer> modifiedCols) {
        SearchOne oneSearchRunnable = new SearchOne(this, id, modifiedLine, modifiedCols);
        this.putTask(new ChangeListOne("changeFullList " + id + " newLine: " + modifiedLine, this, modifiedLine, id, oneSearchRunnable));
        this.putTask(oneSearchRunnable);
    }

    public synchronized void setFullList(List<ListSQLLine> l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.putTask(new ChangeListAll("setFullList", this, l));
        this.fullDataChange();
    }

    public synchronized void setSearch(final SearchSpec s) {
        this.putTask(new Runnable(){

            @Override
            public void run() {
                SearchQueue.this.search = s;
            }
        });
        this.fullDataChange();
    }

    private synchronized void fullDataChange() {
        this.clearCompute();
        this.putTask(new SearchAll(this));
    }

    private synchronized void putTask(Runnable r) {
        this.execute(new IFutureTask<Object>(r, null));
    }

    private synchronized void clearCompute() {
        this.cancel(new IPredicate<FutureTask<?>>(){

            @Override
            public boolean evaluateChecked(FutureTask<?> f) {
                return SearchQueue.isSearch(f);
            }
        });
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " for " + this.getModel();
    }

    final SearchSpec getSearch() {
        return this.search;
    }

    final List<ListSQLLine> getFullList() {
        return this.fullList;
    }

    final ListAccess getAccess() {
        return this.listAccess;
    }

    public final int getFullListSize() {
        return this.fullList.size();
    }

    public final ITableModel getModel() {
        return this.model;
    }
}

