/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.utils.CollectionUtils;

public class UserRightSQLElement
extends ConfSQLElement {
    public UserRightSQLElement() {
        super("USER_RIGHT", "un droit utilisateur", "droits utilisateurs");
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("ID_RIGHT", "OBJECT", "HAVE_RIGHT");
    }

    @Override
    protected List<String> getComboFields() {
        return this.getListFields();
    }

    @Override
    protected String getParentFFName() {
        return "ID_USER_COMMON";
    }

    @Override
    public Set<String> getReadOnlyFields() {
        return Collections.singleton("ID_USER_COMMON");
    }

    @Override
    public SQLComponent createComponent() {
        return new UserRightComp((SQLElement)this);
    }

    public static final class UserRightComp
    extends UISQLComponent {
        private int userID = -1;

        private UserRightComp(SQLElement element) {
            super(element, 2, 1);
        }

        @Override
        protected Set<String> createRequiredNames() {
            return CollectionUtils.createSet("ID_RIGHT", "HAVE_RIGHT");
        }

        @Override
        public void addViews() {
            SQLRequestComboBox user = new SQLRequestComboBox();
            this.addView(user, "ID_USER_COMMON", (Object)"0");
            user.getRequest().setUndefLabel("Par d\u00e9faut");
            ElementComboBox right = new ElementComboBox();
            right.setListIconVisible(false);
            this.addView(right, "ID_RIGHT");
            this.addView("HAVE_RIGHT");
            this.addView("OBJECT", "0");
        }

        @Override
        protected SQLRowValues createDefaults() {
            if (this.userID >= 0) {
                return new SQLRowValues(this.getTable()).put("ID_USER_COMMON", this.userID);
            }
            return null;
        }
    }
}

