/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.sqlobject.ITextWithCompletion;

public class ITextWithCompletionPopUp
extends JPopupMenu {
    JList list;
    private ListModel listModel;
    private int minWitdh = 150;
    private ITextWithCompletion text;

    ITextWithCompletionPopUp(ListModel listModel, ITextWithCompletion text) {
        this.text = text;
        this.list = new JList(listModel);
        this.listModel = listModel;
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ITextWithCompletionPopUp.this.validateSelection();
            }
        });
        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
        scroller.setFocusable(false);
        scroller.getVerticalScrollBar().setFocusable(false);
        scroller.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(true);
        this.add(scroller);
        this.setFocusable(false);
        this.list.addMouseMotionListener(new ListMouseMotionHandler());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int width = d.width;
        if (width > 500) {
            width = 500;
        }
        width = Math.max(width, this.minWitdh) + 2;
        int height = 2 + 17 * Math.min(this.listModel.getSize(), 10);
        Dimension newD = new Dimension(width, height);
        return newD;
    }

    public void setMinWith(int i) {
        this.minWitdh = i;
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.listModel.getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    public void selectNext() {
        int i = this.list.getSelectedIndex() + 1;
        if (i < this.listModel.getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectNextPage() {
        int i = Math.min(10 + Math.max(this.list.getSelectedIndex(), 0), this.listModel.getSize() - 1);
        if (i < this.listModel.getSize()) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
    }

    public void selectPrevious() {
        int i = this.list.getSelectedIndex() - 1;
        if (i >= 0) {
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        } else {
            this.setVisible(false);
        }
    }

    public void selectPreviousPage() {
        int i = Math.max(0, this.list.getSelectedIndex() - 10);
        this.list.setSelectedIndex(i);
        this.list.ensureIndexIsVisible(i);
    }

    public void validateSelection() {
        int sIndex = this.list.getSelectedIndex();
        if (sIndex >= 0) {
            IComboSelectionItem item = (IComboSelectionItem)this.listModel.getElementAt(sIndex);
            this.text.selectId(item.getId());
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent anEvent) {
            Point location = anEvent.getPoint();
            Rectangle r = new Rectangle();
            ITextWithCompletionPopUp.this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                ITextWithCompletionPopUp.this.updateListBoxSelectionForEvent(anEvent, true);
            }
        }
    }
}

