/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonSQLElement;
import org.openconcerto.erp.core.sales.shipment.report.BonLivraisonXmlSheet;
import org.openconcerto.erp.core.sales.shipment.ui.BonDeLivraisonItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class BonDeLivraisonSQLComponent
extends TransfertBaseSQLComponent {
    private BonDeLivraisonItemTable tableBonItem;
    private ElementComboBox selectCommande;
    private ElementComboBox comboClient;
    private PanelOOSQLComponent panelOO;
    private JUniqueTextField textNumeroUnique;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final DeviseField textTotalHT = new DeviseField(6);
    private final DeviseField textTotalTVA = new DeviseField(6);
    private final DeviseField textTotalTTC = new DeviseField(6);
    private final JTextField textPoidsTotal = new JTextField(6);
    private final JTextField textNom = new JTextField(25);

    public BonDeLivraisonSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON"));
    }

    @Override
    protected SQLRowValues createDefaults() {
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(BonDeLivraisonSQLElement.class));
        this.tableBonItem.getModel().clearRows();
        return super.createDefaults();
    }

    @Override
    public void addViews() {
        this.textTotalHT.setOpaque(false);
        this.textTotalTVA.setOpaque(false);
        this.textTotalTTC.setOpaque(false);
        this.selectCommande = new ElementComboBox();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelNum = new JLabel(this.getLabelFor("NUMERO"));
        labelNum.setHorizontalAlignment(4);
        this.add((Component)labelNum, c);
        this.textNumeroUnique = new JUniqueTextField(16);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroUnique);
        this.add((Component)this.textNumeroUnique, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("DATE"), 4), c);
        JDate date = new JDate(true);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)((Object)date), c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textNom, c);
        if (this.getTable().contains("DATE_LIVRAISON")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("DATE_LIVRAISON"), 4), c);
            JDate dateLivraison = new JDate(true);
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)((Object)dateLivraison), c);
            this.addView((JComponent)((Object)dateLivraison), "DATE_LIVRAISON");
        }
        JLabel labelClient = new JLabel(this.getLabelFor("ID_CLIENT"), 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        c.weighty = 0.0;
        this.add((Component)labelClient, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.comboClient = new ElementComboBox();
        this.add((Component)this.comboClient, c);
        if (this.getTable().contains("SPEC_LIVRAISON")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("SPEC_LIVRAISON"), 4), c);
            JTextField specLivraison = new JTextField();
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)specLivraison, c);
            this.addView(specLivraison, "SPEC_LIVRAISON");
        }
        final ElementComboBox boxTarif = new ElementComboBox();
        this.comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (BonDeLivraisonSQLComponent.this.comboClient.getElement().getTable().contains("ID_TARIF")) {
                    if (BonDeLivraisonSQLComponent.this.isFilling()) {
                        return;
                    }
                    SQLRow row = ((SQLRequestComboBox)evt.getSource()).getSelectedRow();
                    if (row != null) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") != 0)) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        }
                    }
                }
            }
        });
        JButton boutonAll = new JButton("Tout livrer");
        boutonAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowValuesTableModel m = BonDeLivraisonSQLComponent.this.tableBonItem.getModel();
                int i = 0;
                while (i < m.getRowCount()) {
                    SQLRowValues rowVals = m.getRowValuesAt(i);
                    Object o = rowVals.getObject("QTE");
                    int qte = o == null ? 0 : ((Number)o).intValue();
                    m.putValue(qte, i, "QTE_LIVREE");
                    ++i;
                }
            }
        });
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            this.add((Component)new JLabel("Tarif \u00e0 appliquer"), c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 1.0;
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    BonDeLivraisonSQLComponent.this.tableBonItem.setTarif(selectedRow, !BonDeLivraisonSQLComponent.this.isFilling());
                }
            });
        }
        if (this.getTable().contains("A_ATTENTION")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("A_ATTENTION"), 4), c);
            JTextField specLivraison = new JTextField();
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)specLivraison, c);
            this.addView(specLivraison, "A_ATTENTION");
        }
        ArrayList<JButton> l = new ArrayList<JButton>();
        l.add(boutonAll);
        this.tableBonItem = new BonDeLivraisonItemTable(l);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.tableBonItem, c);
        c.anchor = 13;
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.gridwidth = 1;
        c.fill = 0;
        this.addSQLObject(this.textPoidsTotal, "TOTAL_POIDS");
        this.addRequiredSQLObject(this.textTotalHT, "TOTAL_HT");
        this.addRequiredSQLObject(this.textTotalTVA, "TOTAL_TVA");
        this.addRequiredSQLObject(this.textTotalTTC, "TOTAL_TTC");
        TotalPanel panelTotal = new TotalPanel(this.tableBonItem, this.textTotalHT, this.textTotalTVA, this.textTotalTTC, new DeviseField(), new DeviseField(), new DeviseField(), new DeviseField(), new DeviseField(), this.textPoidsTotal, null);
        c.gridx = 2;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 2;
        this.add((Component)panelTotal, c);
        c.anchor = 17;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        TitledSeparator sep = new TitledSeparator("Informations compl\u00e9mentaires");
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        ITextArea textInfos = new ITextArea(4, 4);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(textInfos);
        this.add((Component)scrollPane, c);
        textInfos.setBorder(null);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        this.addRequiredSQLObject((JComponent)((Object)date), "DATE");
        this.addSQLObject(textInfos, "INFOS");
        this.addSQLObject(this.textNom, "NOM");
        this.addSQLObject(this.selectCommande, "ID_COMMANDE_CLIENT");
        this.addRequiredSQLObject(this.textNumeroUnique, "NUMERO");
        this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
    }

    private void reconfigure(JTextField field) {
        field.setEnabled(false);
        field.setHorizontalAlignment(4);
        field.setDisabledTextColor(Color.BLACK);
        field.setBorder(null);
    }

    @Override
    public int insert(SQLRow order) {
        int idBon = this.getSelectedID();
        if (this.textNumeroUnique.checkValidation()) {
            SQLPreferences prefs;
            idBon = super.insert(order);
            this.tableBonItem.updateField("ID_BON_DE_LIVRAISON", idBon);
            this.tableBonItem.createArticle(idBon, this.getElement());
            BonLivraisonXmlSheet bSheet = new BonLivraisonXmlSheet(this.getTable().getRow(idBon));
            bSheet.createDocumentAsynchronous();
            bSheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            if (NumerotationAutoSQLElement.getNextNumero(BonDeLivraisonSQLElement.class).equalsIgnoreCase(this.textNumeroUnique.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt("BON_L_START");
                rowVals.put("BON_L_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (!(prefs = new SQLPreferences(this.getTable().getDBRoot())).getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
                this.updateStock(idBon);
            }
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon de livraison existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idBon;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            this.textNumeroUnique.setIdSelected(r.getID());
        }
        if (r == null || r.getIDNumber() == null) {
            super.select(r);
        } else {
            System.err.println(r);
            SQLRowValues rVals = r.asRowValues();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            System.err.println("Select CLIENT");
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        }
        if (r != null) {
            this.tableBonItem.insertFrom("ID_BON_DE_LIVRAISON", r.getID());
        }
    }

    @Override
    public void update() {
        if (!this.textNumeroUnique.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon de livraison existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.tableBonItem.updateField("ID_BON_DE_LIVRAISON", this.getSelectedID());
        this.tableBonItem.createArticle(this.getSelectedID(), this.getElement());
        BonLivraisonXmlSheet bSheet = new BonLivraisonXmlSheet(this.getTable().getRow(this.getSelectedID()));
        bSheet.createDocumentAsynchronous();
        bSheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
        if (!prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
            SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", this.getSelectedID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l != null) {
                int i = 0;
                while (i < l.size()) {
                    Object[] tmp = (Object[])l.get(i);
                    try {
                        eltMvtStock.archive(((Number)tmp[0]).intValue());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            this.updateStock(this.getSelectedID());
        }
    }

    protected String getLibelleStock(SQLRow row, SQLRow rowElt) {
        return "BL N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) {
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (!prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
            MouvementStockSQLElement mvtStock = (MouvementStockSQLElement)Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            mvtStock.createMouvement(this.getTable().getRow(id), this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT"), new StockLabel(){

                @Override
                public String getLabel(SQLRow rowOrigin, SQLRow rowElt) {
                    return BonDeLivraisonSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
                }
            }, false);
        }
    }
}

