/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.CompteRowValuesRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.DeviseKmRowValuesRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.TextTableCellEditorWithCompletion;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.checks.ValidState;

public class SaisieKmItemTable
extends JPanel
implements MouseListener {
    private final RowValuesTable table;
    private final SQLTableElement debit;
    private final SQLTableElement credit;
    private final SQLTableElement tableElementNumeroCompte;
    private final CompteRowValuesRenderer numeroCompteRenderer = new CompteRowValuesRenderer();
    private final DeviseKmRowValuesRenderer deviseRenderer = new DeviseKmRowValuesRenderer();
    private final DeviseCellEditor deviseCellEditor = new DeviseCellEditor();

    public SaisieKmItemTable(SQLRowValues defaultRowVals) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_KM_ELEMENT");
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        this.tableElementNumeroCompte = new SQLTableElement(elt.getTable().getField("NUMERO"));
        list.add(this.tableElementNumeroCompte);
        SQLTableElement tableElementNomCompte = new SQLTableElement(elt.getTable().getField("NOM"));
        list.add(tableElementNomCompte);
        SQLTableElement tableElementNomEcriture = new SQLTableElement(elt.getTable().getField("NOM_ECRITURE"));
        list.add(tableElementNomEcriture);
        this.debit = new SQLTableElement(elt.getTable().getField("DEBIT"), Long.class, this.deviseCellEditor);
        list.add(this.debit);
        this.credit = new SQLTableElement(elt.getTable().getField("CREDIT"), Long.class, this.deviseCellEditor);
        list.add(this.credit);
        RowValuesTableModel model = new RowValuesTableModel(elt, list, elt.getTable().getField("NUMERO"), true, defaultRowVals){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                super.setValueAt(aValue, rowIndex, columnIndex);
                int debitIndex = this.getColumnIndexForElement(SaisieKmItemTable.this.debit);
                int creditIndex = this.getColumnIndexForElement(SaisieKmItemTable.this.credit);
                if (debitIndex == columnIndex && (Long)aValue != 0L && (Long)this.getValueAt(rowIndex, creditIndex) != 0L) {
                    this.setValueAt(0L, rowIndex, creditIndex);
                } else if (creditIndex == columnIndex && (Long)aValue != 0L && (Long)this.getValueAt(rowIndex, debitIndex) != 0L) {
                    this.setValueAt(0L, rowIndex, debitIndex);
                }
            }
        };
        this.table = new RowValuesTable(model, null);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        AutoCompletionManager m = new AutoCompletionManager(this.tableElementNumeroCompte, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("COMPTE_PCE.NUMERO"), this.table, this.table.getRowValuesTableModel(), 1, true, false, new ValidStateChecker(){
            ComptePCESQLElement elt = Configuration.getInstance().getDirectory().getElement(ComptePCESQLElement.class);

            @Override
            public ValidState getValidState(Object o) {
                if (o != null) {
                    return this.elt.getCompteNumeroValidState(o.toString());
                }
                return super.getValidState(o);
            }
        });
        m.fill("NOM", "NOM");
        m.setFillWithField("NUMERO");
        AutoCompletionManager m2 = new AutoCompletionManager(tableElementNomCompte, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("COMPTE_PCE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true);
        m2.fill("NUMERO", "NUMERO");
        m2.setFillWithField("NOM");
        TextTableCellEditorWithCompletion t = (TextTableCellEditorWithCompletion)this.tableElementNumeroCompte.getTableCellEditor(this.table);
        this.add((Component)new RowValuesTableControlPanel(this.table), c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.tableElementNumeroCompte.setRenderer(this.numeroCompteRenderer);
        this.debit.setRenderer(this.deviseRenderer);
        this.credit.setRenderer(this.deviseRenderer);
        this.table.addMouseListener(this);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    SaisieKmItemTable.this.editCellAt(e.getFirstRow(), 0);
                }
            }
        });
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getCreditElement() {
        return this.credit;
    }

    public SQLTableElement getDebitElement() {
        return this.debit;
    }

    public SQLTableElement getNumeroCompteElement() {
        return this.tableElementNumeroCompte;
    }

    public void setCreateAutoActive(boolean b) {
        this.numeroCompteRenderer.setCreateActive(b);
        this.table.revalidate();
        this.table.repaint();
    }

    public void setRowDeviseValidAt(boolean b, int index) {
        this.deviseRenderer.setValid(b, index);
    }

    public void editCellAt(int row, int column) {
        this.table.setColumnSelectionInterval(column, column);
        this.table.setRowSelectionInterval(row, row);
        this.table.editCellAt(row, column);
    }

    private long getContrepartie() {
        long totalCred = 0L;
        long totalDeb = 0L;
        long totalCredWithNoValid = 0L;
        long totalDebWithNoValid = 0L;
        RowValuesTableModel model = this.table.getRowValuesTableModel();
        int creditIndex = model.getColumnIndexForElement(this.getCreditElement());
        int debitIndex = model.getColumnIndexForElement(this.getDebitElement());
        int i = 0;
        while (i < this.table.getRowCount()) {
            long totalLine = 0L;
            boolean b = model.isRowValid(i);
            Long fTc = (Long)model.getValueAt(i, creditIndex);
            Long fTd = (Long)model.getValueAt(i, debitIndex);
            if (fTc != null) {
                if (b) {
                    totalCred += fTc.longValue();
                }
                totalCredWithNoValid += fTc.longValue();
                totalLine += fTc.longValue();
            }
            if (fTd != null) {
                if (b) {
                    totalDeb += fTd.longValue();
                }
                totalDebWithNoValid += fTd.longValue();
                totalLine += fTd.longValue();
            }
            ++i;
        }
        return totalDeb - totalCred;
    }

    private long getSoldeRow(int index) {
        if (index >= 0 && index < this.table.getRowCount()) {
            SQLRowValues rowVals = this.table.getRowValuesTableModel().getRowValuesAt(index);
            return rowVals.getLong("DEBIT") - rowVals.getLong("CREDIT");
        }
        return 0L;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        final int rowSel = this.table.getSelectedRow();
        if (e.getButton() == 3 && rowSel >= 0 && rowSel < this.table.getRowCount()) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Contrepartie"){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    long l = SaisieKmItemTable.this.getContrepartie();
                    if (SaisieKmItemTable.this.table.getRowValuesTableModel().isRowValid(rowSel)) {
                        l += SaisieKmItemTable.this.getSoldeRow(rowSel);
                    }
                    if (l > 0L) {
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(0L, rowSel, "DEBIT");
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(l, rowSel, "CREDIT");
                    } else {
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(0L, rowSel, "CREDIT");
                        SaisieKmItemTable.this.table.getRowValuesTableModel().putValue(-l, rowSel, "DEBIT");
                    }
                }
            });
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

