/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.common.ui.TotalCalculatorParameters;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.SwingWorker2;

public class TotalPanel
extends JPanel
implements TableModelListener {
    public static String MARGE_MARQUE = "MargeMarque";
    private RowValuesTable table;
    private DeviseField textTotalHT;
    private DeviseField textTotalHTSel;
    private DeviseField textTotalTVA;
    private DeviseField textTotalTVASel;
    private DeviseField textTotalTTC;
    private DeviseField textTotalTTCSel;
    private DeviseField textPortHT;
    private DeviseField textRemiseHT;
    private JTextField textPoids;
    private DeviseField textTotalDevise;
    private DeviseField textTotalDeviseSel;
    private DeviseField textService;
    private DeviseField textServiceSel;
    private DeviseField textHA;
    private DeviseField textHASel;
    private JTextField marge;
    private JTextField margeSel;
    private boolean gestionHA = false;
    private PropertyChangeSupport supp;
    private int columnIndexEchHT = -1;
    private int columnIndexEchTTC = -1;
    SQLTableElement ha;
    private SQLRequestComboBox selPortTVA;
    private TotalCalculator calc;
    AbstractArticleItemTable articleTable;
    private static String CLEAR = "";

    public TotalPanel(AbstractArticleItemTable articleItemTable, DeviseField textTotalHT, DeviseField textTotalTVA, DeviseField textTotalTTC, DeviseField textPortHT, DeviseField textRemiseHT, DeviseField textService, DeviseField textTotalHA, DeviseField textTotalDevise, JTextField textTotalPoids, JPanel tableEchantillon) {
        this(articleItemTable, textTotalHT, textTotalTVA, textTotalTTC, textPortHT, textRemiseHT, textService, textTotalHA, textTotalDevise, textTotalPoids, tableEchantillon, null);
    }

    public TotalPanel(AbstractArticleItemTable articleItemTable, DeviseField textTotalHT, DeviseField textTotalTVA, DeviseField textTotalTTC, DeviseField textPortHT, DeviseField textRemiseHT, DeviseField textService, DeviseField textTotalHA, DeviseField textTotalDevise, JTextField textTotalPoids, JPanel tableEchantillon, SQLRequestComboBox selPortTva) {
        this.selPortTVA = selPortTva;
        this.articleTable = articleItemTable;
        this.supp = new PropertyChangeSupport(this);
        this.table = articleItemTable.getRowValuesTable();
        this.ha = articleItemTable.getPrebilanElement() == null ? articleItemTable.getHaElement() : articleItemTable.getPrebilanElement();
        this.gestionHA = this.ha != null && articleItemTable.getQteElement() != null;
        this.textPoids = textTotalPoids == null ? new JTextField() : textTotalPoids;
        this.textTotalHT = textTotalHT;
        this.textTotalHT.setBold();
        this.textTotalTVA = textTotalTVA;
        this.textTotalTTC = textTotalTTC;
        this.textPortHT = textPortHT;
        this.textRemiseHT = textRemiseHT;
        this.textService = textService;
        this.textHA = textTotalHA == null ? new DeviseField() : textTotalHA;
        this.textHASel = new DeviseField();
        this.textTotalHTSel = new DeviseField(true);
        this.textServiceSel = new DeviseField();
        this.textTotalTTCSel = new DeviseField();
        this.textTotalTVASel = new DeviseField();
        this.marge = new JTextField();
        this.margeSel = new JTextField();
        if (articleItemTable.getTableElementTotalDevise() != null) {
            this.textTotalDevise = textTotalDevise;
            this.textTotalDeviseSel = new DeviseField();
            this.reconfigure(this.textTotalDevise);
            this.reconfigure(this.textTotalDeviseSel);
        }
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        this.reconfigure(this.textService);
        this.reconfigure(this.textHA);
        this.reconfigure(this.marge);
        this.reconfigure(this.textTotalHTSel);
        this.reconfigure(this.textTotalTVASel);
        this.reconfigure(this.textTotalTTCSel);
        this.reconfigure(this.textServiceSel);
        this.reconfigure(this.textHASel);
        this.reconfigure(this.margeSel);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 2;
        ++c.gridx;
        this.add((Component)new JLabelBold("S\u00e9lection"), c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        if (this.gestionHA) {
            ++c.gridy;
            this.add((Component)new JLabel("Total achat HT"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHASel, c);
            ++c.gridy;
            c.gridx = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Marge"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.margeSel, c);
            ++c.gridy;
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 1;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalHTSel, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Service HT inclus "), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textServiceSel, c);
        }
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelFor(textTotalTVA.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTVASel, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (articleItemTable.getTableElementTotalDevise() != null) {
            c.gridwidth = 1;
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelFor(textTotalDevise.getField()), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textTotalDeviseSel, c);
        }
        c.gridwidth = 1;
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelFor(textTotalTTC.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textTotalTTCSel, c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 0;
        c.weighty = 1.0;
        c.fill = 3;
        c.weightx = 0.0;
        this.add((Component)this.createSeparator(), c);
        c.gridheight = 1;
        c.fill = 2;
        c.weighty = 0.0;
        ++c.gridx;
        this.add((Component)new JLabelBold("Global"), c);
        ++c.gridy;
        c.gridx = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.createSeparator(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        if (this.gestionHA) {
            ++c.gridy;
            this.add((Component)new JLabel("Total achat HT"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textHA, c);
            ++c.gridy;
            c.gridx = 4;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Marge"), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.marge, c);
            ++c.gridy;
            c.gridx = 4;
            c.gridwidth = 2;
            c.weightx = 1.0;
            this.add((Component)this.createSeparator(), c);
            c.gridwidth = 1;
            c.weightx = 0.0;
        }
        ++c.gridy;
        c.gridx = 4;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalHT.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalHT, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabelBold("Service HT inclus "), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)this.textService, c);
        }
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTVA.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textTotalTVA, c);
        c.gridwidth = 2;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.createSeparator(), c);
        if (articleItemTable.getTableElementTotalDevise() != null) {
            c.gridwidth = 1;
            c.gridx = 4;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)TotalPanel.getLabelBoldFor(textTotalDevise.getField()), c);
            ++c.gridx;
            c.weightx = 1.0;
            textTotalDevise.setFont(textTotalHT.getFont());
            this.add((Component)textTotalDevise, c);
        }
        c.gridwidth = 1;
        c.gridx = 4;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)TotalPanel.getLabelBoldFor(textTotalTTC.getField()), c);
        ++c.gridx;
        c.weightx = 1.0;
        textTotalTTC.setFont(textTotalHT.getFont());
        this.add((Component)textTotalTTC, c);
        this.updateTotal();
        this.table.getRowValuesTableModel().addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TotalPanel.this.updateTotal();
            }
        });
    }

    private void reconfigure(JTextField field) {
        field.setEditable(false);
        field.setHorizontalAlignment(4);
        field.setBorder(null);
        field.setColumns(11);
        field.setOpaque(true);
        field.setMinimumSize(new Dimension(150, 20));
        field.setPreferredSize(new Dimension(150, 20));
        field.setBackground(UIManager.getColor("control"));
        field.setEditable(false);
        field.setEnabled(false);
        field.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateTotal();
    }

    private void clearTextField() {
        if (this.textTotalDevise != null) {
            this.textTotalDevise.setText(CLEAR);
            this.textTotalDeviseSel.setText(CLEAR);
        }
        this.textPoids.setText(CLEAR);
        this.textTotalHT.setText(CLEAR);
        this.textService.setText(CLEAR);
        this.textTotalTVA.setText(CLEAR);
        this.textTotalTTC.setText(CLEAR);
        this.textTotalHTSel.setText(CLEAR);
        this.textServiceSel.setText(CLEAR);
        this.textTotalTVASel.setText(CLEAR);
        this.textTotalTTCSel.setText(CLEAR);
        if (this.gestionHA) {
            this.textHA.setText(CLEAR);
            this.marge.setText(CLEAR);
            this.textHASel.setText(CLEAR);
            this.margeSel.setText(CLEAR);
        }
    }

    public void updateTotal() {
        SQLRowValues rowValsPort;
        SQLRow tvaPort;
        BigDecimal valPortHT;
        this.clearTextField();
        final List<SQLRowValues> list = this.articleTable.getModel().getCopyOfValues();
        final TotalCalculatorParameters params = new TotalCalculatorParameters(list);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        final int[] selectedRows = this.table.getSelectedRows();
        final long valRemiseHT = this.textRemiseHT.getText().trim().length() > 0 ? (!this.textRemiseHT.getText().trim().equals("-") ? GestionDevise.parseLongCurrency(this.textRemiseHT.getText().trim()) : 0L) : 0L;
        params.setRemiseHT(valRemiseHT);
        if (this.textPortHT.getText().trim().length() > 0) {
            if (!this.textPortHT.getText().trim().equals("-")) {
                long p = GestionDevise.parseLongCurrency(this.textPortHT.getText().trim());
                valPortHT = new BigDecimal(p).movePointLeft(2);
            } else {
                valPortHT = BigDecimal.ZERO;
            }
        } else {
            valPortHT = BigDecimal.ZERO;
        }
        params.setPortHT(valPortHT);
        SQLRow sQLRow = tvaPort = this.selPortTVA == null ? null : this.selPortTVA.getSelectedRow();
        if (tvaPort != null && !valPortHT.equals(BigDecimal.ZERO) && !tvaPort.isUndefined()) {
            rowValsPort = new SQLRowValues(this.articleTable.getSQLElement().getTable());
            rowValsPort.put(this.articleTable.getPrixTotalHTElement().getField().getName(), valPortHT);
            rowValsPort.put("QTE", 1);
            rowValsPort.put("ID_TAXE", tvaPort);
        } else {
            rowValsPort = null;
        }
        final Boolean isServiceActive = bServiceActive;
        SwingWorker2<TotalCalculator, Object> worker = new SwingWorker2<TotalCalculator, Object>(){

            @Override
            protected TotalCalculator doInBackground() throws Exception {
                BigDecimal totalHTAvtremise;
                params.fetchArticle();
                if (TotalPanel.this.calc == null) {
                    SQLTableElement tableElementTotalDevise = TotalPanel.this.articleTable.getTableElementTotalDevise();
                    String fieldDevise = tableElementTotalDevise == null ? null : tableElementTotalDevise.getField().getName();
                    SQLTableElement tableElementTotalHA = TotalPanel.this.articleTable.getPrebilanElement() == null ? TotalPanel.this.articleTable.getTotalHaElement() : TotalPanel.this.articleTable.getPrebilanElement();
                    String fieldHA = tableElementTotalHA == null ? null : tableElementTotalHA.getField().getName();
                    SQLTableElement tableElementTotalHT = TotalPanel.this.articleTable.getPrixTotalHTElement();
                    String fieldHT = tableElementTotalHT == null ? null : tableElementTotalHT.getField().getName();
                    TotalPanel.this.calc = new TotalCalculator(fieldHA, fieldHT, fieldDevise);
                }
                TotalPanel.this.calc.initValues();
                TotalPanel.this.calc.setSelectedRows(selectedRows);
                if (valRemiseHT != 0L) {
                    TotalPanel.this.calc.setServiceActive(isServiceActive);
                    int i = 0;
                    while (i < list.size()) {
                        SQLRowValues rowVals = (SQLRowValues)list.get(i);
                        TotalPanel.this.calc.addLine(rowVals, params.getMapArticle().get(rowVals.getInt("ID_ARTICLE")), i, false);
                        ++i;
                    }
                    totalHTAvtremise = TotalPanel.this.calc.getTotalHT();
                } else {
                    totalHTAvtremise = BigDecimal.ZERO;
                }
                TotalPanel.this.calc.initValues();
                TotalPanel.this.calc.setRemise(valRemiseHT, totalHTAvtremise);
                int rowCount = list.size();
                int i = 0;
                while (i < rowCount) {
                    SQLRowValues values = (SQLRowValues)list.get(i);
                    TotalPanel.this.calc.addLine(values, params.getMapArticle().get(values.getInt("ID_ARTICLE")), i, i == rowCount - 1);
                    ++i;
                }
                if (rowValsPort != null) {
                    TotalPanel.this.calc.addLine(rowValsPort, null, 0, false);
                }
                TotalPanel.this.calc.checkResult();
                return TotalPanel.this.calc;
            }

            @Override
            protected void done() {
                try {
                    TotalCalculator calc = (TotalCalculator)this.get();
                    BigDecimal totalHT = calc.getTotalHT();
                    if (TotalPanel.this.textTotalDevise != null) {
                        TotalPanel.this.textTotalDevise.setText(GestionDevise.currencyToString(calc.getTotalDevise().setScale(2, RoundingMode.HALF_UP)));
                        TotalPanel.this.textTotalDeviseSel.setText(GestionDevise.currencyToString(calc.getTotalDeviseSel().setScale(2, RoundingMode.HALF_UP)));
                    }
                    TotalPanel.this.textPoids.setText(String.valueOf(calc.getTotalPoids()));
                    TotalPanel.this.textTotalHT.setText(GestionDevise.currencyToString(totalHT));
                    TotalPanel.this.textService.setText(GestionDevise.currencyToString(calc.getTotalService().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTVA.setText(GestionDevise.currencyToString(calc.getTotalTVA().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTTC.setText(GestionDevise.currencyToString(calc.getTotalTTC().setScale(2, RoundingMode.HALF_UP)));
                    BigDecimal totalHTSel = calc.getTotalHTSel();
                    TotalPanel.this.textTotalHTSel.setText(GestionDevise.currencyToString(totalHTSel.setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textServiceSel.setText(GestionDevise.currencyToString(calc.getTotalServiceSel().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTVASel.setText(GestionDevise.currencyToString(calc.getTotalTVASel().setScale(2, RoundingMode.HALF_UP)));
                    TotalPanel.this.textTotalTTCSel.setText(GestionDevise.currencyToString(calc.getTotalTTCSel().setScale(2, RoundingMode.HALF_UP)));
                    if (TotalPanel.this.gestionHA) {
                        BigDecimal totalHA = calc.getTotalHA();
                        TotalPanel.this.textHA.setText(GestionDevise.currencyToString(totalHA.setScale(2, RoundingMode.HALF_UP)));
                        BigDecimal m = BigDecimal.ZERO;
                        BigDecimal d = BigDecimal.ZERO;
                        if (totalHA.compareTo(BigDecimal.ZERO) > 0) {
                            d = totalHT.subtract(totalHA);
                            m = DefaultNXProps.getInstance().getBooleanValue(MARGE_MARQUE, false) ? d.divide(totalHT, MathContext.DECIMAL128).movePointRight(2) : d.divide(totalHA, MathContext.DECIMAL128).movePointRight(2);
                        }
                        if (d.compareTo(BigDecimal.ZERO) <= 0) {
                            TotalPanel.this.marge.setForeground(Color.red);
                            TotalPanel.this.marge.setDisabledTextColor(Color.RED);
                        } else {
                            TotalPanel.this.marge.setForeground(TotalPanel.this.textTotalTTC.getForeground());
                            TotalPanel.this.marge.setDisabledTextColor(TotalPanel.this.textTotalTTC.getForeground());
                        }
                        TotalPanel.this.marge.setText("(" + m.setScale(2, RoundingMode.HALF_UP) + "%) " + GestionDevise.currencyToString(d.setScale(2, RoundingMode.HALF_UP)));
                        BigDecimal totalHASel = calc.getTotalHASel();
                        TotalPanel.this.textHASel.setText(GestionDevise.currencyToString(totalHASel.setScale(2, RoundingMode.HALF_UP)));
                        BigDecimal m2 = BigDecimal.ZERO;
                        BigDecimal e = BigDecimal.ZERO;
                        if (totalHASel.compareTo(BigDecimal.ZERO) > 0) {
                            e = totalHTSel.subtract(totalHASel);
                            m2 = DefaultNXProps.getInstance().getBooleanValue(MARGE_MARQUE, false) ? e.divide(totalHTSel, MathContext.DECIMAL128).movePointRight(2) : e.divide(totalHASel, MathContext.DECIMAL128).movePointRight(2);
                        }
                        TotalPanel.this.margeSel.setText("(" + m2.setScale(2, RoundingMode.HALF_UP) + "%) " + GestionDevise.currencyToString(e.setScale(2, RoundingMode.HALF_UP)));
                        if (e.compareTo(BigDecimal.ZERO) <= 0) {
                            TotalPanel.this.margeSel.setForeground(Color.red);
                            TotalPanel.this.margeSel.setDisabledTextColor(Color.RED);
                        } else {
                            TotalPanel.this.margeSel.setForeground(TotalPanel.this.textTotalTTC.getForeground());
                            TotalPanel.this.margeSel.setDisabledTextColor(TotalPanel.this.textTotalTTC.getForeground());
                        }
                    }
                    TotalPanel.this.supp.firePropertyChange("value", null, null);
                }
                catch (InterruptedException e1) {
                    ExceptionHandler.handle("", e1);
                }
                catch (ExecutionException e1) {
                    ExceptionHandler.handle("", e1);
                }
            }
        };
        worker.execute();
    }

    private static final JLabel getLabelFor(SQLField field) {
        return new JLabel(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    private static final JLabel getLabelBoldFor(SQLField field) {
        return new JLabelBold(Configuration.getInstance().getTranslator().getLabelFor(field));
    }

    private final JSeparator createSeparator() {
        JSeparator sep = new JSeparator(0);
        DefaultGridBagConstraints.lockMinimumSize(sep);
        return sep;
    }
}

