/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class TotalCalculatorParameters {
    private List<? extends SQLRowAccessor> values;
    private long remiseHT;
    private BigDecimal portHT;
    private Map<Integer, SQLRowAccessor> mapArticle = new HashMap<Integer, SQLRowAccessor>();
    final SQLTable articleTable = Configuration.getInstance().getRoot().findTable("ARTICLE");
    final SQLTable compteTable = Configuration.getInstance().getRoot().findTable("COMPTE_PCE");
    final SQLTable familleArticleTable = Configuration.getInstance().getRoot().findTable("FAMILLE_ARTICLE");

    public TotalCalculatorParameters(List<? extends SQLRowAccessor> values) {
        this.values = values;
        this.remiseHT = 0L;
        this.portHT = BigDecimal.ZERO;
    }

    public void setPortHT(BigDecimal portHT) {
        this.portHT = portHT;
    }

    public void setRemiseHT(long remiseHT) {
        this.remiseHT = remiseHT;
    }

    public Map<Integer, SQLRowAccessor> getMapArticle() {
        return this.mapArticle;
    }

    public void fetchArticle() {
        final ArrayList<Integer> l = new ArrayList<Integer>(this.values.size());
        for (SQLRowAccessor sQLRowAccessor : this.values) {
            l.add(sQLRowAccessor.getID());
        }
        SQLRowValues sQLRowValues = new SQLRowValues(this.articleTable);
        SQLRowValues rowValsF = new SQLRowValues(this.familleArticleTable);
        rowValsF.put("NOM", null);
        rowValsF.put("ID", null);
        SQLRowValues rowValsC1 = new SQLRowValues(this.compteTable);
        rowValsC1.put("NUMERO", null);
        rowValsC1.put("ID", null);
        SQLRowValues rowValsC2 = new SQLRowValues(this.compteTable);
        rowValsC2.put("NUMERO", null);
        rowValsC2.put("ID", null);
        sQLRowValues.put("ID", null);
        rowValsF.put("ID_COMPTE_PCE", rowValsC2);
        sQLRowValues.put("ID_FAMILLE_ARTICLE", rowValsF);
        sQLRowValues.put("ID_COMPTE_PCE", rowValsC1);
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(sQLRowValues);
        fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.andWhere(new Where(TotalCalculatorParameters.this.articleTable.getKey(), l));
                return input;
            }
        });
        System.err.println(fetch.getReq().asString());
        List<SQLRowValues> rowValsList = fetch.fetch();
        for (SQLRowValues sqlRowValues : rowValsList) {
            this.mapArticle.put(sqlRowValues.getID(), sqlRowValues);
        }
    }
}

