/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.File;
import javax.swing.JFrame;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.panel.ODSViewerPanel;
import org.jopendocument.print.DefaultXMLDocumentPrinter;
import org.jopendocument.print.DocumentPrinter;

public class PreviewFrame
extends JFrame {
    private PreviewFrame(File file) {
        OpenDocument doc = new OpenDocument(file);
        this.setContentPane((Container)new ODSViewerPanel(doc, (DocumentPrinter)new DefaultXMLDocumentPrinter()));
        this.setTitle(file.getName());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.setMaximizedBounds(ge.getMaximumWindowBounds());
        Dimension maxD = ge.getMaximumWindowBounds().getSize();
        this.setMaximumSize(maxD);
        this.pack();
        Dimension d = this.getSize();
        if (d.width > maxD.width) {
            d.setSize(maxD.width, d.height);
        }
        if (d.height > maxD.height) {
            d.setSize(d.width, maxD.height);
        }
        this.setSize(d);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
    }

    public static void show(File f) {
        new PreviewFrame(f).setVisible(true);
    }
}

