/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.utils.JImage;

public class NewsUpdater {
    public NewsUpdater(final JImage image) {
        Thread tDownloader = new Thread(new Runnable(){

            @Override
            public void run() {
                String id = ComptaPropsConfiguration.getInstance().getAppID();
                String imageUrl = "http://www.ilm-informatique.fr/news/" + id + ".png";
                try {
                    int numRead;
                    URL location = new URL(imageUrl);
                    File tempFile = File.createTempFile("newsupdater_image", ".png");
                    FileOutputStream out = new FileOutputStream(tempFile);
                    URLConnection conn = location.openConnection();
                    InputStream in = conn.getInputStream();
                    byte[] buffer = new byte[1024];
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                    }
                    out.close();
                    in.close();
                    final ImageIcon im = new ImageIcon(tempFile.getAbsolutePath());
                    if (im.getImageLoadStatus() == 8) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                image.invalidate();
                                image.setImage(im.getImage());
                                image.revalidate();
                                image.repaint();
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    System.err.println("Unable to get:" + imageUrl);
                }
            }
        }, "News updater");
        tDownloader.setPriority(1);
        Random r = new Random();
        if (r.nextInt(3) == 0) {
            tDownloader.start();
        }
    }
}

