/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.convertor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class NumberConvertor<T extends Number, U extends Number> {
    public static final NumberConvertor<Integer, Long> INT_TO_LONG = new NumberConvertor<Integer, Long>(){};
    public static final NumberConvertor<Short, Integer> SHORT_TO_INT = new NumberConvertor<Short, Integer>(){};
    public static final BigDecimal MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
    public static final BigDecimal MIN_FLOAT = MAX_FLOAT.negate();
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate();

    public static <N extends Number> N convert(Number n, Class<N> clazz) {
        Number res;
        if (n == null || n.getClass() == clazz || clazz == Number.class) {
            res = n;
        } else if (clazz == Short.class) {
            res = n.shortValue();
        } else if (clazz == Integer.class) {
            res = n.intValue();
        } else if (clazz == Long.class) {
            res = n.longValue();
        } else if (clazz == Byte.class) {
            res = n.byteValue();
        } else if (clazz == BigInteger.class) {
            res = n instanceof BigDecimal ? ((BigDecimal)n).toBigInteger() : (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong ? BigInteger.valueOf(n.longValue()) : (n instanceof Float || n instanceof Double ? BigDecimal.valueOf(n.doubleValue()).toBigInteger() : new BigInteger(n.toString())));
        } else if (clazz == AtomicInteger.class) {
            res = new AtomicInteger(n.intValue());
        } else if (clazz == AtomicLong.class) {
            res = new AtomicLong(n.longValue());
        } else if (clazz == BigDecimal.class) {
            res = NumberConvertor.toBigDecimal(n);
        } else if (clazz == Double.class) {
            res = n.doubleValue();
        } else if (clazz == Float.class) {
            res = Float.valueOf(n.floatValue());
        } else {
            throw new IllegalArgumentException("unknown class: " + clazz);
        }
        return (N)((Number)clazz.cast(res));
    }

    public static BigDecimal toBigDecimal(Number n) {
        BigDecimal res = n == null || n instanceof BigDecimal ? (BigDecimal)n : (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof AtomicInteger || n instanceof Long || n instanceof AtomicLong ? BigDecimal.valueOf(n.longValue()) : (n instanceof Float || n instanceof Double ? BigDecimal.valueOf(n.doubleValue()) : (n instanceof BigInteger ? new BigDecimal((BigInteger)n) : new BigDecimal(n.toString()))));
        return res;
    }
}

