/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openconcerto.utils.cache.ICache;

public abstract class CacheWatcher<K, D> {
    private final ICache<K, ?, D> c;
    private final Set<K> keys;
    private final D data;

    protected CacheWatcher(ICache<K, ?, D> c, D data) {
        this.c = c;
        this.keys = new HashSet<K>();
        this.data = data;
    }

    public final D getData() {
        return this.data;
    }

    synchronized boolean isEmpty() {
        return this.keys.isEmpty();
    }

    final synchronized void add(K key) {
        this.keys.add(key);
    }

    final synchronized void remove(K key) {
        this.keys.remove(key);
    }

    public final synchronized void die() {
        this.dying();
        this.clearCache();
    }

    protected void dying() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        ICache<K, ?, D> iCache = this.c;
        synchronized (iCache) {
            CacheWatcher cacheWatcher = this;
            synchronized (cacheWatcher) {
                Iterator<K> iter = this.keys.iterator();
                while (iter.hasNext()) {
                    K key = iter.next();
                    iter.remove();
                    this.c.clear(key);
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.getData();
    }
}

