/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openconcerto.utils.ExceptionHandler;

public class JImage
extends JComponent {
    private Image image;
    private ImageIcon icon;
    private boolean centered;
    private String hyperlink;

    public JImage(URL url) {
        this(new ImageIcon(url));
    }

    public JImage(ImageIcon img) {
        this(img.getImage());
        this.icon = img;
    }

    public JImage(Image img) {
        this.image = img;
        this.icon = null;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JImage.this.hyperlink != null) {
                    try {
                        URI uri = new URI(JImage.this.hyperlink);
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle("Impossible d'ouvir l'URL " + JImage.this.hyperlink, ex);
                    }
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JImage.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JImage.this.setCursor(new Cursor(0));
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        int imageW = this.image.getWidth(null);
        if (!this.centered) {
            g.fillRect(imageW, 0, this.getBounds().width - imageW, this.getBounds().height);
            g.drawImage(this.image, 0, 0, null);
        } else {
            int dx = (this.getBounds().width - imageW) / 2;
            g.fillRect(0, 0, dx, this.getBounds().height);
            g.fillRect(0, 0, dx + imageW, this.getBounds().height);
            g.drawImage(this.image, dx, 0, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }
}

