/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;

class ToRefreshSpec {
    private TablesMap tablesFromXML = new TablesMap();
    private TablesMap tablesFromJDBC = new TablesMap();

    private static final TablesMap createMap(DBSystemRoot sysRoot) {
        TablesMap res = new TablesMap();
        for (DBRoot r : sysRoot.getChildrenMap().values()) {
            res.put(r.getName(), r.getChildrenNames());
        }
        return res;
    }

    private static TablesMap fillMap(TablesMap toRefresh, DBSystemRoot sysRoot) {
        if (toRefresh == null) {
            return ToRefreshSpec.createMap(sysRoot);
        }
        TablesMap res = TablesMap.create(toRefresh);
        for (Map.Entry e : toRefresh.entrySet()) {
            String rootName = (String)e.getKey();
            if (!sysRoot.contains(rootName)) {
                res.remove(rootName);
                continue;
            }
            Set<String> newTableNames = sysRoot.getRoot(rootName).getChildrenNames();
            if (e.getValue() == null) {
                res.put(rootName, newTableNames);
                continue;
            }
            ((Set)res.get(rootName)).retainAll(newTableNames);
        }
        return res;
    }

    ToRefreshSpec() {
    }

    public final TablesMap getTablesFromXML() {
        return this.tablesFromXML;
    }

    public final TablesMap getTablesFromJDBC() {
        return this.tablesFromJDBC;
    }

    private final boolean isInScope(TablesMap m, SQLTable t) {
        String rootName = t.getDBRoot().getName();
        if (!m.containsKey(rootName)) {
            return false;
        }
        Collection values = (Collection)m.get(rootName);
        return values == null || values.contains(t.getName());
    }

    private final boolean isAnyInScope() {
        return this.tablesFromXML == null || this.tablesFromJDBC == null;
    }

    public final boolean isInScope(SQLTable t) {
        if (this.isAnyInScope()) {
            return true;
        }
        return this.isInScope(this.tablesFromXML, t) || this.isInScope(this.tablesFromJDBC, t);
    }

    public final ToRefreshSpec add(TablesMap tablesRefreshed, boolean readCache) {
        TablesMap tablesByRoot;
        TablesMap tablesMap = tablesByRoot = readCache ? this.tablesFromXML : this.tablesFromJDBC;
        if (tablesByRoot != null) {
            if (tablesRefreshed == null) {
                if (readCache) {
                    this.tablesFromXML = null;
                } else {
                    this.tablesFromJDBC = null;
                }
            } else {
                tablesByRoot.addAll(tablesRefreshed);
            }
        }
        return this;
    }

    private final Set<SQLTable> getTablesInScope(Set<SQLTable> tables) {
        if (this.isAnyInScope()) {
            return new HashSet<SQLTable>(tables);
        }
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (SQLTable t : tables) {
            if (!this.isInScope(t)) continue;
            res.add(t);
        }
        return res;
    }

    public final ToRefreshActual getActual(DBSystemRoot sysRoot, Set<SQLTable> currentGraphTables) {
        TablesMap fromJDBC;
        TablesMap fromXML;
        if (this.tablesFromJDBC == null) {
            fromXML = new TablesMap();
            fromJDBC = ToRefreshSpec.createMap(sysRoot);
        } else {
            fromXML = ToRefreshSpec.fillMap(this.tablesFromXML, sysRoot);
            fromJDBC = ToRefreshSpec.fillMap(this.tablesFromJDBC, sysRoot);
            fromXML.removeAll(fromJDBC);
            fromXML.removeAllEmptyCollections();
        }
        Set<SQLTable> toAdd = this.getTablesInScope(sysRoot.getDescs(SQLTable.class));
        Set<SQLTable> toRm = this.getTablesInScope(currentGraphTables);
        return new ToRefreshActual(fromXML, fromJDBC, toRm, toAdd);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " :\nfrom XML " + this.getTablesFromXML() + "\nfrom JDBC " + this.getTablesFromJDBC();
    }

    static final class ToRefreshActual {
        private final TablesMap fromXML;
        private final TablesMap fromJDBC;
        private final Set<SQLTable> oldTables;
        private final Set<SQLTable> newTables;

        private ToRefreshActual(TablesMap fromXML, TablesMap fromJDBC, Set<SQLTable> oldTables, Set<SQLTable> newTables) {
            this.fromXML = fromXML;
            this.fromJDBC = fromJDBC;
            this.oldTables = oldTables;
            this.newTables = newTables;
        }

        public final TablesMap getFromXML() {
            return this.fromXML;
        }

        public final TablesMap getFromJDBC() {
            return this.fromJDBC;
        }

        public final Set<SQLTable> getOldTablesInScope() {
            return this.oldTables;
        }

        public final Set<SQLTable> getNewTablesInScope() {
            return this.newTables;
        }
    }
}

