/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.store.fs.FileRec;
import org.h2.store.fs.Recorder;

public class FilePathRec
extends FilePathWrapper {
    private static final FilePathRec INSTANCE = new FilePathRec();
    private static Recorder recorder;

    public static void register() {
        FilePath.register(INSTANCE);
    }

    public boolean createFile() {
        this.log(2, this.name);
        return super.createFile();
    }

    public FilePath createTempFile(String string, boolean bl, boolean bl2) throws IOException {
        this.log(3, this.unwrap(this.name) + ":" + string + ":" + bl + ":" + bl2);
        return super.createTempFile(string, bl, bl2);
    }

    public void delete() {
        this.log(4, this.name);
        super.delete();
    }

    public FileChannel open(String string) throws IOException {
        return new FileRec(this, super.open(string), this.name);
    }

    public OutputStream newOutputStream(boolean bl) {
        this.log(5, this.name);
        return super.newOutputStream(bl);
    }

    public void moveTo(FilePath filePath) {
        this.log(6, this.unwrap(this.name) + ":" + this.unwrap(filePath.name));
        super.moveTo(filePath);
    }

    void log(int n, String string) {
        this.log(n, string, null, 0L);
    }

    void log(int n, String string, byte[] byArray, long l) {
        if (recorder != null) {
            recorder.log(n, string, byArray, l);
        }
    }

    public String getScheme() {
        return "rec";
    }
}

