/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Request;
import com.jcraft.jsch.RequestAgentForwarding;
import com.jcraft.jsch.RequestEnv;
import com.jcraft.jsch.RequestPtyReq;
import com.jcraft.jsch.RequestX11;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.util.Enumeration;
import java.util.Hashtable;

class ChannelSession
extends Channel {
    private static byte[] _session = Util.str2byte("session");
    protected boolean agent_forwarding = false;
    protected boolean xforwading = false;
    protected Hashtable env = null;
    protected boolean pty = false;
    protected String ttype = "vt100";
    protected int tcol = 80;
    protected int trow = 24;
    protected int twp = 640;
    protected int thp = 480;
    protected byte[] terminal_mode = null;

    ChannelSession() {
        this.type = _session;
        this.io = new IO();
    }

    protected void sendRequests() throws Exception {
        Request request;
        Session session = this.getSession();
        if (this.agent_forwarding) {
            request = new RequestAgentForwarding();
            request.request(session, this);
        }
        if (this.xforwading) {
            request = new RequestX11();
            request.request(session, this);
        }
        if (this.pty) {
            request = new RequestPtyReq();
            ((RequestPtyReq)request).setTType(this.ttype);
            ((RequestPtyReq)request).setTSize(this.tcol, this.trow, this.twp, this.thp);
            if (this.terminal_mode != null) {
                ((RequestPtyReq)request).setTerminalMode(this.terminal_mode);
            }
            request.request(session, this);
        }
        if (this.env != null) {
            Enumeration enumeration = this.env.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.env.get(k);
                request = new RequestEnv();
                ((RequestEnv)request).setEnv(this.toByteArray(k), this.toByteArray(v));
                request.request(session, this);
            }
        }
    }

    private byte[] toByteArray(Object object) {
        if (object instanceof String) {
            return Util.str2byte((String)object);
        }
        return (byte[])object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = -1;
        try {
            while (this.isConnected() && this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 32 - 20);
                if (n == 0) continue;
                if (n == -1) {
                    this.eof();
                } else if (!this.close) {
                    packet.reset();
                    buffer.putByte((byte)94);
                    buffer.putInt(this.recipient);
                    buffer.putInt(n);
                    buffer.skip(n);
                    this.getSession().write(packet, this, n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread thread = this.thread;
        if (thread != null) {
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notifyAll();
            }
        }
        this.thread = null;
    }
}

