/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.sql.SQLException;
import org.postgresql.copy.CopyOperation;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class CopyOperationImpl
implements CopyOperation {
    QueryExecutorImpl queryExecutor;
    int rowFormat;
    int[] fieldFormats;
    long handledRowCount = -1L;

    void init(QueryExecutorImpl q, int fmt, int[] fmts) {
        this.queryExecutor = q;
        this.rowFormat = fmt;
        this.fieldFormats = fmts;
    }

    @Override
    public void cancelCopy() throws SQLException {
        this.queryExecutor.cancelCopy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            return this.queryExecutor.hasLock(this);
        }
    }

    public void handleCommandStatus(String status) throws PSQLException {
        if (!status.startsWith("COPY")) {
            throw new PSQLException(GT.tr("CommandComplete expected COPY but got: " + status), PSQLState.COMMUNICATION_ERROR);
        }
        int i = status.lastIndexOf(32);
        this.handledRowCount = i > 3 ? Long.parseLong(status.substring(i + 1)) : -1L;
    }

    @Override
    public long getHandledRowCount() {
        return this.handledRowCount;
    }
}

